/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.monitoring;

import org.apache.commons.math.stat.descriptive.DescriptiveStatistics;
import org.apache.commons.math.stat.descriptive.SynchronizedDescriptiveStatistics;

public class StatCollector {
    private static final int DEFAULT_WINDOW_SIZE = 100;
    private final DescriptiveStatistics _stats = new SynchronizedDescriptiveStatistics();
    private long _numDataPoints;
    private long _totalSum;

    public StatCollector() {
        this._stats.setWindowSize(100);
    }

    public void addData(double data) {
        ++this._numDataPoints;
        this._totalSum = (long)((double)this._totalSum + data);
        this._stats.addValue(data);
    }

    public long getTotalSum() {
        return this._totalSum;
    }

    public DescriptiveStatistics getStatistics() {
        return this._stats;
    }

    public long getNumDataPoints() {
        return this._numDataPoints;
    }

    public void reset() {
        this._numDataPoints = 0L;
        this._totalSum = 0L;
        this._stats.clear();
    }

    public double getMean() {
        if (this._stats.getN() == 0L) {
            return 0.0;
        }
        return this._stats.getMean();
    }

    public double getMax() {
        return this._stats.getMax();
    }

    public double getMin() {
        return this._stats.getMin();
    }

    public double getPercentile(int percentage) {
        if (this._stats.getN() == 0L) {
            return 0.0;
        }
        return this._stats.getPercentile((double)percentage * 1.0);
    }
}

