/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.model;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.TimeZone;
import org.apache.helix.HelixProperty;
import org.apache.helix.ZNRecord;

public class ParticipantHistory
extends HelixProperty {
    private static final int HISTORY_SIZE = 10;
    public static long ONLINE = -1L;

    public ParticipantHistory(String id) {
        super(id);
    }

    public ParticipantHistory(ZNRecord znRecord) {
        super(znRecord);
    }

    public void reportOffline() {
        long time = System.currentTimeMillis();
        this._record.setSimpleField(ConfigProperty.LAST_OFFLINE_TIME.name(), String.valueOf(time));
    }

    public void reportOnline(String sessionId) {
        this.updateSessionHistory(sessionId);
        this._record.setSimpleField(ConfigProperty.LAST_OFFLINE_TIME.name(), String.valueOf(ONLINE));
    }

    public Long getLastOfflineTime() {
        String time = this._record.getSimpleField(ConfigProperty.LAST_OFFLINE_TIME.name());
        if (time == null) {
            return ONLINE;
        }
        return Long.valueOf(time);
    }

    private void updateSessionHistory(String sessionId) {
        List<String> list = this._record.getListField(ConfigProperty.HISTORY.name());
        if (list == null) {
            list = new ArrayList<String>();
            this._record.setListField(ConfigProperty.HISTORY.name(), list);
        }
        if (list.size() == 10) {
            list.remove(0);
        }
        HashMap<String, String> sessionEntry = new HashMap<String, String>();
        sessionEntry.put(ConfigProperty.SESSION.name(), sessionId);
        long timeMillis = System.currentTimeMillis();
        sessionEntry.put(ConfigProperty.TIME.name(), String.valueOf(timeMillis));
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss:SSS");
        df.setTimeZone(TimeZone.getTimeZone("UTC"));
        String dateTime = df.format(new Date(timeMillis));
        sessionEntry.put(ConfigProperty.DATE.name(), dateTime);
        list.add(((Object)sessionEntry).toString());
    }

    @Override
    public boolean isValid() {
        return true;
    }

    private static enum ConfigProperty {
        TIME,
        DATE,
        SESSION,
        HISTORY,
        LAST_OFFLINE_TIME;

    }
}

