/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.helix.HelixProperty;
import org.apache.helix.ZNRecord;
import org.apache.helix.api.config.StateTransitionThrottleConfig;

public class ClusterConfig
extends HelixProperty {
    private static final int DEFAULT_MAX_CONCURRENT_TASK_PER_INSTANCE = 40;

    public ClusterConfig(String cluster) {
        super(cluster);
    }

    public ClusterConfig(ZNRecord record) {
        super(record);
    }

    public Boolean isPersistBestPossibleAssignment() {
        return this._record.getBooleanField(ClusterConfigProperty.PERSIST_BEST_POSSIBLE_ASSIGNMENT.toString(), false);
    }

    public void setPersistBestPossibleAssignment(Boolean enable) {
        if (enable == null) {
            this._record.getSimpleFields().remove(ClusterConfigProperty.PERSIST_BEST_POSSIBLE_ASSIGNMENT.toString());
        } else {
            this._record.setBooleanField(ClusterConfigProperty.PERSIST_BEST_POSSIBLE_ASSIGNMENT.toString(), enable);
        }
    }

    public Boolean isPersistIntermediateAssignment() {
        return this._record.getBooleanField(ClusterConfigProperty.PERSIST_INTERMEDIATE_ASSIGNMENT.toString(), false);
    }

    public void setPersistIntermediateAssignment(Boolean enable) {
        if (enable == null) {
            this._record.getSimpleFields().remove(ClusterConfigProperty.PERSIST_INTERMEDIATE_ASSIGNMENT.toString());
        } else {
            this._record.setBooleanField(ClusterConfigProperty.PERSIST_INTERMEDIATE_ASSIGNMENT.toString(), enable);
        }
    }

    public Boolean isPipelineTriggersDisabled() {
        return this._record.getBooleanField(ClusterConfigProperty.HELIX_DISABLE_PIPELINE_TRIGGERS.toString(), false);
    }

    public long getRebalanceDelayTime() {
        return this._record.getLongField(ClusterConfigProperty.DELAY_REBALANCE_TIME.name(), -1L);
    }

    public boolean isDelayRebalaceDisabled() {
        return this._record.getBooleanField(ClusterConfigProperty.DELAY_REBALANCE_DISABLED.name(), false);
    }

    public void setBatchStateTransitionMaxThreads(int maxThreads) {
        this._record.setIntField(ClusterConfigProperty.BATCH_STATE_TRANSITION_MAX_THREADS.name(), maxThreads);
    }

    public int getBatchStateTransitionMaxThreads() {
        return this._record.getIntField(ClusterConfigProperty.BATCH_STATE_TRANSITION_MAX_THREADS.name(), -1);
    }

    public int getMaxConcurrentTaskPerInstance() {
        return this._record.getIntField(ClusterConfigProperty.MAX_CONCURRENT_TASK_PER_INSTANCE.name(), 40);
    }

    public void stateTransitionCancelEnabled(Boolean enable) {
        if (enable == null) {
            this._record.getSimpleFields().remove(ClusterConfigProperty.STATE_TRANSITION_CANCELLATION_ENABLED.name());
        } else {
            this._record.setBooleanField(ClusterConfigProperty.STATE_TRANSITION_CANCELLATION_ENABLED.name(), enable);
        }
    }

    public boolean isStateTransitionCancelEnabled() {
        return this._record.getBooleanField(ClusterConfigProperty.STATE_TRANSITION_CANCELLATION_ENABLED.name(), false);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof ClusterConfig) {
            ClusterConfig that = (ClusterConfig)obj;
            if (this.getId().equals(that.getId())) {
                return true;
            }
        }
        return false;
    }

    public List<StateTransitionThrottleConfig> getStateTransitionThrottleConfigs() {
        List<String> configs = this._record.getListField(ClusterConfigProperty.STATE_TRANSITION_THROTTLE_CONFIGS.name());
        if (configs == null || configs.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<StateTransitionThrottleConfig> throttleConfigs = new ArrayList<StateTransitionThrottleConfig>();
        for (String configstr : configs) {
            StateTransitionThrottleConfig throttleConfig = StateTransitionThrottleConfig.fromJSON(configstr);
            if (throttleConfig == null) continue;
            throttleConfigs.add(throttleConfig);
        }
        return throttleConfigs;
    }

    public void setStateTransitionThrottleConfigs(List<StateTransitionThrottleConfig> throttleConfigs) {
        ArrayList<String> configStrs = new ArrayList<String>();
        for (StateTransitionThrottleConfig throttleConfig : throttleConfigs) {
            String configStr = throttleConfig.toJSON();
            if (configStr == null) continue;
            configStrs.add(configStr);
        }
        if (!configStrs.isEmpty()) {
            this._record.setListField(ClusterConfigProperty.STATE_TRANSITION_THROTTLE_CONFIGS.name(), configStrs);
        }
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public String getClusterName() {
        return this._record.getId();
    }

    public static enum ClusterConfigProperty {
        HELIX_DISABLE_PIPELINE_TRIGGERS,
        PERSIST_BEST_POSSIBLE_ASSIGNMENT,
        PERSIST_INTERMEDIATE_ASSIGNMENT,
        TOPOLOGY,
        FAULT_ZONE_TYPE,
        DELAY_REBALANCE_DISABLED,
        DELAY_REBALANCE_TIME,
        STATE_TRANSITION_THROTTLE_CONFIGS,
        STATE_TRANSITION_CANCELLATION_ENABLED,
        BATCH_STATE_TRANSITION_MAX_THREADS,
        MAX_CONCURRENT_TASK_PER_INSTANCE;

    }
}

