/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.internal.common;

import com.linkedin.data.DataList;
import com.linkedin.data.DataMap;
import com.linkedin.jersey.api.uri.UriComponent;
import com.linkedin.restli.internal.common.PathSegment;
import com.linkedin.restli.internal.common.URIConstants;
import java.util.LinkedList;
import java.util.Queue;

public class URIElementParser {
    public static Object parse(String element) throws PathSegment.PathSegmentSyntaxException {
        Queue<Token> tokens = URIElementParser.tokenizeElement(element);
        Object result = URIElementParser.parseElement(tokens);
        if (!tokens.isEmpty()) {
            throw new PathSegment.PathSegmentSyntaxException("tokens left over after parsing; first excess token: " + tokens.peek().toErrorString());
        }
        return result;
    }

    private static Object parseElement(Queue<Token> tokenQueue) throws PathSegment.PathSegmentSyntaxException {
        Token nextToken = tokenQueue.peek();
        URIElementParser.assertNotNull(nextToken);
        if (nextToken.isGrammar()) {
            if (nextToken.grammarEquals(GrammarMarker.MAP_START)) {
                return URIElementParser.parseMap(tokenQueue);
            }
            if (nextToken.grammarEquals(GrammarMarker.LIST_START)) {
                return URIElementParser.parseList(tokenQueue);
            }
            Token errorToken = tokenQueue.poll();
            throw new PathSegment.PathSegmentSyntaxException("unexpected token: " + errorToken.toErrorString() + " at start of element");
        }
        return URIElementParser.parseString(tokenQueue);
    }

    private static String parseString(Queue<Token> tokenQueue) throws PathSegment.PathSegmentSyntaxException {
        Token strToken = tokenQueue.poll();
        URIElementParser.assertNotNull(strToken);
        if (strToken.isGrammar()) {
            throw new PathSegment.PathSegmentSyntaxException("expected string token, found grammar token: " + strToken.toErrorString());
        }
        return strToken.toString();
    }

    private static DataMap parseMap(Queue<Token> tokenQueue) throws PathSegment.PathSegmentSyntaxException {
        DataMap map = new DataMap();
        Token firstToken = tokenQueue.poll();
        URIElementParser.assertExpectation(firstToken, GrammarMarker.MAP_START);
        Token nextToken = tokenQueue.peek();
        if (!nextToken.grammarEquals(GrammarMarker.OBJ_END)) {
            URIElementParser.parseMapElements(tokenQueue, map);
        }
        Token lastToken = tokenQueue.poll();
        URIElementParser.assertExpectation(lastToken, GrammarMarker.OBJ_END);
        return map;
    }

    private static void parseMapElements(Queue<Token> tokenQueue, DataMap map) throws PathSegment.PathSegmentSyntaxException {
        URIElementParser.parseMapElement(tokenQueue, map);
        while (tokenQueue.peek().grammarEquals(GrammarMarker.ITEM_SEP)) {
            tokenQueue.remove();
            URIElementParser.parseMapElement(tokenQueue, map);
        }
    }

    private static void parseMapElement(Queue<Token> tokenQueue, DataMap map) throws PathSegment.PathSegmentSyntaxException {
        String key = URIElementParser.parseString(tokenQueue);
        Token mapSep = tokenQueue.poll();
        URIElementParser.assertExpectation(mapSep, GrammarMarker.MAP_SEP);
        Object value = URIElementParser.parseElement(tokenQueue);
        map.put((Object)key, value);
        Token nextToken = tokenQueue.peek();
        URIElementParser.assertNotNull(nextToken);
    }

    private static DataList parseList(Queue<Token> tokenQueue) throws PathSegment.PathSegmentSyntaxException {
        DataList list = new DataList();
        Token firstToken = tokenQueue.poll();
        URIElementParser.assertExpectation(firstToken, GrammarMarker.LIST_START);
        Token nextToken = tokenQueue.peek();
        if (!nextToken.grammarEquals(GrammarMarker.OBJ_END)) {
            URIElementParser.parseListElements(tokenQueue, list);
        }
        Token lastToken = tokenQueue.poll();
        URIElementParser.assertExpectation(lastToken, GrammarMarker.OBJ_END);
        return list;
    }

    private static void parseListElements(Queue<Token> tokenQueue, DataList list) throws PathSegment.PathSegmentSyntaxException {
        list.add(URIElementParser.parseListElement(tokenQueue));
        while (tokenQueue.peek().grammarEquals(GrammarMarker.ITEM_SEP)) {
            tokenQueue.remove();
            list.add(URIElementParser.parseListElement(tokenQueue));
        }
    }

    private static Object parseListElement(Queue<Token> tokenQueue) throws PathSegment.PathSegmentSyntaxException {
        Object element = URIElementParser.parseElement(tokenQueue);
        Token nextToken = tokenQueue.peek();
        URIElementParser.assertNotNull(nextToken);
        return element;
    }

    private static void assertExpectation(Token token, GrammarMarker marker) throws PathSegment.PathSegmentSyntaxException {
        URIElementParser.assertNotNull(token);
        if (!token.grammarEquals(marker)) {
            throw new PathSegment.PathSegmentSyntaxException("expected '" + marker.stringValue + "' but found " + token.toErrorString());
        }
    }

    private static void assertNotNull(Token token) throws PathSegment.PathSegmentSyntaxException {
        if (token == null) {
            throw new PathSegment.PathSegmentSyntaxException("unexpected end of input");
        }
    }

    private static Queue<Token> tokenizeElement(String element) throws PathSegment.PathSegmentSyntaxException {
        LinkedList<Token> tokens = new LinkedList<Token>();
        StringBuilder currentToken = new StringBuilder();
        int currentTokenStartLoc = 0;
        int currentCharIndex = 0;
        for (char c : element.toCharArray()) {
            if (URIElementParser.isGrammarCharacter(c)) {
                if (c == '(' && currentToken.toString().equals("List")) {
                    tokens.add(new Token(GrammarMarker.LIST_START, currentTokenStartLoc));
                    currentTokenStartLoc = currentCharIndex + 1;
                } else {
                    if (currentToken.length() != 0) {
                        tokens.add(URIElementParser.createStringToken(currentToken.toString(), currentTokenStartLoc));
                    }
                    tokens.add(URIElementParser.createGrammarToken(c, currentCharIndex));
                    currentTokenStartLoc = currentCharIndex + 1;
                }
                currentToken = new StringBuilder();
            } else {
                currentToken.append(c);
            }
            ++currentCharIndex;
        }
        if (currentToken.length() != 0) {
            tokens.add(URIElementParser.createStringToken(currentToken.toString(), currentTokenStartLoc));
        }
        return tokens;
    }

    private static Token createStringToken(String strToken, int startLocation) throws PathSegment.PathSegmentSyntaxException {
        return new Token(URIElementParser.decodeString(strToken), startLocation);
    }

    private static String decodeString(String str) throws PathSegment.PathSegmentSyntaxException {
        if (str.equals("''")) {
            return "";
        }
        return UriComponent.decode((String)str, null);
    }

    private static Token createGrammarToken(char c, int startLocation) {
        switch (c) {
            case '(': {
                return new Token(GrammarMarker.MAP_START, startLocation);
            }
            case ')': {
                return new Token(GrammarMarker.OBJ_END, startLocation);
            }
            case ',': {
                return new Token(GrammarMarker.ITEM_SEP, startLocation);
            }
            case ':': {
                return new Token(GrammarMarker.MAP_SEP, startLocation);
            }
        }
        throw new IllegalArgumentException("cannot create non-grammar token '" + c + "' as grammar token");
    }

    private static boolean isGrammarCharacter(char c) {
        return URIConstants.GRAMMAR_CHARS.contains(Character.valueOf(c));
    }

    private static class Token {
        private String value;
        private GrammarMarker marker;
        private int startLocation;

        public Token(String str, int startLocation) {
            this.value = str;
            this.marker = null;
            this.startLocation = startLocation;
        }

        public Token(GrammarMarker marker, int startLocation) {
            this.value = null;
            this.marker = marker;
            this.startLocation = startLocation;
        }

        public boolean isGrammar() {
            return this.marker != null;
        }

        public boolean grammarEquals(GrammarMarker marker) {
            return this.marker == marker;
        }

        public String toString() {
            if (this.isGrammar()) {
                return this.marker.stringValue;
            }
            return this.value;
        }

        public String toErrorString() {
            return "'" + this.toString() + "' (column " + this.startLocation + ")";
        }
    }

    private static enum GrammarMarker {
        LIST_START("List("),
        MAP_START(String.valueOf('(')),
        OBJ_END(String.valueOf(')')),
        ITEM_SEP(String.valueOf(',')),
        MAP_SEP(String.valueOf(':'));

        public final String stringValue;

        private GrammarMarker(String value) {
            this.stringValue = value;
        }
    }
}

