/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.internal.common;

import com.linkedin.restli.internal.common.AsciiHexEncoding;
import java.util.HashMap;
import java.util.regex.Pattern;

public class PathSegment {
    public static final String PATH_SEPARATOR = ".";
    private static final Pattern INDEX_PATTERN = Pattern.compile("(^.+)\\[(\\d+)\\]$");
    private static final char[] ENCODED_CHARS = new char[]{'[', ']', '.'};
    public static final AsciiHexEncoding CODEC = new AsciiHexEncoding('~', ENCODED_CHARS);
    private final String _name;
    private final Integer _index;

    private PathSegment(String name, Integer index) throws PathSegmentSyntaxException {
        assert (name != null);
        try {
            this._name = CODEC.decode(name);
        }
        catch (AsciiHexEncoding.CannotDecodeException e1) {
            throw new PathSegmentSyntaxException("Cannot decode key name " + name);
        }
        this._index = index;
    }

    public static PathSegment parse(String string) throws PathSegmentSyntaxException {
        if (string == null || string.isEmpty()) {
            return null;
        }
        if (string.charAt(string.length() - 1) == ']') {
            int startBraceIdx = string.lastIndexOf(91);
            if (startBraceIdx <= 0) {
                if (startBraceIdx == -1) {
                    throw new PathSegmentSyntaxException("Path segment parsing error.  '[' expected but not found: " + string);
                }
                throw new PathSegmentSyntaxException("Path segment parsing error.  Path segment name expected before '[' but not found: " + string);
            }
            String name = string.substring(0, startBraceIdx);
            String indexStr = string.substring(startBraceIdx + 1, string.length() - 1);
            try {
                int index = Integer.parseInt(indexStr);
                if (index < 0) {
                    throw new PathSegmentSyntaxException("Path segment parsing error.  Negative integer key index not allowed: " + string);
                }
                return new PathSegment(name, index);
            }
            catch (NumberFormatException e) {
                throw new PathSegmentSyntaxException("Path segment parsing error. Invalid Non-integer key index:  " + string);
            }
        }
        return new PathSegment(string, null);
    }

    public String getName() {
        return this._name;
    }

    public Integer getIndex() {
        return this._index;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this._name);
        if (this._index != null) {
            sb.append("[").append(this._index).append("]");
        }
        return sb.toString();
    }

    public void putOnDataMap(MapMap map, String value) throws PathSegmentSyntaxException {
        ListMap listMap;
        if (this._index == null) {
            if (map.get(this._name) != null) {
                throw new PathSegmentSyntaxException("Duplicate references to key: " + this._name);
            }
            map.put(this._name, value);
            return;
        }
        Object entry = map.get(this._name);
        if (entry == null) {
            listMap = new ListMap();
            map.put(this._name, listMap);
        } else if (entry instanceof ListMap) {
            listMap = (ListMap)entry;
        } else {
            throw new PathSegmentSyntaxException("Conflicting references to key: " + this.toString());
        }
        if (listMap.get(this._index) != null) {
            throw new PathSegmentSyntaxException("Duplicate references to key: " + this._name);
        }
        listMap.put(this._index, value);
    }

    public MapMap getNextLevelMap(MapMap map) throws PathSegmentSyntaxException {
        Object object = map.get(this._name);
        if (object == null) {
            MapMap nextLevelDataMap = new MapMap();
            if (this._index == null) {
                map.put(this._name, nextLevelDataMap);
            } else {
                ListMap listMap = new ListMap();
                map.put(this._name, listMap);
                listMap.put(this._index, nextLevelDataMap);
            }
            return nextLevelDataMap;
        }
        if (this._index == null) {
            if (object instanceof MapMap) {
                return (MapMap)object;
            }
            throw new PathSegmentSyntaxException("Conflicting references to key " + this.toString());
        }
        if (object instanceof ListMap) {
            ListMap list = (ListMap)object;
            Object object2 = list.get(this._index);
            if (object2 == null) {
                MapMap nextLevelMap = new MapMap();
                list.put(this._index, nextLevelMap);
                return nextLevelMap;
            }
            if (object2 instanceof MapMap) {
                return (MapMap)object2;
            }
            throw new PathSegmentSyntaxException("Conflicting references to key " + this.toString());
        }
        throw new PathSegmentSyntaxException("Conflicting references to key " + this.toString());
    }

    static class MapMap
    extends HashMap<String, Object> {
        private static final long serialVersionUID = 1L;

        MapMap() {
        }
    }

    static class ListMap
    extends HashMap<Integer, Object> {
        private static final long serialVersionUID = 1L;

        ListMap() {
        }
    }

    public static class PathSegmentSyntaxException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public PathSegmentSyntaxException(String message) {
            super(message);
        }
    }
}

