/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.internal.common;

import com.linkedin.data.ByteString;
import com.linkedin.data.DataMap;
import com.linkedin.data.codec.JacksonDataCodec;
import com.linkedin.data.codec.PsonDataCodec;
import com.linkedin.restli.internal.common.ContentTypeUtil;
import java.io.IOException;
import java.util.Map;
import javax.activation.MimeTypeParseException;

public class DataMapConverter {
    private static final JacksonDataCodec JACKSON_DATA_CODEC = new JacksonDataCodec();
    private static final PsonDataCodec PSON_DATA_CODEC = new PsonDataCodec();

    public static ByteString dataMapToByteString(Map<String, String> headers, DataMap dataMap) throws MimeTypeParseException, IOException {
        return DataMapConverter.dataMapToByteString(DataMapConverter.getContentTypeHeader(headers), dataMap);
    }

    public static DataMap bytesToDataMap(Map<String, String> headers, ByteString bytes) throws MimeTypeParseException, IOException {
        return DataMapConverter.bytesToDataMap(DataMapConverter.getContentTypeHeader(headers), bytes);
    }

    public static ByteString dataMapToByteString(String contentTypeHeaderValue, DataMap dataMap) throws MimeTypeParseException, IOException {
        ContentTypeUtil.ContentType contentType = ContentTypeUtil.getContentType(contentTypeHeaderValue);
        if (contentType == ContentTypeUtil.ContentType.PSON) {
            return ByteString.copyFromDataMapAsPson((DataMap)dataMap);
        }
        return ByteString.copyFromDataMapAsJson((DataMap)dataMap);
    }

    public static DataMap bytesToDataMap(String contentTypeHeaderValue, ByteString bytes) throws MimeTypeParseException, IOException {
        ContentTypeUtil.ContentType contentType = ContentTypeUtil.getContentType(contentTypeHeaderValue);
        if (contentType == ContentTypeUtil.ContentType.PSON) {
            return PSON_DATA_CODEC.readMap(bytes.asInputStream());
        }
        return JACKSON_DATA_CODEC.readMap(bytes.asInputStream());
    }

    private static String getContentTypeHeader(Map<String, String> headers) {
        return headers.get("Content-Type");
    }
}

