/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.internal.common;

import java.net.HttpCookie;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class CookieUtil {
    public static List<String> encodeCookies(List<HttpCookie> cookies) {
        ArrayList<String> cookieStrs = new ArrayList<String>();
        if (cookies != null) {
            for (HttpCookie cookie : cookies) {
                if (cookie == null) continue;
                cookieStrs.add(CookieUtil.encodeCookie(cookie));
            }
        }
        return cookieStrs;
    }

    public static List<HttpCookie> decodeSetCookies(List<String> cookieStrs) {
        ArrayList<HttpCookie> cookies = new ArrayList<HttpCookie>();
        if (cookieStrs != null) {
            for (String cookieStr : cookieStrs) {
                List<HttpCookie> decodedCookie;
                if (cookieStr == null || (decodedCookie = HttpCookie.parse(cookieStr)) == null) continue;
                for (HttpCookie cookie : decodedCookie) {
                    cookies.add(cookie);
                }
            }
        }
        return cookies;
    }

    public static List<String> encodeSetCookies(List<HttpCookie> cookies) {
        ArrayList<String> cookieStrs = new ArrayList<String>();
        if (cookies != null) {
            for (HttpCookie cookie : cookies) {
                if (cookie == null) continue;
                cookieStrs.add(CookieUtil.encodeSetCookie(cookie));
            }
        }
        return cookieStrs;
    }

    public static List<HttpCookie> decodeCookies(List<String> cookieStrs) {
        ArrayList<HttpCookie> cookies = new ArrayList<HttpCookie>();
        if (cookieStrs == null) {
            return cookies;
        }
        for (String cookieStr : cookieStrs) {
            if (cookieStr == null) continue;
            StringTokenizer tokenizer = new StringTokenizer(cookieStr, ";");
            HttpCookie cookieToBeAdd = null;
            while (tokenizer.hasMoreTokens()) {
                String nameValuePair = tokenizer.nextToken();
                int index = nameValuePair.indexOf(61);
                if (index != -1) {
                    String name = nameValuePair.substring(0, index).trim();
                    String value = CookieUtil.stripOffSurrounding(nameValuePair.substring(index + 1).trim());
                    if (name.charAt(0) != '$') {
                        if (cookieToBeAdd != null) {
                            cookies.add(cookieToBeAdd);
                        }
                        cookieToBeAdd = new HttpCookie(name, value);
                        continue;
                    }
                    if (cookieToBeAdd == null) continue;
                    if (name.equals("$Path")) {
                        cookieToBeAdd.setPath(value);
                        continue;
                    }
                    if (name.equals("$Domain")) {
                        cookieToBeAdd.setDomain(value);
                        continue;
                    }
                    if (!name.equals("$Port")) continue;
                    cookieToBeAdd.setPortlist(value);
                    continue;
                }
                throw new IllegalArgumentException("Invalid cookie name-value pair");
            }
            if (cookieToBeAdd == null) continue;
            cookies.add(cookieToBeAdd);
        }
        return cookies;
    }

    public static String encodeCookie(HttpCookie cookie) {
        if (cookie == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(cookie.getName()).append("=").append(cookie.getValue());
        return sb.toString();
    }

    public static String encodeSetCookie(HttpCookie cookie) {
        if (cookie == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(cookie.getName()).append("=").append(cookie.getValue());
        if (cookie.getPath() != null) {
            sb.append(";Path=").append(cookie.getPath());
        }
        if (cookie.getDomain() != null) {
            sb.append(";Domain=").append(cookie.getDomain());
        }
        if (cookie.getPortlist() != null) {
            sb.append(";Port=\"").append(cookie.getPortlist()).append('\"');
        }
        sb.append(";Max-Age=").append(Long.toString(cookie.getMaxAge()));
        sb.append(";Version=").append(Integer.toString(cookie.getVersion()));
        if (cookie.getDiscard()) {
            sb.append(";Discard");
        }
        if (cookie.getSecure()) {
            sb.append(";Secure");
        }
        if (cookie.getComment() != null) {
            sb.append(";Comment=").append(cookie.getComment());
        }
        if (cookie.getCommentURL() != null) {
            sb.append(";CommentURL=\"").append(cookie.getCommentURL()).append('\"');
        }
        return sb.toString();
    }

    private static String stripOffSurrounding(String s) {
        if (s != null && s.length() > 2 && (s.charAt(0) == '\"' && s.charAt(s.length() - 1) == '\"' || s.charAt(0) == '\'' && s.charAt(s.length() - 1) == '\'')) {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }
}

