/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.common.multiplexer;

import com.linkedin.data.DataMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.template.DataTemplate;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.SetMode;
import com.linkedin.restli.common.multiplexer.IndividualRequestMap;
import java.util.List;
import javax.annotation.Nonnull;

public class MultiplexedRequestContent
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema((String)"{\"type\":\"record\",\"name\":\"MultiplexedRequestContent\",\"namespace\":\"com.linkedin.restli.common.multiplexer\",\"doc\":\"Represents multiple HTTP requests to send as a single multiplexed HTTP request\",\"fields\":[{\"name\":\"requests\",\"type\":{\"type\":\"map\",\"values\":{\"type\":\"record\",\"name\":\"IndividualRequest\",\"doc\":\"Individual HTTP request within a multiplexed request. For security reasons, cookies are not allowed to be specified in the IndividualRequest. Instead, it MUST be specified in the top level envelope request.\",\"fields\":[{\"name\":\"method\",\"type\":\"string\",\"doc\":\"HTTP method name\"},{\"name\":\"headers\",\"type\":{\"type\":\"map\",\"values\":\"string\"},\"doc\":\"HTTP headers specific to the individual request. All common headers should be specified in the top level envelope request. If IndividualRequest headers contain a header that is also specified in the top level envelope request, the header in the IndividualRequest will be used. In additions, for security reasons, headers in IndividualRequest are whitelisted. Only headers within the whitelist can be specified here.\",\"default\":{}},{\"name\":\"relativeUrl\",\"type\":\"string\",\"doc\":\"Relative URL of the request\"},{\"name\":\"body\",\"type\":{\"type\":\"record\",\"name\":\"IndividualBody\",\"doc\":\"Represents content that may be in the body of an individual request / response\",\"fields\":[]},\"doc\":\"Request body\",\"optional\":true},{\"name\":\"dependentRequests\",\"type\":{\"type\":\"map\",\"values\":\"IndividualRequest\"},\"doc\":\"Requests that should be executed after the current request is processed (sequential ordering). Dependent requests are executed in parallel. Keys of the dependent requests are used to correlate responses with requests. They should be unique within the multiplexed request\",\"default\":{}}]}},\"doc\":\"Individual HTTP requests executed in parallel.  Keys of the requests are used to correlate responses with requests. They should be unique within the multiplexed request\"}]}");
    private static final RecordDataSchema.Field FIELD_Requests = SCHEMA.getField("requests");

    public MultiplexedRequestContent() {
        super(new DataMap(), SCHEMA);
    }

    public MultiplexedRequestContent(DataMap data) {
        super(data, SCHEMA);
    }

    public static Fields fields() {
        return _fields;
    }

    public boolean hasRequests() {
        return this.contains(FIELD_Requests);
    }

    public void removeRequests() {
        this.remove(FIELD_Requests);
    }

    public IndividualRequestMap getRequests(GetMode mode) {
        return (IndividualRequestMap)this.obtainWrapped(FIELD_Requests, IndividualRequestMap.class, mode);
    }

    @Nonnull
    public IndividualRequestMap getRequests() {
        return (IndividualRequestMap)this.obtainWrapped(FIELD_Requests, IndividualRequestMap.class, GetMode.STRICT);
    }

    public MultiplexedRequestContent setRequests(IndividualRequestMap value, SetMode mode) {
        this.putWrapped(FIELD_Requests, IndividualRequestMap.class, (DataTemplate)value, mode);
        return this;
    }

    public MultiplexedRequestContent setRequests(@Nonnull IndividualRequestMap value) {
        this.putWrapped(FIELD_Requests, IndividualRequestMap.class, (DataTemplate)value, SetMode.DISALLOW_NULL);
        return this;
    }

    public MultiplexedRequestContent clone() throws CloneNotSupportedException {
        return (MultiplexedRequestContent)super.clone();
    }

    public MultiplexedRequestContent copy() throws CloneNotSupportedException {
        return (MultiplexedRequestContent)super.copy();
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public IndividualRequestMap.Fields requests() {
            return new IndividualRequestMap.Fields(this.getPathComponents(), "requests");
        }
    }
}

