/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.common.multiplexer;

import com.linkedin.data.DataMap;
import com.linkedin.data.schema.PathSpec;
import com.linkedin.data.schema.RecordDataSchema;
import com.linkedin.data.template.DataTemplate;
import com.linkedin.data.template.DataTemplateUtil;
import com.linkedin.data.template.GetMode;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.data.template.SetMode;
import com.linkedin.data.template.StringMap;
import com.linkedin.restli.common.multiplexer.IndividualBody;
import com.linkedin.restli.common.multiplexer.IndividualRequestMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class IndividualRequest
extends RecordTemplate {
    private static final Fields _fields = new Fields();
    private static final RecordDataSchema SCHEMA = (RecordDataSchema)DataTemplateUtil.parseSchema((String)"{\"type\":\"record\",\"name\":\"IndividualRequest\",\"namespace\":\"com.linkedin.restli.common.multiplexer\",\"doc\":\"Individual HTTP request within a multiplexed request. For security reasons, cookies are not allowed to be specified in the IndividualRequest. Instead, it MUST be specified in the top level envelope request.\",\"fields\":[{\"name\":\"method\",\"type\":\"string\",\"doc\":\"HTTP method name\"},{\"name\":\"headers\",\"type\":{\"type\":\"map\",\"values\":\"string\"},\"doc\":\"HTTP headers specific to the individual request. All common headers should be specified in the top level envelope request. If IndividualRequest headers contain a header that is also specified in the top level envelope request, the header in the IndividualRequest will be used. In additions, for security reasons, headers in IndividualRequest are whitelisted. Only headers within the whitelist can be specified here.\",\"default\":{}},{\"name\":\"relativeUrl\",\"type\":\"string\",\"doc\":\"Relative URL of the request\"},{\"name\":\"body\",\"type\":{\"type\":\"record\",\"name\":\"IndividualBody\",\"doc\":\"Represents content that may be in the body of an individual request / response\",\"fields\":[]},\"doc\":\"Request body\",\"optional\":true},{\"name\":\"dependentRequests\",\"type\":{\"type\":\"map\",\"values\":\"IndividualRequest\"},\"doc\":\"Requests that should be executed after the current request is processed (sequential ordering). Dependent requests are executed in parallel. Keys of the dependent requests are used to correlate responses with requests. They should be unique within the multiplexed request\",\"default\":{}}]}");
    private static final RecordDataSchema.Field FIELD_Method = SCHEMA.getField("method");
    private static final RecordDataSchema.Field FIELD_Headers = SCHEMA.getField("headers");
    private static final RecordDataSchema.Field FIELD_RelativeUrl = SCHEMA.getField("relativeUrl");
    private static final RecordDataSchema.Field FIELD_Body = SCHEMA.getField("body");
    private static final RecordDataSchema.Field FIELD_DependentRequests = SCHEMA.getField("dependentRequests");

    public IndividualRequest() {
        super(new DataMap(), SCHEMA);
    }

    public IndividualRequest(DataMap data) {
        super(data, SCHEMA);
    }

    public static Fields fields() {
        return _fields;
    }

    public boolean hasMethod() {
        return this.contains(FIELD_Method);
    }

    public void removeMethod() {
        this.remove(FIELD_Method);
    }

    public String getMethod(GetMode mode) {
        return (String)this.obtainDirect(FIELD_Method, String.class, mode);
    }

    @Nonnull
    public String getMethod() {
        return (String)this.obtainDirect(FIELD_Method, String.class, GetMode.STRICT);
    }

    public IndividualRequest setMethod(String value, SetMode mode) {
        this.putDirect(FIELD_Method, String.class, String.class, value, mode);
        return this;
    }

    public IndividualRequest setMethod(@Nonnull String value) {
        this.putDirect(FIELD_Method, String.class, String.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasHeaders() {
        return this.contains(FIELD_Headers);
    }

    public void removeHeaders() {
        this.remove(FIELD_Headers);
    }

    public StringMap getHeaders(GetMode mode) {
        return (StringMap)this.obtainWrapped(FIELD_Headers, StringMap.class, mode);
    }

    @Nonnull
    public StringMap getHeaders() {
        return (StringMap)this.obtainWrapped(FIELD_Headers, StringMap.class, GetMode.STRICT);
    }

    public IndividualRequest setHeaders(StringMap value, SetMode mode) {
        this.putWrapped(FIELD_Headers, StringMap.class, (DataTemplate)value, mode);
        return this;
    }

    public IndividualRequest setHeaders(@Nonnull StringMap value) {
        this.putWrapped(FIELD_Headers, StringMap.class, (DataTemplate)value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasRelativeUrl() {
        return this.contains(FIELD_RelativeUrl);
    }

    public void removeRelativeUrl() {
        this.remove(FIELD_RelativeUrl);
    }

    public String getRelativeUrl(GetMode mode) {
        return (String)this.obtainDirect(FIELD_RelativeUrl, String.class, mode);
    }

    @Nonnull
    public String getRelativeUrl() {
        return (String)this.obtainDirect(FIELD_RelativeUrl, String.class, GetMode.STRICT);
    }

    public IndividualRequest setRelativeUrl(String value, SetMode mode) {
        this.putDirect(FIELD_RelativeUrl, String.class, String.class, value, mode);
        return this;
    }

    public IndividualRequest setRelativeUrl(@Nonnull String value) {
        this.putDirect(FIELD_RelativeUrl, String.class, String.class, value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasBody() {
        return this.contains(FIELD_Body);
    }

    public void removeBody() {
        this.remove(FIELD_Body);
    }

    public IndividualBody getBody(GetMode mode) {
        return (IndividualBody)this.obtainWrapped(FIELD_Body, IndividualBody.class, mode);
    }

    @Nullable
    public IndividualBody getBody() {
        return (IndividualBody)this.obtainWrapped(FIELD_Body, IndividualBody.class, GetMode.STRICT);
    }

    public IndividualRequest setBody(IndividualBody value, SetMode mode) {
        this.putWrapped(FIELD_Body, IndividualBody.class, (DataTemplate)value, mode);
        return this;
    }

    public IndividualRequest setBody(@Nonnull IndividualBody value) {
        this.putWrapped(FIELD_Body, IndividualBody.class, (DataTemplate)value, SetMode.DISALLOW_NULL);
        return this;
    }

    public boolean hasDependentRequests() {
        return this.contains(FIELD_DependentRequests);
    }

    public void removeDependentRequests() {
        this.remove(FIELD_DependentRequests);
    }

    public IndividualRequestMap getDependentRequests(GetMode mode) {
        return (IndividualRequestMap)this.obtainWrapped(FIELD_DependentRequests, IndividualRequestMap.class, mode);
    }

    @Nonnull
    public IndividualRequestMap getDependentRequests() {
        return (IndividualRequestMap)this.obtainWrapped(FIELD_DependentRequests, IndividualRequestMap.class, GetMode.STRICT);
    }

    public IndividualRequest setDependentRequests(IndividualRequestMap value, SetMode mode) {
        this.putWrapped(FIELD_DependentRequests, IndividualRequestMap.class, (DataTemplate)value, mode);
        return this;
    }

    public IndividualRequest setDependentRequests(@Nonnull IndividualRequestMap value) {
        this.putWrapped(FIELD_DependentRequests, IndividualRequestMap.class, (DataTemplate)value, SetMode.DISALLOW_NULL);
        return this;
    }

    public IndividualRequest clone() throws CloneNotSupportedException {
        return (IndividualRequest)super.clone();
    }

    public IndividualRequest copy() throws CloneNotSupportedException {
        return (IndividualRequest)super.copy();
    }

    public static class Fields
    extends PathSpec {
        public Fields(List<String> path, String name) {
            super(path, name);
        }

        public Fields() {
        }

        public PathSpec method() {
            return new PathSpec(this.getPathComponents(), "method");
        }

        public PathSpec headers() {
            return new PathSpec(this.getPathComponents(), "headers");
        }

        public PathSpec relativeUrl() {
            return new PathSpec(this.getPathComponents(), "relativeUrl");
        }

        public IndividualBody.Fields body() {
            return new IndividualBody.Fields(this.getPathComponents(), "body");
        }

        public IndividualRequestMap.Fields dependentRequests() {
            return new IndividualRequestMap.Fields(this.getPathComponents(), "dependentRequests");
        }
    }
}

