/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.restli.common;

import com.linkedin.data.template.DynamicRecordMetadata;
import com.linkedin.data.template.RecordTemplate;
import com.linkedin.restli.common.ComplexKeySpec;
import com.linkedin.restli.common.CompoundKey;
import com.linkedin.restli.common.ResourceMethod;
import com.linkedin.restli.common.ResourceSpec;
import com.linkedin.restli.common.TypeSpec;
import com.linkedin.restli.internal.common.ResourcePropertiesImpl;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class ResourceSpecImpl
implements ResourceSpec {
    private final ResourcePropertiesImpl _resourceProperties;
    private final Map<String, DynamicRecordMetadata> _actionRequestMetadata;
    private final Map<String, DynamicRecordMetadata> _actionResponseMetadata;

    public ResourceSpecImpl() {
        this(Collections.emptySet(), Collections.emptyMap(), Collections.emptyMap(), null, null, null, null, Collections.emptyMap());
    }

    public ResourceSpecImpl(Set<ResourceMethod> supportedMethods, Map<String, DynamicRecordMetadata> actionRequestMetadata, Map<String, DynamicRecordMetadata> actionResponseMetadata) {
        this(supportedMethods, actionRequestMetadata, actionResponseMetadata, null, null, null, null, Collections.emptyMap());
    }

    public ResourceSpecImpl(Set<ResourceMethod> supportedMethods, Map<String, DynamicRecordMetadata> actionRequestMetadata, Map<String, DynamicRecordMetadata> actionResponseMetadata, Class<?> keyClass, Class<? extends RecordTemplate> valueClass, Map<String, ?> keyParts) {
        this(supportedMethods, actionRequestMetadata, actionResponseMetadata, keyClass, null, null, valueClass, keyParts);
    }

    public ResourceSpecImpl(Set<ResourceMethod> supportedMethods, Map<String, DynamicRecordMetadata> actionRequestMetadata, Map<String, DynamicRecordMetadata> actionResponseMetadata, Class<? extends RecordTemplate> valueClass) {
        this(supportedMethods, actionRequestMetadata, actionResponseMetadata, null, null, null, valueClass, Collections.emptyMap());
    }

    public ResourceSpecImpl(Set<ResourceMethod> supportedMethods, Map<String, DynamicRecordMetadata> actionRequestMetadata, Map<String, DynamicRecordMetadata> actionResponseMetadata, Class<?> keyClass, Class<? extends RecordTemplate> keyKeyClass, Class<? extends RecordTemplate> keyParamsClass, Class<? extends RecordTemplate> valueClass, Map<String, ?> keyParts) {
        this(supportedMethods, actionRequestMetadata, actionResponseMetadata, TypeSpec.forClassMaybeNull(keyClass), ComplexKeySpec.forClassesMaybeNull(keyKeyClass, keyParamsClass), TypeSpec.forClassMaybeNull(valueClass), keyParts);
    }

    public ResourceSpecImpl(Set<ResourceMethod> supportedMethods, Map<String, DynamicRecordMetadata> actionRequestMetadata, Map<String, DynamicRecordMetadata> actionResponseMetadata, TypeSpec<?> key, ComplexKeySpec<?, ?> complexKeyType, TypeSpec<? extends RecordTemplate> value, Map<String, ?> keyParts) {
        this._resourceProperties = new ResourcePropertiesImpl(supportedMethods, key, complexKeyType, value, keyParts);
        this._actionRequestMetadata = actionRequestMetadata;
        this._actionResponseMetadata = actionResponseMetadata;
    }

    @Override
    public Set<ResourceMethod> getSupportedMethods() {
        return this._resourceProperties.getSupportedMethods();
    }

    @Override
    public Class<?> getKeyClass() {
        return this._resourceProperties.getKeyType() == null ? null : this._resourceProperties.getKeyType().getType();
    }

    @Override
    public TypeSpec<?> getKeyType() {
        return this._resourceProperties.getKeyType();
    }

    @Override
    public Class<? extends RecordTemplate> getValueClass() {
        return this._resourceProperties.getValueType() == null ? null : this._resourceProperties.getValueType().getType();
    }

    @Override
    public TypeSpec<? extends RecordTemplate> getValueType() {
        return this._resourceProperties.getValueType();
    }

    @Override
    public Map<String, CompoundKey.TypeInfo> getKeyParts() {
        return this._resourceProperties.getKeyParts();
    }

    @Override
    public Class<? extends RecordTemplate> getKeyKeyClass() {
        return this._resourceProperties.getComplexKeyType() == null ? null : this._resourceProperties.getComplexKeyType().getKeyType().getType();
    }

    @Override
    public Class<? extends RecordTemplate> getKeyParamsClass() {
        return this._resourceProperties.getComplexKeyType() == null ? null : this._resourceProperties.getComplexKeyType().getParamsType().getType();
    }

    @Override
    public ComplexKeySpec<? extends RecordTemplate, ? extends RecordTemplate> getComplexKeyType() {
        return this._resourceProperties.getComplexKeyType();
    }

    @Override
    public DynamicRecordMetadata getRequestMetadata(String methodName) {
        return this._actionRequestMetadata.get(methodName);
    }

    @Override
    public DynamicRecordMetadata getActionResponseMetadata(String methodName) {
        return this._actionResponseMetadata.get(methodName);
    }

    @Override
    public boolean isKeylessResource() {
        return this._resourceProperties.isKeylessResource();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ResourceSpecImpl)) {
            return false;
        }
        ResourceSpecImpl resourceSpec = (ResourceSpecImpl)other;
        return this._resourceProperties.equals(resourceSpec._resourceProperties);
    }

    public int hashCode() {
        return 11 * this._resourceProperties.hashCode() + 7;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this._resourceProperties.toString());
        builder.append("\n, actionRequestMetadata: ");
        builder.append(this._actionRequestMetadata);
        builder.append("\n, actionResponseMetadata: ");
        builder.append(this._actionResponseMetadata);
        return builder.toString();
    }
}

