/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.metrics.hadoop;

import com.codahale.metrics.MetricFilter;
import java.util.concurrent.TimeUnit;
import org.apache.gobblin.metrics.MetricContext;
import org.apache.gobblin.metrics.hadoop.AbstractHadoopCounterReporter;
import org.apache.gobblin.metrics.reporter.ContextAwareScheduledReporter;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;

public class NewAPIHadoopCounterReporter<KI, VI, KO, VO>
extends AbstractHadoopCounterReporter {
    private final TaskInputOutputContext<KI, VI, KO, VO> hadoopContext;

    protected NewAPIHadoopCounterReporter(MetricContext context, String name, MetricFilter filter, TimeUnit rateUnit, TimeUnit durationUnit, TaskInputOutputContext<KI, VI, KO, VO> hadoopContext) {
        super(context, name, filter, rateUnit, durationUnit);
        this.hadoopContext = hadoopContext;
    }

    @Override
    protected void reportIncremental(MetricContext context, String name, long incremental) {
        this.hadoopContext.getCounter(context.getName(), name).increment(incremental);
    }

    @Override
    protected void reportValue(MetricContext context, String name, long value) {
        this.hadoopContext.getCounter(context.getName(), name).setValue(value);
    }

    public static <KI, VI, KO, VO> Builder<KI, VI, KO, VO> builder(TaskInputOutputContext<KI, VI, KO, VO> hadoopContext) {
        return NewAPIHadoopCounterReporter.builder(NewAPIHadoopCounterReporter.class.getName(), hadoopContext);
    }

    public static <KI, VI, KO, VO> Builder<KI, VI, KO, VO> builder(String name, TaskInputOutputContext<KI, VI, KO, VO> hadoopContext) {
        return new Builder<KI, VI, KO, VO>(name, hadoopContext);
    }

    public static class Builder<KI, VI, KO, VO>
    extends ContextAwareScheduledReporter.Builder<NewAPIHadoopCounterReporter<KI, VI, KO, VO>, Builder<KI, VI, KO, VO>> {
        private final TaskInputOutputContext<KI, VI, KO, VO> hadoopContext;

        public Builder(String name, TaskInputOutputContext<KI, VI, KO, VO> hadoopContext) {
            super(name);
            this.hadoopContext = hadoopContext;
        }

        public NewAPIHadoopCounterReporter<KI, VI, KO, VO> build(MetricContext context) {
            return new NewAPIHadoopCounterReporter<KI, VI, KO, VO>(context, this.name, this.filter, this.rateUnit, this.durationUnit, this.hadoopContext);
        }
    }
}

