/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.metrics.hadoop;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.TimeUnit;
import org.apache.gobblin.metrics.Measurements;
import org.apache.gobblin.metrics.MetricContext;
import org.apache.gobblin.metrics.reporter.ContextAwareScheduledReporter;

public abstract class AbstractHadoopCounterReporter
extends ContextAwareScheduledReporter {
    private final Map<String, Long> previousCounts = Maps.newHashMap();

    protected AbstractHadoopCounterReporter(MetricContext context, String name, MetricFilter filter, TimeUnit rateUnit, TimeUnit durationUnit) {
        super(context, name, filter, rateUnit, durationUnit);
    }

    protected void reportInContext(MetricContext context, SortedMap<String, Gauge> gauges, SortedMap<String, Counter> counters, SortedMap<String, Histogram> histograms, SortedMap<String, Meter> meters, SortedMap<String, Timer> timers) {
        for (Map.Entry<String, Gauge> entry : gauges.entrySet()) {
            Gauge gauge = entry.getValue();
            if (!(gauge.getValue() instanceof Long) && !(gauge.getValue() instanceof Integer) && !(gauge.getValue() instanceof Short) && !(gauge.getValue() instanceof Byte)) continue;
            this.reportValue(context, entry.getKey(), ((Number)gauge.getValue()).longValue());
        }
        for (Map.Entry<String, Gauge> entry : counters.entrySet()) {
            this.reportCount(context, entry.getKey(), ((Counter)entry.getValue()).getCount());
        }
        for (Map.Entry<String, Gauge> entry : meters.entrySet()) {
            this.reportCount(context, entry.getKey(), ((Meter)entry.getValue()).getCount());
        }
        for (Map.Entry<String, Gauge> entry : histograms.entrySet()) {
            this.reportCount(context, entry.getKey(), ((Histogram)entry.getValue()).getCount());
        }
        for (Map.Entry<String, Gauge> entry : timers.entrySet()) {
            this.reportCount(context, entry.getKey(), ((Timer)entry.getValue()).getCount());
        }
    }

    protected abstract void reportIncremental(MetricContext var1, String var2, long var3);

    protected abstract void reportValue(MetricContext var1, String var2, long var3);

    private void reportCount(MetricContext context, String name, long currentCount) {
        this.reportIncremental(context, MetricRegistry.name((String)name, (String[])new String[]{Measurements.COUNT.getName()}), this.calculateIncremental(name, currentCount));
        this.previousCounts.put(name, currentCount);
    }

    private long calculateIncremental(String name, long currentCount) {
        if (this.previousCounts.containsKey(name)) {
            return currentCount - this.previousCounts.get(name);
        }
        return currentCount;
    }
}

