/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.config.store.deploy;

import java.net.URI;
import java.util.ServiceLoader;
import org.apache.gobblin.config.store.api.ConfigStoreFactory;
import org.apache.gobblin.config.store.deploy.Deployable;
import org.apache.gobblin.config.store.deploy.DeployableConfigSource;
import org.apache.gobblin.config.store.deploy.FsDeploymentConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreDeployer {
    private static final Logger log = LoggerFactory.getLogger(StoreDeployer.class);

    public static void deploy(URI storeUri, DeployableConfigSource confgSource, String version) throws Exception {
        ServiceLoader<ConfigStoreFactory> loader = ServiceLoader.load(ConfigStoreFactory.class);
        for (ConfigStoreFactory storeFactory : loader) {
            log.info("Found ConfigStore with scheme : " + storeFactory.getScheme());
            if (!storeUri.getScheme().equals(storeFactory.getScheme())) continue;
            log.info("Using ConfigStore with scheme : " + storeFactory.getScheme());
            Object configStore = storeFactory.createConfigStore(storeUri);
            if (configStore instanceof Deployable) {
                ((Deployable)configStore).deploy(new FsDeploymentConfig(confgSource, version));
                continue;
            }
            log.error(String.format("Deployment failed. The store %s does not implement %s", storeFactory.getClass(), Deployable.class.getName()));
        }
    }
}

