/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.source.extractor.extract.kafka;

import java.io.IOException;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.kafka.client.ByteArrayBasedKafkaRecord;
import org.apache.gobblin.metrics.kafka.KafkaSchemaRegistry;
import org.apache.gobblin.metrics.kafka.SchemaRegistryException;
import org.apache.gobblin.source.extractor.extract.kafka.KafkaExtractor;
import org.apache.gobblin.source.extractor.extract.kafka.SimpleKafkaSchemaRegistry;

public class KafkaSimpleExtractor
extends KafkaExtractor<String, byte[]> {
    private final KafkaSchemaRegistry<String, String> kafkaSchemaRegistry;

    public KafkaSimpleExtractor(WorkUnitState state) {
        super(state);
        this.kafkaSchemaRegistry = new SimpleKafkaSchemaRegistry(state.getProperties());
    }

    @Override
    protected byte[] decodeRecord(ByteArrayBasedKafkaRecord kafkaConsumerRecord) throws IOException {
        return kafkaConsumerRecord.getMessageBytes();
    }

    public String getSchema() throws IOException {
        try {
            return this.kafkaSchemaRegistry.getLatestSchemaByTopic(this.topicName);
        }
        catch (SchemaRegistryException e) {
            throw new RuntimeException(e);
        }
    }
}

