/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.source.extractor.extract.kafka;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.Decoder;
import org.apache.gobblin.configuration.WorkUnitState;
import org.apache.gobblin.kafka.client.ByteArrayBasedKafkaRecord;
import org.apache.gobblin.metrics.kafka.KafkaSchemaRegistry;
import org.apache.gobblin.metrics.kafka.SchemaRegistryException;
import org.apache.gobblin.source.extractor.DataRecordException;
import org.apache.gobblin.source.extractor.extract.kafka.KafkaExtractor;
import org.apache.gobblin.util.AvroUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class KafkaAvroExtractor<K>
extends KafkaExtractor<Schema, GenericRecord> {
    private static final Logger log = LoggerFactory.getLogger(KafkaAvroExtractor.class);
    protected static final Schema DEFAULT_SCHEMA = (Schema)SchemaBuilder.record((String)"DefaultSchema").fields().name("header").type((Schema)SchemaBuilder.record((String)"header").fields().name("time").type("long").withDefault((Object)0).endRecord()).noDefault().endRecord();
    protected final Optional<KafkaSchemaRegistry<K, Schema>> schemaRegistry;
    protected final Optional<Schema> schema;
    protected final Optional<GenericDatumReader<GenericData.Record>> reader;

    public KafkaAvroExtractor(WorkUnitState state) {
        super(state);
        this.schemaRegistry = state.contains("kafka.schema.registry.class") ? Optional.of(KafkaSchemaRegistry.get(state.getProperties())) : Optional.absent();
        this.schema = this.getExtractorSchema();
        if (this.schema.isPresent()) {
            this.reader = Optional.of((Object)new GenericDatumReader((Schema)this.schema.get()));
        } else {
            log.error(String.format("Cannot find latest schema for topic %s. This topic will be skipped", this.topicName));
            this.reader = Optional.absent();
        }
    }

    protected Optional<Schema> getExtractorSchema() {
        return Optional.fromNullable((Object)this.getLatestSchemaByTopic(this.topicName));
    }

    protected Schema getLatestSchemaByTopic(String topic) {
        Preconditions.checkState((boolean)this.schemaRegistry.isPresent());
        try {
            return (Schema)((KafkaSchemaRegistry)this.schemaRegistry.get()).getLatestSchemaByTopic(topic);
        }
        catch (SchemaRegistryException e) {
            log.error(String.format("Cannot find latest schema for topic %s. This topic will be skipped", topic), (Throwable)e);
            return null;
        }
    }

    @Override
    public GenericRecord readRecordImpl(GenericRecord reuse) throws DataRecordException, IOException {
        if (!this.schema.isPresent()) {
            return null;
        }
        return super.readRecordImpl(reuse);
    }

    public Schema getSchema() {
        return (Schema)this.schema.or((Object)DEFAULT_SCHEMA);
    }

    @Override
    protected GenericRecord decodeRecord(ByteArrayBasedKafkaRecord messageAndOffset) throws IOException {
        byte[] payload = messageAndOffset.getMessageBytes();
        Schema recordSchema = this.getRecordSchema(payload);
        Decoder decoder = this.getDecoder(payload);
        ((GenericDatumReader)this.reader.get()).setSchema(recordSchema);
        try {
            GenericRecord record = (GenericRecord)((GenericDatumReader)this.reader.get()).read(null, decoder);
            record = this.convertRecord(record);
            return record;
        }
        catch (IOException e) {
            log.error(String.format("Error during decoding record for partition %s: ", this.getCurrentPartition()));
            throw e;
        }
    }

    @Override
    protected GenericRecord convertRecord(GenericRecord record) throws IOException {
        return AvroUtils.convertRecordSchema((GenericRecord)record, (Schema)((Schema)this.schema.get()));
    }

    protected abstract Schema getRecordSchema(byte[] var1);

    protected abstract Decoder getDecoder(byte[] var1);
}

