/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.source.extractor.extract.kafka;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.typesafe.config.Config;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.gobblin.config.client.ConfigClient;
import org.apache.gobblin.config.client.ConfigClientUtils;
import org.apache.gobblin.config.client.api.ConfigStoreFactoryDoesNotExistsException;
import org.apache.gobblin.config.client.api.VersionStabilityPolicy;
import org.apache.gobblin.config.store.api.ConfigStoreCreationException;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.kafka.client.GobblinKafkaConsumerClient;
import org.apache.gobblin.source.extractor.extract.kafka.KafkaTopic;
import org.apache.gobblin.util.ConfigUtils;
import org.apache.gobblin.util.DatasetFilterUtils;
import org.apache.gobblin.util.PathUtils;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigStoreUtils {
    private static final Logger log = LoggerFactory.getLogger(ConfigStoreUtils.class);
    public static final String GOBBLIN_CONFIG_TAGS_WHITELIST = "gobblin.config.tags.whitelist";
    public static final String GOBBLIN_CONFIG_TAGS_BLACKLIST = "gobblin.config.tags.blacklist";
    public static final String GOBBLIN_CONFIG_FILTER = "gobblin.config.filter";
    public static final String GOBBLIN_CONFIG_COMMONPATH = "gobblin.config.commonPath";

    public static Collection<URI> getTopicsURIFromConfigStore(ConfigClient configClient, Path tagUri, String filterString, Optional<Config> runtimeConfig) {
        try {
            Collection importedBy = configClient.getImportedBy(new URI(tagUri.toString()), true, runtimeConfig);
            return importedBy.stream().filter(u -> u.toString().contains(filterString)).collect(Collectors.toList());
        }
        catch (URISyntaxException | ConfigStoreFactoryDoesNotExistsException | ConfigStoreCreationException e) {
            throw new Error(e);
        }
    }

    public static Optional<String> getConfigStoreUri(Properties properties) {
        Optional configStoreUri;
        Optional optional = configStoreUri = StringUtils.isNotBlank((String)properties.getProperty("gobblin.config.management.store.uri")) ? Optional.of((Object)properties.getProperty("gobblin.config.management.store.uri")) : Optional.absent();
        if (!Boolean.valueOf(properties.getProperty("gobblin.config.management.store.enabled", "false")).booleanValue()) {
            configStoreUri = Optional.absent();
        }
        return configStoreUri;
    }

    public static String getTopicNameFromURI(URI uri) {
        Path path = new Path(uri);
        return path.getName();
    }

    public static URI getUriStringForTopic(String topicName, String commonPath, String configStoreUri) throws URISyntaxException {
        Path path = PathUtils.mergePaths((Path)new Path(configStoreUri), (Path)PathUtils.mergePaths((Path)new Path(commonPath), (Path)new Path(topicName)));
        log.info("URI for topic is : " + path.toString());
        return new URI(path.toString());
    }

    public static Optional<Config> getConfigForTopic(Properties properties, String topicKey, ConfigClient configClient) {
        Optional<String> configStoreUri = ConfigStoreUtils.getConfigStoreUri(properties);
        Optional config = Optional.absent();
        if (!configStoreUri.isPresent()) {
            return config;
        }
        try {
            Preconditions.checkArgument((boolean)properties.containsKey(GOBBLIN_CONFIG_COMMONPATH), (Object)"Missing required property gobblin.config.commonPath");
            Preconditions.checkArgument((boolean)properties.containsKey(topicKey), (Object)("Missing required property " + topicKey));
            String topicName = properties.getProperty(topicKey);
            String commonPath = properties.getProperty(GOBBLIN_CONFIG_COMMONPATH);
            config = Optional.fromNullable((Object)ConfigStoreUtils.getConfig(configClient, ConfigStoreUtils.getUriStringForTopic(topicName, commonPath, (String)configStoreUri.get()), (Optional<Config>)ConfigClientUtils.getOptionalRuntimeConfig((Properties)properties)));
        }
        catch (URISyntaxException e) {
            log.error("Unable to get config", (Throwable)e);
        }
        return config;
    }

    public static Config getConfig(ConfigClient client, URI u, Optional<Config> runtimeConfig) {
        try {
            return client.getConfig(u, runtimeConfig);
        }
        catch (ConfigStoreFactoryDoesNotExistsException | ConfigStoreCreationException e) {
            throw new Error(e);
        }
    }

    public static List<KafkaTopic> getTopicsFromConfigStore(Properties properties, String configStoreUri, GobblinKafkaConsumerClient kafkaConsumerClient) {
        ConfigClient configClient = ConfigClient.createConfigClient((VersionStabilityPolicy)VersionStabilityPolicy.WEAK_LOCAL_STABILITY);
        State state = new State();
        state.setProp("topic.whitelist", (Object)".*");
        state.setProp("topic.blacklist", (Object)"");
        List<KafkaTopic> allTopics = kafkaConsumerClient.getFilteredTopics(DatasetFilterUtils.getPatternList((State)state, (String)"topic.blacklist"), DatasetFilterUtils.getPatternList((State)state, (String)"topic.whitelist"));
        Optional runtimeConfig = ConfigClientUtils.getOptionalRuntimeConfig((Properties)properties);
        if (properties.containsKey(GOBBLIN_CONFIG_TAGS_WHITELIST)) {
            Preconditions.checkArgument((boolean)properties.containsKey(GOBBLIN_CONFIG_FILTER), (Object)"Missing required property gobblin.config.filter");
            String filterString = properties.getProperty(GOBBLIN_CONFIG_FILTER);
            Path whiteListTagUri = PathUtils.mergePaths((Path)new Path(configStoreUri), (Path)new Path(properties.getProperty(GOBBLIN_CONFIG_TAGS_WHITELIST)));
            ArrayList whitelistedTopics = new ArrayList();
            ConfigStoreUtils.getTopicsURIFromConfigStore(configClient, whiteListTagUri, filterString, (Optional<Config>)runtimeConfig).stream().filter(u -> ConfigUtils.getBoolean((Config)ConfigStoreUtils.getConfig(configClient, u, (Optional<Config>)runtimeConfig), (String)"topic.whitelist", (boolean)false)).forEach(u -> whitelistedTopics.add(ConfigStoreUtils.getTopicNameFromURI(u)));
            return allTopics.stream().filter(p -> whitelistedTopics.contains(p.getName())).collect(Collectors.toList());
        }
        if (properties.containsKey(GOBBLIN_CONFIG_TAGS_BLACKLIST)) {
            Preconditions.checkArgument((boolean)properties.containsKey(GOBBLIN_CONFIG_FILTER), (Object)"Missing required property gobblin.config.filter");
            String filterString = properties.getProperty(GOBBLIN_CONFIG_FILTER);
            Path blackListTagUri = PathUtils.mergePaths((Path)new Path(configStoreUri), (Path)new Path(properties.getProperty(GOBBLIN_CONFIG_TAGS_BLACKLIST)));
            ArrayList blacklistedTopics = new ArrayList();
            ConfigStoreUtils.getTopicsURIFromConfigStore(configClient, blackListTagUri, filterString, (Optional<Config>)runtimeConfig).stream().filter(u -> ConfigUtils.getBoolean((Config)ConfigStoreUtils.getConfig(configClient, u, (Optional<Config>)runtimeConfig), (String)"topic.blacklist", (boolean)false)).forEach(u -> blacklistedTopics.add(ConfigStoreUtils.getTopicNameFromURI(u)));
            return allTopics.stream().filter(p -> !blacklistedTopics.contains(p.getName())).collect(Collectors.toList());
        }
        log.warn("None of the blacklist or whitelist tags are provided");
        return allTopics;
    }

    public static void setTopicsFromConfigStore(Properties properties, Set<String> blacklist, Set<String> whitelist, String _blacklistTopicKey, String _whitelistTopicKey) {
        Optional<String> configStoreUri = ConfigStoreUtils.getConfigStoreUri(properties);
        if (!configStoreUri.isPresent()) {
            return;
        }
        ConfigClient configClient = ConfigClient.createConfigClient((VersionStabilityPolicy)VersionStabilityPolicy.WEAK_LOCAL_STABILITY);
        Optional runtimeConfig = ConfigClientUtils.getOptionalRuntimeConfig((Properties)properties);
        if (properties.containsKey(GOBBLIN_CONFIG_TAGS_WHITELIST)) {
            Preconditions.checkArgument((boolean)properties.containsKey(GOBBLIN_CONFIG_FILTER), (Object)"Missing required property gobblin.config.filter");
            String filterString = properties.getProperty(GOBBLIN_CONFIG_FILTER);
            Path whiteListTagUri = PathUtils.mergePaths((Path)new Path((String)configStoreUri.get()), (Path)new Path(properties.getProperty(GOBBLIN_CONFIG_TAGS_WHITELIST)));
            ConfigStoreUtils.getTopicsURIFromConfigStore(configClient, whiteListTagUri, filterString, (Optional<Config>)runtimeConfig).stream().filter(u -> ConfigUtils.getBoolean((Config)ConfigStoreUtils.getConfig(configClient, u, (Optional<Config>)runtimeConfig), (String)_whitelistTopicKey, (boolean)false)).forEach(u -> whitelist.add(ConfigStoreUtils.getTopicNameFromURI(u)));
        } else if (properties.containsKey(GOBBLIN_CONFIG_TAGS_BLACKLIST)) {
            Preconditions.checkArgument((boolean)properties.containsKey(GOBBLIN_CONFIG_FILTER), (Object)"Missing required property gobblin.config.filter");
            String filterString = properties.getProperty(GOBBLIN_CONFIG_FILTER);
            Path blackListTagUri = PathUtils.mergePaths((Path)new Path((String)configStoreUri.get()), (Path)new Path(properties.getProperty(GOBBLIN_CONFIG_TAGS_BLACKLIST)));
            ConfigStoreUtils.getTopicsURIFromConfigStore(configClient, blackListTagUri, filterString, (Optional<Config>)runtimeConfig).stream().filter(u -> ConfigUtils.getBoolean((Config)ConfigStoreUtils.getConfig(configClient, u, (Optional<Config>)runtimeConfig), (String)_blacklistTopicKey, (boolean)false)).forEach(u -> blacklist.add(ConfigStoreUtils.getTopicNameFromURI(u)));
        } else {
            log.warn("None of the blacklist or whitelist tags are provided");
        }
    }
}

