/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.metrics.kafka;

import com.google.common.base.Optional;
import com.typesafe.config.Config;
import org.apache.gobblin.metrics.kafka.Pusher;
import org.apache.gobblin.util.reflection.GobblinConstructorUtils;

public class PusherUtils {
    public static final String METRICS_REPORTING_KAFKA_CONFIG_PREFIX = "metrics.reporting.kafka.config";
    public static final String KAFKA_PUSHER_CLASS_NAME_KEY = "metrics.reporting.kafkaPusherClass";
    public static final String DEFAULT_KAFKA_PUSHER_CLASS_NAME = "org.apache.gobblin.metrics.kafka.KafkaPusher";

    public static Pusher getPusher(String pusherClassName, String brokers, String topic, Optional<Config> config) {
        try {
            Class<?> pusherClass = Class.forName(pusherClassName);
            return (Pusher)GobblinConstructorUtils.invokeLongestConstructor(pusherClass, (Object[])new Object[]{brokers, topic, config});
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Could not instantiate kafka pusher", e);
        }
    }
}

