/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.kafka.writer;

import com.google.common.base.Throwables;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.apache.gobblin.util.ConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaWriterHelper {
    private static final Logger log = LoggerFactory.getLogger(KafkaWriterHelper.class);

    static Properties getProducerProperties(Properties props) {
        Config config = ConfigUtils.propertiesToConfig((Properties)props);
        Config producerConfig = ConfigUtils.getConfigOrEmpty((Config)config, (String)"writer.kafka.producerConfig").withFallback((ConfigMergeable)ConfigUtils.getConfigOrEmpty((Config)config, (String)"gobblin.kafka.sharedConfig"));
        Properties producerProperties = ConfigUtils.configToProperties((Config)producerConfig);
        KafkaWriterHelper.setDefaultIfUnset(producerProperties, "key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        KafkaWriterHelper.setDefaultIfUnset(producerProperties, "value.serializer", "org.apache.kafka.common.serialization.ByteArraySerializer");
        KafkaWriterHelper.setDefaultIfUnset(producerProperties, "client.id", "gobblin");
        KafkaWriterHelper.setDefaultIfUnset(producerProperties, "kafka.schemaRegistry.switchName", "true");
        return producerProperties;
    }

    private static void setDefaultIfUnset(Properties props, String key, String value) {
        if (!props.containsKey(key)) {
            props.setProperty(key, value);
        }
    }

    private static Properties stripPrefix(Properties props, String prefix) {
        Properties strippedProps = new Properties();
        int prefixLength = prefix.length();
        for (String key : props.stringPropertyNames()) {
            if (!key.startsWith(prefix)) continue;
            strippedProps.setProperty(key.substring(prefixLength), props.getProperty(key));
        }
        return strippedProps;
    }

    public static Object getKafkaProducer(Properties props) {
        Config config = ConfigFactory.parseProperties((Properties)props);
        String kafkaProducerClass = ConfigUtils.getString((Config)config, (String)"writer.kafka.producerClass", (String)"org.apache.kafka.clients.producer.KafkaProducer");
        Properties producerProps = KafkaWriterHelper.getProducerProperties(props);
        try {
            Class<?> producerClass = Class.forName(kafkaProducerClass);
            Object producer = ConstructorUtils.invokeConstructor(producerClass, (Object[])new Object[]{producerProps});
            return producer;
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            log.error("Failed to instantiate Kafka producer from class " + kafkaProducerClass, (Throwable)e);
            throw Throwables.propagate((Throwable)e);
        }
    }
}

