/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.kafka.serialize;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.gobblin.kafka.schemareg.KafkaSchemaRegistry;
import org.apache.gobblin.kafka.schemareg.SchemaRegistryException;
import org.apache.gobblin.kafka.serialize.LiAvroSerDeHelper;
import org.apache.gobblin.kafka.serialize.MD5Digest;
import org.apache.gobblin.kafka.serialize.SerializationException;

public class LiAvroSerializerBase {
    private KafkaSchemaRegistry<MD5Digest, Schema> schemaRegistry;
    private final EncoderFactory encoderFactory = EncoderFactory.get();
    private boolean isKey = false;

    public void configure(Map<String, ?> configs, boolean isKey) {
        if (null == this.schemaRegistry) {
            this.schemaRegistry = LiAvroSerDeHelper.getSchemaRegistry(configs);
        }
        this.isKey = isKey;
    }

    public byte[] serialize(String topic, GenericRecord data) throws SerializationException {
        Schema schema = data.getSchema();
        MD5Digest schemaId = null;
        try {
            schemaId = this.schemaRegistry.register(topic, schema);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            out.write(0);
            out.write(schemaId.asBytes());
            BinaryEncoder encoder = this.encoderFactory.directBinaryEncoder((OutputStream)out, null);
            GenericDatumWriter writer = new GenericDatumWriter(schema);
            writer.write((Object)data, (Encoder)encoder);
            encoder.flush();
            byte[] bytes = out.toByteArray();
            out.close();
            return bytes;
        }
        catch (IOException | SchemaRegistryException e) {
            throw new SerializationException(e);
        }
    }

    public void close() {
    }
}

