/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.kafka.schemareg;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.gobblin.kafka.schemareg.KafkaSchemaRegistry;
import org.apache.gobblin.kafka.schemareg.SchemaRegistryException;
import org.apache.gobblin.kafka.serialize.MD5Digest;

public class ConfigDrivenMd5SchemaRegistry
implements KafkaSchemaRegistry<MD5Digest, Schema> {
    private final HashMap<MD5Digest, Schema> _schemaHashMap = new HashMap();
    private final HashMap<String, Schema> _topicSchemaMap = new HashMap();

    private final MD5Digest generateId(Schema schema) {
        try {
            byte[] schemaBytes = schema.toString().getBytes("UTF-8");
            byte[] md5bytes = MessageDigest.getInstance("MD5").digest(schemaBytes);
            MD5Digest md5Digest = MD5Digest.fromBytes(md5bytes);
            return md5Digest;
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException e) {
            throw new IllegalStateException("Unexpected error trying to convert schema to bytes", e);
        }
    }

    public ConfigDrivenMd5SchemaRegistry(String name, Schema schema) throws IOException, SchemaRegistryException {
        this.register(name, schema);
    }

    public ConfigDrivenMd5SchemaRegistry(Properties props) throws IOException, SchemaRegistryException {
        this(ConfigFactory.parseProperties((Properties)props));
    }

    public ConfigDrivenMd5SchemaRegistry(Config config) throws IOException, SchemaRegistryException {
        if (config.hasPath("schemaRegistry.schema.name")) {
            String name = config.getString("schemaRegistry.schema.name");
            String value = config.getString("schemaRegistry.schema.value");
            Schema schema = new Schema.Parser().parse(value);
            this.register(name, schema);
        }
    }

    @Override
    public synchronized MD5Digest register(String name, Schema schema) throws IOException, SchemaRegistryException {
        MD5Digest md5Digest = this.generateId(schema);
        if (!this._schemaHashMap.containsKey(md5Digest)) {
            this._schemaHashMap.put(md5Digest, schema);
            this._topicSchemaMap.put(name, schema);
        }
        return md5Digest;
    }

    @Override
    public Schema getById(MD5Digest id) throws IOException, SchemaRegistryException {
        if (this._schemaHashMap.containsKey(id)) {
            return this._schemaHashMap.get(id);
        }
        throw new SchemaRegistryException("Could not find schema with id : " + id.asString());
    }

    @Override
    public Schema getLatestSchema(String name) throws IOException, SchemaRegistryException {
        if (this._topicSchemaMap.containsKey(name)) {
            return this._topicSchemaMap.get(name);
        }
        throw new SchemaRegistryException("Could not find any schema for " + name);
    }

    @Override
    public boolean hasInternalCache() {
        return true;
    }

    private static class ConfigurationKeys {
        private static final String SCHEMA_NAME_KEY = "schemaRegistry.schema.name";
        private static final String SCHEMA_VALUE_KEY = "schemaRegistry.schema.value";

        private ConfigurationKeys() {
        }
    }
}

