/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gobblin.kafka.client;

import java.beans.ConstructorProperties;
import org.apache.gobblin.kafka.client.KafkaConsumerRecord;

public abstract class BaseKafkaConsumerRecord
implements KafkaConsumerRecord {
    private final long offset;
    private final long valueSizeInBytes;
    public static final long VALUE_SIZE_UNAVAILABLE = -1L;

    @Override
    public long getOffset() {
        return this.offset;
    }

    @Override
    public long getNextOffset() {
        return this.offset + 1L;
    }

    @Override
    public long getValueSizeInBytes() {
        return this.valueSizeInBytes;
    }

    @ConstructorProperties(value={"offset", "valueSizeInBytes"})
    public BaseKafkaConsumerRecord(long offset, long valueSizeInBytes) {
        this.offset = offset;
        this.valueSizeInBytes = valueSizeInBytes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseKafkaConsumerRecord)) {
            return false;
        }
        BaseKafkaConsumerRecord other = (BaseKafkaConsumerRecord)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getOffset() != other.getOffset()) {
            return false;
        }
        return this.getValueSizeInBytes() == other.getValueSizeInBytes();
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseKafkaConsumerRecord;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $offset = this.getOffset();
        result = result * 59 + (int)($offset >>> 32 ^ $offset);
        long $valueSizeInBytes = this.getValueSizeInBytes();
        result = result * 59 + (int)($valueSizeInBytes >>> 32 ^ $valueSizeInBytes);
        return result;
    }

    public String toString() {
        return "BaseKafkaConsumerRecord(offset=" + this.getOffset() + ", valueSizeInBytes=" + this.getValueSizeInBytes() + ")";
    }
}

