/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.gobblin.runtime;

import java.util.Map;

import com.google.common.collect.ImmutableMap;

import org.apache.gobblin.annotation.Alias;
import org.apache.gobblin.configuration.State;
import org.apache.gobblin.runtime.api.TaskEventMetadataGenerator;

@Alias("nooptask")
public class NoopTaskEventMetadataGenerator implements TaskEventMetadataGenerator  {
  /**
   * Generate a map of additional metadata for the specified event name.
   *
   * @param taskState
   * @param eventName the event name used to determine which additional metadata should be emitted
   * @return {@link Map} with the additional metadata
   */
  @Override
  public Map<String, String> getMetadata(State taskState, String eventName) {
    return ImmutableMap.of();
  }
}
