/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.geronimo.microprofile.impl.jwtauth.jaxrs;

import static javax.ws.rs.core.MediaType.APPLICATION_JSON_TYPE;

import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;

import org.apache.geronimo.microprofile.impl.jwtauth.JwtException;

@Provider
@Dependent
public class GeronimoJwtAuthExceptionMapper implements ExceptionMapper<JwtException> {
    @Inject
    private ResponseBuilder builder;

    @Override
    public Response toResponse(final JwtException e) {
        return Response.status(e.getStatus())
                .entity(builder.toObject(e))
                .type(APPLICATION_JSON_TYPE)
                .build();
    }
}
