/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.javamail.util;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.geronimo.mail.james.mime4j.codec.QuotedPrintableOutputStream;

public class TraceOutputStream
extends FilterOutputStream {
    protected boolean debug = false;
    protected OutputStream traceStream;

    public TraceOutputStream(OutputStream out, OutputStream traceStream, boolean debug, boolean encode) {
        super(out);
        this.debug = debug;
        this.traceStream = encode ? new QuotedPrintableOutputStream(traceStream, false) : traceStream;
    }

    public void setDebug(boolean d) {
        this.debug = d;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.debug) {
            this.traceStream.write(b);
        }
        super.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if (this.debug) {
            this.traceStream.write(b, off, len);
        }
        this.out.write(b, off, len);
    }

    @Override
    public void write(byte[] b) throws IOException {
        if (this.debug) {
            this.traceStream.write(b);
        }
        this.out.write(b);
    }
}

