/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.cq.internal.command;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.geode.cache.query.CqException;
import org.apache.geode.cache.query.cq.internal.command.BaseCQCommand;
import org.apache.geode.cache.query.internal.DefaultQueryService;
import org.apache.geode.cache.query.internal.cq.CqService;
import org.apache.geode.internal.cache.tier.Acceptor;
import org.apache.geode.internal.cache.tier.CachedRegionHelper;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.MessageType;
import org.apache.geode.internal.cache.tier.sockets.CacheServerStats;
import org.apache.geode.internal.cache.tier.sockets.ChunkedMessage;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.security.AuthorizeRequest;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.security.ResourcePermission;

public class GetDurableCQs
extends BaseCQCommand {
    private static final GetDurableCQs singleton = new GetDurableCQs();

    public static Command getCommand() {
        return singleton;
    }

    private GetDurableCQs() {
    }

    @Override
    public void cmdExecute(Message clientMessage, ServerConnection serverConnection, SecurityService securityService, long start) throws IOException, InterruptedException {
        Acceptor acceptor = serverConnection.getAcceptor();
        CachedRegionHelper crHelper = serverConnection.getCachedRegionHelper();
        ClientProxyMembershipID id = serverConnection.getProxyID();
        CacheServerStats stats = serverConnection.getCacheServerStats();
        serverConnection.setAsTrue(2);
        serverConnection.setAsTrue(3);
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Received {} request from {}", (Object)serverConnection.getName(), (Object)MessageType.getString(clientMessage.getMessageType()), (Object)serverConnection.getSocketString());
        }
        try {
            DefaultQueryService qService = (DefaultQueryService)crHelper.getCache().getLocalQueryService();
            securityService.authorize(ResourcePermission.Resource.CLUSTER, ResourcePermission.Operation.READ);
            AuthorizeRequest authzRequest = serverConnection.getAuthzRequest();
            if (authzRequest != null) {
                authzRequest.getDurableCQsAuthorize();
            }
            CqService cqServiceForExec = qService.getCqService();
            List<String> durableCqs = cqServiceForExec.getAllDurableClientCqs(id);
            ChunkedMessage chunkedResponseMsg = serverConnection.getChunkedResponseMessage();
            chunkedResponseMsg.setMessageType(1);
            chunkedResponseMsg.setTransactionId(clientMessage.getTransactionId());
            chunkedResponseMsg.sendHeader();
            ArrayList<String> durableCqList = new ArrayList<String>(MAXIMUM_CHUNK_SIZE);
            boolean isTraceEnabled = logger.isTraceEnabled();
            for (String durableCqName : durableCqs) {
                durableCqList.add(durableCqName);
                if (isTraceEnabled) {
                    logger.trace("{}: getDurableCqsResponse <{}>; list size was {}", (Object)serverConnection.getName(), (Object)durableCqName, (Object)durableCqList.size());
                }
                if (durableCqList.size() != MAXIMUM_CHUNK_SIZE) continue;
                this.sendDurableCqsResponseChunk(durableCqList, false, serverConnection);
                durableCqList.clear();
            }
            this.sendDurableCqsResponseChunk(durableCqList, true, serverConnection);
        }
        catch (CqException cqe) {
            this.sendCqResponse(50, "", clientMessage.getTransactionId(), cqe, serverConnection);
        }
        catch (Exception e) {
            GetDurableCQs.writeChunkedException(clientMessage, e, serverConnection);
        }
    }

    private void sendDurableCqsResponseChunk(List list, boolean lastChunk, ServerConnection servConn) throws IOException {
        ChunkedMessage chunkedResponseMsg = servConn.getChunkedResponseMessage();
        chunkedResponseMsg.setNumberOfParts(1);
        chunkedResponseMsg.setLastChunk(lastChunk);
        chunkedResponseMsg.addObjPart(list, false);
        if (logger.isDebugEnabled()) {
            logger.debug("{}: Sending {} durableCQs response chunk{}", (Object)servConn.getName(), (Object)(lastChunk ? " last " : " "), (Object)(logger.isTraceEnabled() ? " keys=" + list + " chunk=<" + chunkedResponseMsg + ">" : ""));
        }
        chunkedResponseMsg.sendChunk(servConn);
    }
}

