/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.functions;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.execute.InternalFunction;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.management.api.RealizationResult;
import org.apache.geode.management.configuration.AbstractConfiguration;
import org.apache.geode.management.configuration.Deployment;
import org.apache.geode.management.configuration.GatewayReceiver;
import org.apache.geode.management.configuration.Index;
import org.apache.geode.management.configuration.Member;
import org.apache.geode.management.configuration.Pdx;
import org.apache.geode.management.configuration.Region;
import org.apache.geode.management.internal.CacheElementOperation;
import org.apache.geode.management.internal.configuration.realizers.ConfigurationRealizer;
import org.apache.geode.management.internal.configuration.realizers.DeploymentRealizer;
import org.apache.geode.management.internal.configuration.realizers.GatewayReceiverRealizer;
import org.apache.geode.management.internal.configuration.realizers.IndexRealizer;
import org.apache.geode.management.internal.configuration.realizers.MemberRealizer;
import org.apache.geode.management.internal.configuration.realizers.PdxRealizer;
import org.apache.geode.management.internal.configuration.realizers.RegionConfigRealizer;
import org.apache.geode.management.runtime.RuntimeInfo;
import org.apache.logging.log4j.Logger;

public class CacheRealizationFunction
implements InternalFunction<List> {
    private static final Logger logger = LogService.getLogger();
    @Immutable
    private static final Map<Class, ConfigurationRealizer> realizers = new HashMap<Class, ConfigurationRealizer>();
    private static final long serialVersionUID = -2695517414081975343L;

    @Override
    public void execute(FunctionContext<List> context) {
        AbstractConfiguration cacheElement = (AbstractConfiguration)context.getArguments().get(0);
        CacheElementOperation operation = (CacheElementOperation)((Object)context.getArguments().get(1));
        InternalCache cache = (InternalCache)context.getCache();
        if (operation == CacheElementOperation.GET) {
            try {
                context.getResultSender().lastResult(this.executeGet(context, cache, cacheElement));
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                context.getResultSender().lastResult(null);
            }
        } else {
            try {
                context.getResultSender().lastResult(this.executeUpdate(context, cache, cacheElement, operation));
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                context.getResultSender().lastResult(new RealizationResult().setSuccess(false).setMemberName(context.getMemberName()).setMessage(e.getMessage()));
            }
        }
    }

    public RuntimeInfo executeGet(FunctionContext<List> context, InternalCache cache, AbstractConfiguration cacheElement) {
        ConfigurationRealizer realizer = realizers.get(cacheElement.getClass());
        if (realizer == null) {
            return null;
        }
        Object runtimeInfo = realizer.get(cacheElement, cache);
        if (!cacheElement.isGlobalRuntime()) {
            runtimeInfo.setMemberName(context.getMemberName());
        }
        return runtimeInfo;
    }

    public RealizationResult executeUpdate(FunctionContext<List> context, InternalCache cache, AbstractConfiguration cacheElement, CacheElementOperation operation) {
        ConfigurationRealizer realizer = realizers.get(cacheElement.getClass());
        RealizationResult result = new RealizationResult();
        result.setMemberName(context.getMemberName());
        if (realizer == null || realizer.isReadyOnly()) {
            return result.setMessage("Server '" + context.getMemberName() + "' needs to be restarted for this configuration change to be realized.");
        }
        switch (operation) {
            case CREATE: {
                if (realizer.exists(cacheElement, cache)) {
                    return result.setMessage(cacheElement.getClass().getSimpleName() + " '" + cacheElement.getId() + "' already exists. Skipped creation.");
                }
                result = realizer.create(cacheElement, cache);
                break;
            }
            case DELETE: {
                if (!realizer.exists(cacheElement, cache)) {
                    return result.setMessage(cacheElement.getClass().getSimpleName() + " '" + cacheElement.getId() + "' does not exist.");
                }
                result = realizer.delete(cacheElement, cache);
                break;
            }
            case UPDATE: {
                if (!realizer.exists(cacheElement, cache)) {
                    return result.setSuccess(false).setMessage(cacheElement.getClass().getSimpleName() + " '" + cacheElement.getId() + "' does not exist.");
                }
                result = realizer.update(cacheElement, cache);
            }
        }
        result.setMemberName(context.getMemberName());
        return result;
    }

    static {
        realizers.put(Region.class, new RegionConfigRealizer());
        realizers.put(GatewayReceiver.class, new GatewayReceiverRealizer());
        realizers.put(Member.class, new MemberRealizer());
        realizers.put(Pdx.class, new PdxRealizer());
        realizers.put(Deployment.class, new DeploymentRealizer());
        realizers.put(Index.class, new IndexRealizer());
    }
}

