/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.logging.internal.log4j;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.logging.internal.log4j.LogWriterLevelConverter;
import org.apache.geode.logging.internal.spi.LogWriterLevel;
import org.apache.logging.log4j.Level;

public class LogLevel {
    @Immutable
    private static final Map<String, Level> ANY_NAME_TO_LEVEL;
    @Immutable
    private static final Map<String, LogWriterLevel> ANY_NAME_TO_LOGWRITERLEVEL;

    public static Level resolveLevel(String anyLevelName) {
        Level log4jLevel = ANY_NAME_TO_LEVEL.get(anyLevelName.toUpperCase());
        return log4jLevel == null ? Level.OFF : log4jLevel;
    }

    public static Level getLevel(String anyLevelName) {
        return ANY_NAME_TO_LEVEL.get(anyLevelName.toUpperCase());
    }

    public static int getLogWriterLevel(String anyLevelName) {
        if (anyLevelName == null) {
            throw new IllegalArgumentException("LevelName cannot be null");
        }
        if (ANY_NAME_TO_LOGWRITERLEVEL.get(anyLevelName.toUpperCase()) != null) {
            return ANY_NAME_TO_LOGWRITERLEVEL.get(anyLevelName.toUpperCase()).intLevel();
        }
        if (anyLevelName.toLowerCase().startsWith("level-")) {
            String levelValue = anyLevelName.toLowerCase().substring("level-".length());
            return Integer.parseInt(levelValue);
        }
        String values = Arrays.stream(Level.values()).sorted().map(Level::name).collect(Collectors.joining(", "));
        throw new IllegalArgumentException("Unknown log-level \"" + anyLevelName + "\". Valid levels are: " + values + ".");
    }

    static {
        HashMap<String, Level> nameToLevel = new HashMap<String, Level>();
        HashMap<String, LogWriterLevel> nameToLogLevel = new HashMap<String, LogWriterLevel>();
        nameToLogLevel.put(LogWriterLevel.NONE.name(), LogWriterLevel.NONE);
        nameToLogLevel.put(LogWriterLevel.SEVERE.name(), LogWriterLevel.SEVERE);
        nameToLogLevel.put(LogWriterLevel.ERROR.name(), LogWriterLevel.ERROR);
        nameToLogLevel.put(LogWriterLevel.WARNING.name(), LogWriterLevel.WARNING);
        nameToLogLevel.put(LogWriterLevel.INFO.name(), LogWriterLevel.INFO);
        nameToLogLevel.put(LogWriterLevel.CONFIG.name(), LogWriterLevel.CONFIG);
        nameToLogLevel.put(LogWriterLevel.FINE.name(), LogWriterLevel.FINE);
        nameToLogLevel.put(LogWriterLevel.FINER.name(), LogWriterLevel.FINER);
        nameToLogLevel.put(LogWriterLevel.FINEST.name(), LogWriterLevel.FINEST);
        nameToLogLevel.put(LogWriterLevel.ALL.name(), LogWriterLevel.ALL);
        nameToLogLevel.put(Level.OFF.name(), LogWriterLevel.NONE);
        nameToLogLevel.put(Level.FATAL.name(), LogWriterLevel.SEVERE);
        nameToLogLevel.put(Level.WARN.name(), LogWriterLevel.WARNING);
        nameToLogLevel.put(Level.DEBUG.name(), LogWriterLevel.FINE);
        nameToLogLevel.put(Level.TRACE.name(), LogWriterLevel.FINEST);
        Arrays.stream(Level.values()).forEach(level -> nameToLevel.put(level.name(), (Level)level));
        nameToLevel.put(LogWriterLevel.SEVERE.name(), LogWriterLevelConverter.toLevel(LogWriterLevel.find(LogWriterLevel.SEVERE.intLevel())));
        nameToLevel.put(LogWriterLevel.WARNING.name(), LogWriterLevelConverter.toLevel(LogWriterLevel.find(LogWriterLevel.WARNING.intLevel())));
        nameToLevel.put(LogWriterLevel.CONFIG.name(), LogWriterLevelConverter.toLevel(LogWriterLevel.find(LogWriterLevel.CONFIG.intLevel())));
        nameToLevel.put(LogWriterLevel.FINE.name(), LogWriterLevelConverter.toLevel(LogWriterLevel.find(LogWriterLevel.FINE.intLevel())));
        nameToLevel.put(LogWriterLevel.FINER.name(), LogWriterLevelConverter.toLevel(LogWriterLevel.find(LogWriterLevel.FINER.intLevel())));
        nameToLevel.put(LogWriterLevel.FINEST.name(), LogWriterLevelConverter.toLevel(LogWriterLevel.find(LogWriterLevel.FINEST.intLevel())));
        nameToLevel.put(LogWriterLevel.NONE.name(), LogWriterLevelConverter.toLevel(LogWriterLevel.find(LogWriterLevel.NONE.intLevel())));
        ANY_NAME_TO_LOGWRITERLEVEL = Collections.unmodifiableMap(nameToLogLevel);
        ANY_NAME_TO_LEVEL = Collections.unmodifiableMap(nameToLevel);
    }
}

