/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.logging.internal;

import java.util.Optional;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.internal.logging.Banner;
import org.apache.geode.logging.internal.Configuration;
import org.apache.geode.logging.internal.InternalSessionContext;
import org.apache.geode.logging.internal.LoggingSessionNotifier;
import org.apache.geode.logging.internal.LoggingSessionRegistryProvider;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.logging.internal.spi.LogConfigSupplier;
import org.apache.geode.logging.internal.spi.LogFile;
import org.apache.logging.log4j.Logger;

public class LoggingSession
implements InternalSessionContext {
    private static final Logger logger = LogService.getLogger();
    private final Configuration configuration;
    private final LoggingSessionNotifier loggingSessionNotifier;
    private volatile boolean logBanner;
    private volatile boolean logConfiguration;
    private InternalSessionContext.State state = InternalSessionContext.State.STOPPED;

    public static LoggingSession create() {
        return LoggingSession.create(Configuration.create(), LoggingSessionRegistryProvider.get());
    }

    @VisibleForTesting
    static LoggingSession create(Configuration configuration, LoggingSessionNotifier loggingSessionNotifier) {
        return new LoggingSession(configuration, loggingSessionNotifier);
    }

    LoggingSession(Configuration configuration, LoggingSessionNotifier loggingSessionNotifier) {
        this.configuration = configuration;
        this.loggingSessionNotifier = loggingSessionNotifier;
    }

    public synchronized void createSession(LogConfigSupplier logConfigSupplier) {
        this.createSession(logConfigSupplier, true, true);
    }

    public synchronized void createSession(LogConfigSupplier logConfigSupplier, boolean logBanner, boolean logConfiguration) {
        this.configuration.initialize(logConfigSupplier);
        this.state = this.state.changeTo(InternalSessionContext.State.CREATED);
        this.loggingSessionNotifier.createSession(this);
        this.logBanner = logBanner;
        this.logConfiguration = logConfiguration;
    }

    public synchronized void startSession() {
        this.state = this.state.changeTo(InternalSessionContext.State.STARTED);
        this.loggingSessionNotifier.startSession();
        this.configuration.disableLoggingToStandardOutputIfLoggingToFile();
        if (this.logBanner) {
            logger.info(new Banner(this.configuration.getConfigurationInfo()).getString());
        }
        if (this.logConfiguration) {
            String configInfo = this.configuration.getLogConfigSupplier().getLogConfig().toLoggerString();
            logger.info("Startup Configuration: " + System.lineSeparator() + configInfo);
        }
    }

    public synchronized void stopSession() {
        this.configuration.enableLoggingToStandardOutput();
        this.state = this.state.changeTo(InternalSessionContext.State.STOPPED);
        this.loggingSessionNotifier.stopSession();
    }

    public synchronized void shutdown() {
        this.configuration.shutdown();
    }

    public Optional<LogFile> getLogFile() {
        return this.loggingSessionNotifier.getLogFile();
    }

    @Override
    public InternalSessionContext.State getState() {
        return this.state;
    }

    @Override
    public LogConfigSupplier getLogConfigSupplier() {
        return this.configuration.getLogConfigSupplier();
    }

    @VisibleForTesting
    LoggingSessionNotifier getLoggingSessionNotifier() {
        return this.loggingSessionNotifier;
    }
}

