/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.net;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import org.apache.geode.GemFireIOException;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.internal.inet.LocalHostUtil;

public class InetAddressUtils {
    @Immutable
    private static final InetAddress LOCALHOST = InetAddressUtils.getLocalHost();
    private static final String LOOPBACK_ADDRESS = LocalHostUtil.preferIPv6Addresses() ? "::1" : "127.0.0.1";
    @Immutable
    private static final InetAddress LOOPBACK = InetAddressUtils.toInetAddress(LOOPBACK_ADDRESS);

    private InetAddressUtils() {
    }

    public static InetAddress getLoopback() {
        return LOOPBACK;
    }

    public static String getLoopbackAddress() {
        return LOOPBACK_ADDRESS;
    }

    public static String toHostString(Object val) {
        if (val instanceof String) {
            return InetAddressUtils.trimLeadingSlash((String)val);
        }
        if (val instanceof InetAddress) {
            return ((InetAddress)val).getHostAddress();
        }
        return InetAddressUtils.trimLeadingSlash(val.toString());
    }

    public static InetAddress toInetAddress(String host) {
        try {
            return InetAddressUtils.toInetAddressOrThrow(host);
        }
        catch (UnknownHostException e) {
            throw new AssertionError("Failed to get InetAddress: " + host, e);
        }
    }

    public static String validateHost(String host) {
        try {
            return InetAddressUtils.validateHostOrThrow(host);
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    public static boolean isLocalHost(InetAddress host) {
        if (LOCALHOST.equals(host)) {
            return true;
        }
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface i = en.nextElement();
                Enumeration<InetAddress> en2 = i.getInetAddresses();
                while (en2.hasMoreElements()) {
                    InetAddress addr = en2.nextElement();
                    if (!host.equals(addr)) continue;
                    return true;
                }
            }
            return false;
        }
        catch (SocketException e) {
            throw new GemFireIOException("Unable to query network interface", e);
        }
    }

    public static boolean isLocalHost(String host) {
        return InetAddressUtils.isLocalHost(InetAddressUtils.toInetAddress(host));
    }

    public static boolean isLoopback(InetAddress host) {
        return LOOPBACK.equals(host);
    }

    public static boolean isLoopback(String host) {
        return InetAddressUtils.isLoopback(InetAddressUtils.toInetAddress(host));
    }

    protected static String trimLeadingSlash(String value) {
        if (value == null) {
            return "";
        }
        while (value.indexOf(47) > -1) {
            value = value.substring(value.indexOf(47) + 1);
        }
        return value;
    }

    protected static InetAddress toInetAddressOrThrow(String host) throws UnknownHostException {
        if (host == null || host.isEmpty()) {
            return null;
        }
        if (host.contains("/")) {
            return InetAddress.getByName(host.substring(host.indexOf(47) + 1));
        }
        return InetAddress.getByName(host);
    }

    protected static String validateHostOrThrow(String host) throws UnknownHostException {
        if (host == null || host.isEmpty()) {
            return null;
        }
        InetAddress.getByName(InetAddressUtils.trimLeadingSlash(host));
        return host;
    }

    private static InetAddress getLocalHost() {
        try {
            return LocalHostUtil.getLocalHost();
        }
        catch (UnknownHostException e) {
            throw new AssertionError("Failed to get local host", e);
        }
    }
}

