/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.datasource;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.Serializable;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.geode.CancelException;
import org.apache.geode.SystemFailure;
import org.apache.geode.internal.datasource.ConfiguredDataSourceProperties;
import org.apache.geode.internal.datasource.ConnectionPoolCache;
import org.apache.geode.internal.datasource.PoolException;
import org.apache.geode.logging.internal.executors.LoggingThread;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public abstract class AbstractPoolCache
implements ConnectionPoolCache,
Serializable {
    private static final Logger logger = LogService.getLogger();
    protected int INIT_LIMIT;
    private int MAX_LIMIT;
    protected transient Map availableCache = new HashMap();
    protected transient Map activeCache = Collections.synchronizedMap(new LinkedHashMap());
    protected EventListener connEventListner;
    protected ConfiguredDataSourceProperties configProps;
    protected int expirationTime;
    protected int timeOut;
    protected int loginTimeOut;
    public transient ConnectionCleanUpThread cleaner;
    private int totalConnections = 0;
    private int activeConnections = 0;
    private List expiredConns = null;
    protected long sleepTime = -1L;
    private Thread th = null;

    @SuppressWarnings(value={"SC_START_IN_CTOR"}, justification="the thread started is a cleanup thread and is not active until there is a timeout tx")
    public AbstractPoolCache(EventListener eventListner, ConfiguredDataSourceProperties configs) throws PoolException {
        this.connEventListner = eventListner;
        this.expiredConns = Collections.synchronizedList(new ArrayList());
        this.MAX_LIMIT = configs.getMaxPoolSize();
        this.expirationTime = configs.getConnectionExpirationTime() * 1000;
        this.timeOut = configs.getConnectionTimeOut() * 1000;
        this.loginTimeOut = configs.getLoginTimeOut() * 1000;
        this.INIT_LIMIT = Math.min(configs.getInitialPoolSize(), this.MAX_LIMIT);
        this.configProps = configs;
        this.cleaner = new ConnectionCleanUpThread();
        this.th = new LoggingThread("ConnectionCleanUpThread", (Runnable)this.cleaner);
        this.th.start();
    }

    protected void initializePool() {
        if (this.INIT_LIMIT > 0) {
            long currTime = System.currentTimeMillis();
            for (int count = 0; count < this.INIT_LIMIT; ++count) {
                try {
                    this.availableCache.put(this.getNewPoolConnection(), currTime);
                    ++this.totalConnections;
                    continue;
                }
                catch (Exception ex) {
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug("AbstractPoolCache::initializePool:Error in creating connection", ex.getCause());
                }
            }
        }
    }

    public abstract Object getNewPoolConnection() throws PoolException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void returnPooledConnectionToPool(Object connectionObject) {
        Object object;
        boolean returnedHappened = false;
        if (connectionObject != null) {
            object = connectionObject;
            synchronized (object) {
                if (this.activeCache.containsKey(connectionObject)) {
                    this.activeCache.remove(connectionObject);
                    returnedHappened = true;
                }
            }
        }
        if (returnedHappened) {
            object = this.availableCache;
            synchronized (object) {
                --this.activeConnections;
                this.availableCache.put(connectionObject, System.currentTimeMillis());
                this.availableCache.notify();
            }
        }
    }

    abstract void destroyPooledConnection(Object var1);

    public int getActiveCacheSize() {
        return this.activeConnections;
    }

    public int getAvailableCacheSize() {
        return this.totalConnections - this.activeConnections;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void expirePooledConnection(Object connectionObject) {
        Object object = connectionObject;
        synchronized (object) {
            if (this.activeCache.containsKey(connectionObject)) {
                long prev = (Long)this.activeCache.get(connectionObject);
                prev = prev - (long)this.timeOut - 1000L;
                this.activeCache.put(connectionObject, prev);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getPooledConnectionFromPool() throws PoolException {
        Object poolConn = null;
        long now = System.currentTimeMillis();
        Map map = this.availableCache;
        synchronized (map) {
            while (this.totalConnections - this.activeConnections == 0 && this.totalConnections == this.MAX_LIMIT) {
                try {
                    this.availableCache.wait(this.loginTimeOut);
                    long newtime = System.currentTimeMillis();
                    long duration = newtime - now;
                    if (duration <= (long)this.loginTimeOut) continue;
                    throw new PoolException("AbstractPooledCache::getPooledConnectionFromPool:Login time-out exceeded");
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    if (logger.isDebugEnabled()) {
                        logger.debug("AbstractPooledCache::getPooledConnectionFromPool:InterruptedException in waiting thread");
                    }
                    throw new PoolException("AbstractPooledCache::getPooledConnectionFromPool:InterruptedException in waiting thread");
                }
            }
            if (this.totalConnections - this.activeConnections > 0 && (poolConn = this.checkOutConnection(now)) != null) {
                this.activeCache.put(poolConn, now);
                ++this.activeConnections;
            }
            if (poolConn == null) {
                poolConn = this.getNewPoolConnection();
                this.activeCache.put(poolConn, now);
                ++this.totalConnections;
                ++this.activeConnections;
            }
        }
        map = this.activeCache;
        synchronized (map) {
            this.activeCache.notify();
        }
        return poolConn;
    }

    public int getMaxLimit() {
        return this.MAX_LIMIT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object checkOutConnection(long now) throws PoolException {
        Object retConn = null;
        Set entryset = this.availableCache.entrySet();
        Iterator itr = entryset.iterator();
        Map.Entry entry = null;
        while (itr.hasNext()) {
            entry = itr.next();
            long time = (Long)entry.getValue();
            if (now - time <= (long)this.expirationTime) {
                retConn = entry.getKey();
                itr.remove();
                break;
            }
            List list = this.expiredConns;
            synchronized (list) {
                this.expiredConns.add(entry.getKey());
            }
            itr.remove();
            --this.totalConnections;
        }
        return retConn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanUp() {
        ArrayList temp;
        Object associatedValue;
        Map conn;
        int numConnTimedOut = 0;
        long now = System.currentTimeMillis();
        this.sleepTime = -1L;
        boolean toContinue = true;
        while (toContinue) {
            conn = null;
            associatedValue = null;
            Map map = this.activeCache;
            synchronized (map) {
                Set set = this.activeCache.entrySet();
                Iterator itr = set.iterator();
                if (!itr.hasNext()) {
                    toContinue = false;
                    continue;
                }
                Map.Entry entry = itr.next();
                conn = entry.getKey();
                associatedValue = (Long)entry.getValue();
            }
            map = conn;
            synchronized (map) {
                if (this.activeCache.containsKey(conn)) {
                    Long associatedValueInWindow = (Long)this.activeCache.get(conn);
                    long then = associatedValueInWindow;
                    if (associatedValueInWindow.longValue() == ((Long)associatedValue).longValue()) {
                        if (now - then > (long)this.timeOut) {
                            this.activeCache.remove(conn);
                            this.expiredConns.add(conn);
                            ++numConnTimedOut;
                        } else {
                            this.sleepTime = then + (long)this.timeOut - now;
                            toContinue = false;
                        }
                    }
                }
            }
        }
        if (numConnTimedOut > 0) {
            conn = this.availableCache;
            synchronized (conn) {
                this.activeConnections -= numConnTimedOut;
                this.totalConnections -= numConnTimedOut;
                if (numConnTimedOut == 1) {
                    this.availableCache.notify();
                } else {
                    this.availableCache.notifyAll();
                }
            }
        }
        associatedValue = this.expiredConns;
        synchronized (associatedValue) {
            temp = new ArrayList(this.expiredConns);
            this.expiredConns.clear();
        }
        int size = temp.size();
        for (int i = 0; i < size; ++i) {
            Object conn2 = temp.get(i);
            this.destroyPooledConnection(conn2);
        }
        temp.clear();
    }

    @Override
    public void clearUp() {
        block7: {
            block6: {
                this.cleaner.toContinueRunning = false;
                try {
                    this.th.interrupt();
                }
                catch (Exception e) {
                    if (!logger.isDebugEnabled()) break block6;
                    logger.debug("AbstractPoolCache::clearUp: Exception in interrupting the thread", (Throwable)e);
                }
            }
            try {
                Iterator availableCacheItr = this.availableCache.keySet().iterator();
                Iterator activeCacheItr = this.activeCache.keySet().iterator();
                while (activeCacheItr.hasNext()) {
                    ((Connection)activeCacheItr.next()).close();
                }
                while (availableCacheItr.hasNext()) {
                    ((Connection)availableCacheItr.next()).close();
                }
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled()) break block7;
                logger.debug("AbstractPoolCache::clearUp: Exception in closing connections. Ignoring this exception)");
            }
        }
    }

    class ConnectionCleanUpThread
    implements Runnable {
        protected volatile boolean toContinueRunning = true;

        ConnectionCleanUpThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.toContinueRunning) {
                SystemFailure.checkFailure();
                try {
                    AbstractPoolCache.this.cleanUp();
                    if (AbstractPoolCache.this.sleepTime != -1L) {
                        Thread.sleep(AbstractPoolCache.this.sleepTime);
                    }
                    Map map = AbstractPoolCache.this.activeCache;
                    synchronized (map) {
                        if (AbstractPoolCache.this.activeCache.isEmpty() && this.toContinueRunning) {
                            AbstractPoolCache.this.activeCache.wait();
                        }
                    }
                }
                catch (InterruptedException e) {
                    if (!this.toContinueRunning) break;
                    logger.debug("ConnectionCleanupThread: interrupted", (Throwable)e);
                    break;
                }
                catch (CancelException e) {
                    if (!this.toContinueRunning) break;
                    logger.debug("ConnectionCleanupThread: cancelled", (Throwable)e);
                    break;
                }
                catch (Exception e) {
                    if (!logger.isDebugEnabled() || !this.toContinueRunning) continue;
                    logger.debug("ConnectionCleanUpThread::run: Thread encountered Exception. e={}. Ignoring the exception", (Object)e.getMessage(), (Object)e);
                }
            }
        }
    }
}

