/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets.command;

import java.io.IOException;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.LowMemoryException;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionException;
import org.apache.geode.cache.execute.ResultSender;
import org.apache.geode.cache.operations.ExecuteFunctionOperationContext;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.execute.AbstractExecution;
import org.apache.geode.internal.cache.execute.FunctionContextImpl;
import org.apache.geode.internal.cache.execute.InternalFunctionExecutionService;
import org.apache.geode.internal.cache.execute.InternalFunctionInvocationTargetException;
import org.apache.geode.internal.cache.execute.InternalFunctionService;
import org.apache.geode.internal.cache.execute.MemberMappedArgument;
import org.apache.geode.internal.cache.execute.ServerToClientFunctionResultSender65;
import org.apache.geode.internal.cache.execute.metrics.FunctionStats;
import org.apache.geode.internal.cache.execute.metrics.FunctionStatsManager;
import org.apache.geode.internal.cache.tier.Command;
import org.apache.geode.internal.cache.tier.ServerSideHandshake;
import org.apache.geode.internal.cache.tier.sockets.BaseCommand;
import org.apache.geode.internal.cache.tier.sockets.ChunkedMessage;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.Part;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.security.AuthorizeRequest;
import org.apache.geode.internal.security.SecurityService;

public class ExecuteFunction65
extends BaseCommand {
    @Immutable
    private static final ExecuteFunction65 singleton = new ExecuteFunction65();
    private final InternalFunctionExecutionService internalFunctionExecutionService;
    private final ServerToClientFunctionResultSender65Factory serverToClientFunctionResultSender65Factory;
    private final FunctionContextImplFactory functionContextImplFactory;

    public static Command getCommand() {
        return singleton;
    }

    private ExecuteFunction65() {
        this(InternalFunctionService.getInternalFunctionExecutionService(), new DefaultServerToClientFunctionResultSender65Factory(), new DefaultFunctionContextImplFactory());
    }

    @VisibleForTesting
    ExecuteFunction65(InternalFunctionExecutionService internalFunctionExecutionService, ServerToClientFunctionResultSender65Factory serverToClientFunctionResultSender65Factory, FunctionContextImplFactory functionContextImplFactory) {
        this.internalFunctionExecutionService = internalFunctionExecutionService;
        this.serverToClientFunctionResultSender65Factory = serverToClientFunctionResultSender65Factory;
        this.functionContextImplFactory = functionContextImplFactory;
    }

    @Override
    public void cmdExecute(Message clientMessage, ServerConnection serverConnection, SecurityService securityService, long start) throws IOException {
        boolean isReexecute;
        byte functionState;
        byte hasResult;
        MemberMappedArgument memberMappedArg;
        Object args;
        Object function;
        block29: {
            function = null;
            args = null;
            memberMappedArg = null;
            hasResult = 0;
            functionState = 0;
            isReexecute = false;
            try {
                functionState = clientMessage.getPart(0).getSerializedForm()[0];
                if (functionState == 11) {
                    functionState = 3;
                    isReexecute = true;
                } else if (functionState == 15) {
                    functionState = 7;
                    isReexecute = true;
                }
                hasResult = functionState != 1 ? (byte)((byte)((functionState & 2) - 1)) : functionState;
                if (hasResult == 1) {
                    serverConnection.setAsTrue(2);
                    serverConnection.setAsTrue(3);
                }
                function = clientMessage.getPart(1).getStringOrObject();
                args = clientMessage.getPart(2).getObject();
                Part part = clientMessage.getPart(3);
                if (part != null) {
                    memberMappedArg = (MemberMappedArgument)part.getObject();
                }
            }
            catch (ClassNotFoundException e) {
                logger.warn("Exception on server while executing function: {}", function, (Object)e);
                if (hasResult != true) break block29;
                ExecuteFunction65.writeChunkedException(clientMessage, e, serverConnection);
                serverConnection.setAsTrue(1);
                return;
            }
        }
        if (function == null) {
            String message = "The input function for the execute function request is null";
            logger.warn("{}: {}", (Object)serverConnection.getName(), (Object)message);
            this.sendError(hasResult, clientMessage, message, serverConnection);
            return;
        }
        try {
            Function functionObject;
            if (function instanceof String) {
                functionObject = this.internalFunctionExecutionService.getFunction((String)function);
                if (functionObject == null) {
                    String message = String.format("Function named %s is not registered to FunctionService", function);
                    logger.warn("{}: {}", (Object)serverConnection.getName(), (Object)message);
                    this.sendError(hasResult, clientMessage, message, serverConnection);
                    return;
                }
                byte functionStateOnServerSide = AbstractExecution.getFunctionState(functionObject.isHA(), functionObject.hasResult(), functionObject.optimizeForWrite());
                if (logger.isDebugEnabled()) {
                    logger.debug("Function State on server side: {} on client: {}", (Object)functionStateOnServerSide, (Object)functionState);
                }
                if (functionStateOnServerSide != functionState) {
                    String message = "Function attributes at client and server don't match";
                    logger.warn("{}: {}", (Object)serverConnection.getName(), (Object)message);
                    this.sendError(hasResult, clientMessage, message, serverConnection);
                    return;
                }
            } else {
                functionObject = (Function)function;
            }
            FunctionStats stats = FunctionStatsManager.getFunctionStats(functionObject.getId());
            functionObject.getRequiredPermissions(null, args).forEach(securityService::authorize);
            AuthorizeRequest authzRequest = serverConnection.getAuthzRequest();
            ExecuteFunctionOperationContext executeContext = null;
            if (authzRequest != null) {
                executeContext = authzRequest.executeFunctionAuthorize(functionObject.getId(), null, null, args, functionObject.optimizeForWrite());
            }
            ChunkedMessage chunkedMessage = serverConnection.getFunctionResponseMessage();
            chunkedMessage.setTransactionId(clientMessage.getTransactionId());
            ServerToClientFunctionResultSender65 resultSender = this.serverToClientFunctionResultSender65Factory.create(chunkedMessage, 63, serverConnection, functionObject, executeContext);
            InternalCache cache = serverConnection.getCache();
            InternalDistributedMember localVM = (InternalDistributedMember)cache.getDistributedSystem().getDistributedMember();
            FunctionContextImpl context = memberMappedArg != null ? this.functionContextImplFactory.create(cache, functionObject.getId(), memberMappedArg.getArgumentsForMember(localVM.getId()), resultSender, isReexecute) : this.functionContextImplFactory.create(cache, functionObject.getId(), args, resultSender, isReexecute);
            ServerSideHandshake handshake = serverConnection.getHandshake();
            int earlierClientReadTimeout = handshake.getClientReadTimeout();
            handshake.setClientReadTimeout(0);
            long startExecution = stats.startFunctionExecution(functionObject.hasResult());
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug("Executing Function on Server: {} with context: {}", (Object)serverConnection, (Object)context);
                }
                cache.getInternalResourceManager().getHeapMonitor().createLowMemoryIfNeeded(null, (DistributedMember)null);
                LowMemoryException lowMemoryException = cache.getInternalResourceManager().getHeapMonitor().createLowMemoryIfNeeded(functionObject, cache.getMyId());
                if (lowMemoryException != null) {
                    this.sendException(hasResult, clientMessage, lowMemoryException.getMessage(), serverConnection, lowMemoryException);
                    return;
                }
                functionObject.execute(context);
                if (!resultSender.isLastResultReceived() && functionObject.hasResult()) {
                    throw new FunctionException(String.format("The function, %s, did not send last result", functionObject.getId()));
                }
                stats.endFunctionExecution(startExecution, functionObject.hasResult());
            }
            catch (FunctionException e) {
                stats.endFunctionExecutionWithException(startExecution, functionObject.hasResult());
                throw e;
            }
            catch (Exception e) {
                stats.endFunctionExecutionWithException(startExecution, functionObject.hasResult());
                throw new FunctionException(e);
            }
            finally {
                handshake.setClientReadTimeout(earlierClientReadTimeout);
            }
        }
        catch (IOException e) {
            logger.warn("Exception on server while executing function: {}", function, (Object)e);
            String message = "Server could not send the reply";
            this.sendException(hasResult, clientMessage, message, serverConnection, e);
        }
        catch (InternalFunctionInvocationTargetException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("Exception on server while executing function: {}", function, (Object)e);
            }
            this.sendException(hasResult, clientMessage, e.getMessage(), serverConnection, e);
        }
        catch (Exception e) {
            logger.warn("Exception on server while executing function: {}", function, (Object)e);
            this.sendException(hasResult, clientMessage, e.getMessage(), serverConnection, e);
        }
    }

    private void sendException(byte hasResult, Message msg, String message, ServerConnection serverConnection, Throwable e) throws IOException {
        if (hasResult == 1) {
            ExecuteFunction65.writeFunctionResponseException(msg, 2, serverConnection, e);
            serverConnection.setAsTrue(1);
        }
    }

    private void sendError(byte hasResult, Message msg, String message, ServerConnection serverConnection) throws IOException {
        if (hasResult == 1) {
            ExecuteFunction65.writeFunctionResponseError(msg, 64, message, serverConnection);
            serverConnection.setAsTrue(1);
        }
    }

    private static class DefaultFunctionContextImplFactory
    implements FunctionContextImplFactory {
        private DefaultFunctionContextImplFactory() {
        }

        @Override
        public FunctionContextImpl create(Cache cache, String functionId, Object args, ResultSender resultSender, boolean isPossibleDuplicat) {
            return new FunctionContextImpl(cache, functionId, args, resultSender, isPossibleDuplicat);
        }
    }

    private static class DefaultServerToClientFunctionResultSender65Factory
    implements ServerToClientFunctionResultSender65Factory {
        private DefaultServerToClientFunctionResultSender65Factory() {
        }

        @Override
        public ServerToClientFunctionResultSender65 create(ChunkedMessage msg, int messageType, ServerConnection sc, Function function, ExecuteFunctionOperationContext authzContext) {
            return new ServerToClientFunctionResultSender65(msg, messageType, sc, function, authzContext);
        }
    }

    static interface FunctionContextImplFactory {
        public FunctionContextImpl create(Cache var1, String var2, Object var3, ResultSender var4, boolean var5);
    }

    static interface ServerToClientFunctionResultSender65Factory {
        public ServerToClientFunctionResultSender65 create(ChunkedMessage var1, int var2, ServerConnection var3, Function var4, ExecuteFunctionOperationContext var5);
    }
}

