/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tier.sockets;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.geode.internal.cache.tier.MessageType;
import org.apache.geode.internal.cache.tier.sockets.Message;
import org.apache.geode.internal.cache.tier.sockets.Part;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.serialization.Version;
import org.apache.geode.internal.serialization.VersionOrdinal;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class ChunkedMessage
extends Message {
    private static final Logger logger = LogService.getLogger();
    private static final int CHUNK_HEADER_LENGTH = 5;
    private static final int CHUNK_MSG_HEADER_LENGTH = 12;
    protected int chunkLength;
    protected byte lastChunk;
    private transient boolean headerSent = false;

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        sb.append("; chunkLength= " + this.chunkLength);
        sb.append("; lastChunk=" + this.lastChunk);
        return sb.toString();
    }

    public ChunkedMessage(int numberOfParts, Version version) {
        super(numberOfParts, version);
    }

    @Override
    public int getHeaderLength() {
        return 12;
    }

    public void setLastChunk(boolean lastChunk) {
        if (lastChunk) {
            this.lastChunk = 1;
            this.setFESpecialCase();
        } else {
            this.lastChunk = 0;
        }
    }

    private void setFESpecialCase() {
        byte b = ServerConnection.isExecuteFunctionOnLocalNodeOnly();
        if ((b & 1) == 1 && (b & 2) == 2) {
            this.lastChunk = (byte)(this.lastChunk | 4);
        }
    }

    public void setLastChunkAndNumParts(boolean lastChunk, int numParts) {
        this.setLastChunk(lastChunk);
        if (this.serverConnection != null && this.serverConnection.getClientVersion().compareTo((VersionOrdinal)Version.GFE_65) >= 0) {
            byte localLastChunk = (byte)(numParts << 5);
            this.lastChunk = (byte)(this.lastChunk | localLastChunk);
        }
    }

    public void setServerConnection(ServerConnection servConn) {
        if (this.serverConnection != servConn) {
            throw new IllegalStateException("this.sc was not correctly set");
        }
    }

    public boolean isLastChunk() {
        return (this.lastChunk & 1) == 1;
    }

    public int getChunkLength() {
        return this.chunkLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readHeader() throws IOException {
        if (this.socket != null) {
            ByteBuffer cb;
            ByteBuffer byteBuffer = cb = this.getCommBuffer();
            synchronized (byteBuffer) {
                this.fetchHeader();
                int type = cb.getInt();
                int numParts = cb.getInt();
                int txid = cb.getInt();
                cb.clear();
                if (!MessageType.validate(type)) {
                    throw new IOException(String.format("Invalid message type %s while reading header", type));
                }
                this.messageType = type;
                this.numberOfParts = numParts;
                this.transactionId = txid;
            }
        } else {
            throw new IOException("Dead Connection");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveChunk() throws IOException {
        if (this.socket != null) {
            ByteBuffer byteBuffer = this.getCommBuffer();
            synchronized (byteBuffer) {
                this.readChunk();
            }
        } else {
            throw new IOException("Dead Connection");
        }
    }

    private void readChunk() throws IOException {
        int numParts;
        ByteBuffer cb = this.getCommBuffer();
        this.clearParts();
        cb.clear();
        int totalBytesRead = 0;
        do {
            int bytesRead = 0;
            bytesRead = this.inputStream.read(cb.array(), totalBytesRead, 5 - totalBytesRead);
            if (bytesRead == -1) {
                throw new EOFException("Chunk read error (connection reset)");
            }
            totalBytesRead += bytesRead;
            if (this.messageStats == null) continue;
            this.messageStats.incReceivedBytes(bytesRead);
        } while (totalBytesRead < 5);
        cb.rewind();
        this.chunkLength = cb.getInt();
        byte lastChunk = cb.get();
        this.setLastChunk((lastChunk & 1) == 1);
        if ((lastChunk & 2) == 2) {
            this.securePart = new Part();
            if (logger.isDebugEnabled()) {
                logger.debug("ChunkedMessage.readChunk() securePart present");
            }
        }
        cb.clear();
        if ((lastChunk & 1) == 1 && (numParts = lastChunk >> 5) > 0) {
            this.numberOfParts = numParts;
        }
        this.readPayloadFields(this.numberOfParts, this.chunkLength);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendHeader() throws IOException {
        if (this.socket != null) {
            ByteBuffer byteBuffer = this.getCommBuffer();
            synchronized (byteBuffer) {
                this.getDSCODEsForWrite();
                this.flushBuffer();
            }
        } else {
            throw new IOException("Dead Connection");
        }
        this.currentPart = 0;
        this.headerSent = true;
    }

    public boolean headerHasBeenSent() {
        return this.headerSent;
    }

    public void sendChunk() throws IOException {
        if (this.isLastChunk()) {
            this.headerSent = false;
        }
        this.sendBytes(true);
    }

    public void sendChunk(ServerConnection servConn) throws IOException {
        if (this.serverConnection != servConn) {
            throw new IllegalStateException("this.sc was not correctly set");
        }
        this.sendChunk();
    }

    @Override
    protected Part getSecurityPart() {
        if (this.isLastChunk()) {
            return super.getSecurityPart();
        }
        return null;
    }

    @Override
    protected int checkAndSetSecurityPart() {
        return this.securePart != null ? 1 : 0;
    }

    @Override
    protected void packHeaderInfoForSending(int msgLen, boolean isSecurityHeader) {
        ByteBuffer cb = this.getCommBuffer();
        cb.putInt(msgLen);
        byte isLastChunk = 0;
        if (this.isLastChunk()) {
            isLastChunk = this.lastChunk;
            if (isSecurityHeader) {
                isLastChunk = (byte)(isLastChunk | 2);
            }
        }
        cb.put(isLastChunk);
    }

    protected void getDSCODEsForWrite() {
        ByteBuffer cb = this.getCommBuffer();
        cb.clear();
        cb.putInt(this.messageType);
        cb.putInt(this.numberOfParts);
        cb.putInt(this.transactionId);
    }
}

