/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.partitioned;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.geode.DataSerializer;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.ReplyMessage;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.NanoTimer;
import org.apache.geode.internal.cache.ForceReattemptException;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.partitioned.InternalPartitionDetails;
import org.apache.geode.internal.cache.partitioned.LoadProbe;
import org.apache.geode.internal.cache.partitioned.OfflineMemberDetails;
import org.apache.geode.internal.cache.partitioned.OfflineMemberDetailsImpl;
import org.apache.geode.internal.cache.partitioned.PRLoad;
import org.apache.geode.internal.cache.partitioned.PartitionMemberInfoImpl;
import org.apache.geode.internal.cache.partitioned.PartitionMessage;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class FetchPartitionDetailsMessage
extends PartitionMessage {
    private static final Logger logger = LogService.getLogger();
    private volatile boolean internal;
    private LoadProbe loadProbe;
    private boolean fetchOfflineMembers;

    public FetchPartitionDetailsMessage() {
    }

    private FetchPartitionDetailsMessage(Set<InternalDistributedMember> recipients, int regionId, ReplyProcessor21 processor, boolean internal, boolean fetchOfflineMembers, LoadProbe probe) {
        super(recipients, regionId, processor);
        this.internal = internal;
        this.fetchOfflineMembers = fetchOfflineMembers;
        this.loadProbe = probe;
    }

    public static FetchPartitionDetailsResponse send(Set<InternalDistributedMember> recipients, PartitionedRegion region, boolean internal, boolean fetchOfflineMembers, LoadProbe probe) {
        Assert.assertTrue(recipients != null && !recipients.isEmpty(), "FetchPartitionDetailsMessage NULL recipient");
        FetchPartitionDetailsResponse response = new FetchPartitionDetailsResponse(region.getSystem(), recipients, region);
        FetchPartitionDetailsMessage msg = new FetchPartitionDetailsMessage(recipients, region.getPRId(), response, internal, fetchOfflineMembers, probe);
        msg.setTransactionDistributed(region.getCache().getTxManager().isDistributed());
        region.getDistributionManager().putOutgoing(msg);
        region.getPrStats().incPartitionMessagesSent();
        return response;
    }

    public FetchPartitionDetailsMessage(DataInput in) throws IOException, ClassNotFoundException {
        this.fromData(in, InternalDataSerializer.createDeserializationContext(in));
    }

    @Override
    public boolean isSevereAlertCompatible() {
        return true;
    }

    @Override
    protected boolean operateOnPartitionedRegion(ClusterDistributionManager dm, PartitionedRegion region, long startTime) throws ForceReattemptException {
        PartitionMemberInfoImpl details = (PartitionMemberInfoImpl)region.getRedundancyProvider().buildPartitionMemberDetails(this.internal, this.loadProbe);
        OfflineMemberDetailsImpl offlineDetails = this.internal && this.fetchOfflineMembers ? region.getRedundancyProvider().fetchOfflineMembers() : new OfflineMemberDetailsImpl(new Set[0]);
        region.getPrStats().endPartitionMessagesProcessing(startTime);
        FetchPartitionDetailsReplyMessage.send(this.getSender(), this.getProcessorId(), details, dm, offlineDetails, null);
        return false;
    }

    @Override
    protected void appendFields(StringBuilder buff) {
        super.appendFields(buff);
        buff.append("; internal=").append(this.internal);
    }

    public int getDSFID() {
        return 128;
    }

    @Override
    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        super.fromData(in, context);
        this.internal = in.readBoolean();
        this.fetchOfflineMembers = in.readBoolean();
        this.loadProbe = (LoadProbe)DataSerializer.readObject(in);
    }

    @Override
    public void toData(DataOutput out, SerializationContext context) throws IOException {
        super.toData(out, context);
        out.writeBoolean(this.internal);
        out.writeBoolean(this.fetchOfflineMembers);
        DataSerializer.writeObject(this.loadProbe, out);
    }

    public static class FetchPartitionDetailsResponse
    extends PartitionMessage.PartitionResponse {
        private final Set<InternalPartitionDetails> allDetails = new HashSet<InternalPartitionDetails>();
        private OfflineMemberDetails offlineDetails;
        final PartitionedRegion partitionedRegion;

        public FetchPartitionDetailsResponse(InternalDistributedSystem ds, Set<InternalDistributedMember> recipients, PartitionedRegion theRegion) {
            super(ds, recipients);
            this.partitionedRegion = theRegion;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void process(DistributionMessage msg) {
            block9: {
                try {
                    if (!(msg instanceof FetchPartitionDetailsReplyMessage)) break block9;
                    FetchPartitionDetailsReplyMessage reply = (FetchPartitionDetailsReplyMessage)msg;
                    InternalPartitionDetails details = reply.unmarshalPartitionMemberDetails();
                    if (details != null) {
                        Set<InternalPartitionDetails> set = this.allDetails;
                        synchronized (set) {
                            this.allDetails.add(details);
                            this.offlineDetails = reply.offlineDetails;
                        }
                        if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                            logger.trace(LogMarker.DM_VERBOSE, "FetchPartitionDetailsResponse return details is {}", (Object)details);
                        }
                        break block9;
                    }
                    if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                        logger.trace(LogMarker.DM_VERBOSE, "FetchPartitionDetailsResponse ignoring null details");
                    }
                }
                finally {
                    super.process(msg);
                }
            }
        }

        @Override
        protected void processException(ReplyException ex) {
            logger.debug("FetchPartitionDetailsResponse ignoring exception {}", (Object)ex.getMessage(), (Object)ex);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Set<InternalPartitionDetails> waitForResponse() {
            this.waitForRepliesUninterruptibly();
            Set<InternalPartitionDetails> set = this.allDetails;
            synchronized (set) {
                return this.allDetails;
            }
        }

        public OfflineMemberDetails getOfflineMembers() {
            return this.offlineDetails;
        }
    }

    public static class FetchPartitionDetailsReplyMessage
    extends ReplyMessage {
        static final byte NO_PARTITION = 0;
        static final byte OK = 1;
        static final byte OK_INTERNAL = 2;
        private long configuredMaxMemory;
        private long size;
        private int bucketCount;
        private int primaryCount;
        private PRLoad prLoad;
        private long[] bucketSizes;
        private OfflineMemberDetails offlineDetails;

        public FetchPartitionDetailsReplyMessage() {
        }

        public FetchPartitionDetailsReplyMessage(DataInput in) throws IOException, ClassNotFoundException {
            this.fromData(in, InternalDataSerializer.createDeserializationContext(in));
        }

        private FetchPartitionDetailsReplyMessage(int processorId, PartitionMemberInfoImpl details, OfflineMemberDetails offlineDetails, ReplyException re) {
            this.processorId = processorId;
            this.configuredMaxMemory = details.getConfiguredMaxMemory();
            this.size = details.getSize();
            this.bucketCount = details.getBucketCount();
            this.primaryCount = details.getPrimaryCount();
            this.prLoad = details.getPRLoad();
            this.bucketSizes = details.getBucketSizes();
            this.offlineDetails = offlineDetails;
            this.setException(re);
        }

        public static void send(InternalDistributedMember recipient, int processorId, PartitionMemberInfoImpl details, DistributionManager dm, OfflineMemberDetails offlineDetails, ReplyException re) {
            Assert.assertTrue(recipient != null, "FetchPartitionDetailsReplyMessage NULL recipient");
            FetchPartitionDetailsReplyMessage m = new FetchPartitionDetailsReplyMessage(processorId, details, offlineDetails, re);
            m.setRecipient(recipient);
            dm.putOutgoing(m);
        }

        @Override
        public void process(DistributionManager dm, ReplyProcessor21 processor) {
            long startTime = this.getTimestamp();
            if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                logger.trace(LogMarker.DM_VERBOSE, "FetchPartitionDetailsReplyMessage process invoking reply processor with processorId: {}", (Object)this.processorId);
            }
            if (processor == null) {
                if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                    logger.trace(LogMarker.DM_VERBOSE, "FetchPartitionDetailsReplyMessage processor not found");
                }
                return;
            }
            processor.process(this);
            if (logger.isTraceEnabled(LogMarker.DM_VERBOSE)) {
                logger.trace(LogMarker.DM_VERBOSE, "{} processed {}", (Object)processor, (Object)this);
            }
            dm.getStats().incReplyMessageTime(NanoTimer.getTime() - startTime);
        }

        InternalPartitionDetails unmarshalPartitionMemberDetails() {
            if (this.configuredMaxMemory == 0L) {
                return null;
            }
            if (this.prLoad == null) {
                return new PartitionMemberInfoImpl(this.getSender(), this.configuredMaxMemory, this.size, this.bucketCount, this.primaryCount);
            }
            return new PartitionMemberInfoImpl(this.getSender(), this.configuredMaxMemory, this.size, this.bucketCount, this.primaryCount, this.prLoad, this.bucketSizes);
        }

        @Override
        public void toData(DataOutput out, SerializationContext context) throws IOException {
            super.toData(out, context);
            if (this.configuredMaxMemory == 0L) {
                out.writeByte(0);
            } else {
                if (this.prLoad == null) {
                    out.writeByte(1);
                } else {
                    out.writeByte(2);
                }
                out.writeLong(this.configuredMaxMemory);
                out.writeLong(this.size);
                out.writeInt(this.bucketCount);
                out.writeInt(this.primaryCount);
                if (this.prLoad != null) {
                    InternalDataSerializer.invokeToData(this.prLoad, out);
                    DataSerializer.writeLongArray(this.bucketSizes, out);
                    InternalDataSerializer.invokeToData(this.offlineDetails, out);
                }
            }
        }

        @Override
        public int getDSFID() {
            return 129;
        }

        @Override
        public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
            super.fromData(in, context);
            byte flag = in.readByte();
            if (flag != 0) {
                this.configuredMaxMemory = in.readLong();
                this.size = in.readLong();
                this.bucketCount = in.readInt();
                this.primaryCount = in.readInt();
                if (flag == 2) {
                    this.prLoad = PRLoad.createFromDataInput(in);
                    this.bucketSizes = DataSerializer.readLongArray(in);
                    this.offlineDetails = new OfflineMemberDetailsImpl();
                    InternalDataSerializer.invokeFromData(this.offlineDetails, in);
                }
            }
        }

        @Override
        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("FetchPartitionDetailsReplyMessage ").append("processorid=").append(this.processorId).append(" reply to sender ").append(this.getSender()).append(" returning configuredMaxMemory=").append(this.configuredMaxMemory).append(" size=").append(this.size).append(" bucketCount=").append(this.bucketCount).append(" primaryCount=").append(this.primaryCount).append(" prLoad=").append(this.prLoad).append(" bucketSizes=").append(Arrays.toString(this.bucketSizes));
            return sb.toString();
        }
    }
}

