/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.map;

import org.apache.geode.InternalGemFireError;
import org.apache.geode.annotations.internal.MutableForTesting;
import org.apache.geode.cache.CacheWriterException;
import org.apache.geode.cache.EntryNotFoundException;
import org.apache.geode.cache.TimeoutException;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.HARegion;
import org.apache.geode.internal.cache.InternalRegion;
import org.apache.geode.internal.cache.RegionClearedException;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.cache.Token;
import org.apache.geode.internal.cache.map.CacheModificationLock;
import org.apache.geode.internal.cache.map.FocusedRegionMap;
import org.apache.geode.internal.cache.versions.ConcurrentCacheModificationException;
import org.apache.geode.internal.cache.versions.VersionStamp;
import org.apache.geode.internal.cache.versions.VersionTag;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.geode.internal.sequencelog.EntryLogger;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class RegionMapDestroy {
    private static final Logger logger = LogService.getLogger();
    @MutableForTesting
    static Runnable testHookRunnableForConcurrentOperation;
    private final InternalRegion internalRegion;
    private final FocusedRegionMap focusedRegionMap;
    private final CacheModificationLock cacheModificationLock;
    private EntryEventImpl event;
    private boolean inTokenMode;
    private boolean duringRI;
    private boolean cacheWrite;
    private boolean isEviction;
    private Object expectedOldValue;
    private boolean removeRecoveredEntry;
    private boolean retry = true;
    private boolean opCompleted = false;
    private boolean doPart3 = false;
    private boolean retainForConcurrency = false;
    private boolean abortDestroyAndReturnFalse;
    private RegionEntry oldRegionEntry;
    private RegionEntry newRegionEntry;
    private RegionEntry regionEntry;
    private RegionEntry tombstone;
    private boolean haveTombstone;
    private boolean doContinue;

    public RegionMapDestroy(InternalRegion internalRegion, FocusedRegionMap focusedRegionMap, CacheModificationLock cacheModificationLock) {
        this.internalRegion = internalRegion;
        this.focusedRegionMap = focusedRegionMap;
        this.cacheModificationLock = cacheModificationLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean destroy(EntryEventImpl eventArg, boolean inTokenModeArg, boolean duringRIArg, boolean cacheWriteArg, boolean isEvictionArg, Object expectedOldValueArg, boolean removeRecoveredEntryArg) throws CacheWriterException, EntryNotFoundException, TimeoutException {
        if (this.internalRegion == null) {
            throw new InternalGemFireError("The internalRegion for RegionMap " + this + " is null for event " + this.event);
        }
        this.event = eventArg;
        this.inTokenMode = inTokenModeArg;
        this.duringRI = duringRIArg;
        this.cacheWrite = cacheWriteArg;
        this.isEviction = isEvictionArg;
        this.expectedOldValue = expectedOldValueArg;
        this.removeRecoveredEntry = removeRecoveredEntryArg;
        if (this.event.isFromRILocalDestroy()) {
            this.removeRecoveredEntry = true;
        }
        this.cacheModificationLock.lockForCacheModification(this.internalRegion, this.event);
        boolean locked = this.internalRegion.lockWhenRegionIsInitializing();
        try {
            while (this.retry) {
                block32: {
                    block31: {
                        this.retry = false;
                        this.opCompleted = false;
                        this.tombstone = null;
                        this.haveTombstone = false;
                        this.doContinue = false;
                        this.abortDestroyAndReturnFalse = false;
                        this.regionEntry = this.focusedRegionMap.getEntry(this.event);
                        this.invokeTestHookForConcurrentOperation();
                        if (logger.isTraceEnabled(LogMarker.LRU_TOMBSTONE_COUNT_VERBOSE) && !(this.internalRegion instanceof HARegion)) {
                            logger.trace(LogMarker.LRU_TOMBSTONE_COUNT_VERBOSE, "ARM.destroy() inTokenMode={}; duringRI={}; riLocalDestroy={}; withRepl={}; fromServer={}; concurrencyEnabled={}; isOriginRemote={}; isEviction={}; operation={}; re={}", (Object)this.inTokenMode, (Object)this.duringRI, (Object)this.event.isFromRILocalDestroy(), (Object)this.internalRegion.getDataPolicy().withReplication(), (Object)this.event.isFromServer(), (Object)this.internalRegion.getConcurrencyChecksEnabled(), (Object)this.event.isOriginRemote(), (Object)this.isEviction, (Object)this.event.getOperation(), (Object)this.regionEntry);
                        }
                        if (this.regionEntry != null && this.regionEntry.isTombstone() && !this.removeRecoveredEntry) {
                            this.tombstone = this.regionEntry;
                            this.haveTombstone = true;
                            this.regionEntry = null;
                        }
                        if (this.regionEntry == null) {
                            this.checkTombstoneAndConcurrency();
                            if (this.inTokenMode || this.retainForConcurrency) {
                                this.handleMissingRegionEntry();
                            }
                        } else {
                            this.handleExistingRegionEntry();
                        }
                        if (!this.abortDestroyAndReturnFalse) break block31;
                        boolean bl = false;
                        try {
                            this.triggerDistributionAndListenerNotification();
                            return bl;
                        }
                        finally {
                            this.cancelExpiryTaskIfRegionEntryExisted();
                        }
                    }
                    if (!this.doContinue) break block32;
                    try {
                        this.triggerDistributionAndListenerNotification();
                        continue;
                    }
                    finally {
                        this.cancelExpiryTaskIfRegionEntryExisted();
                        continue;
                    }
                }
                if (this.opCompleted) {
                    EntryLogger.logDestroy(this.event);
                }
                boolean bl = this.opCompleted;
                try {
                    this.triggerDistributionAndListenerNotification();
                    return bl;
                }
                finally {
                    this.cancelExpiryTaskIfRegionEntryExisted();
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            this.triggerDistributionAndListenerNotification();
                            throw throwable;
                        }
                        finally {
                            this.cancelExpiryTaskIfRegionEntryExisted();
                        }
                    }
                    catch (Throwable throwable2) {
                        throw throwable2;
                        return false;
                    }
                }
            }
        }
        finally {
            if (locked) {
                this.internalRegion.unlockWhenRegionIsInitializing();
            }
            this.cacheModificationLock.releaseCacheModificationLock(this.internalRegion, this.event);
        }
    }

    private void checkTombstoneAndConcurrency() {
        if (this.regionEntry == null) {
            boolean bl = this.retainForConcurrency = !(this.haveTombstone || !this.internalRegion.getDataPolicy().withReplication() && !this.event.isFromServer() || !this.internalRegion.getConcurrencyChecksEnabled() || !this.event.isOriginRemote() && !this.event.isFromWANAndVersioned() && !this.event.isBridgeEvent());
            if (!this.inTokenMode && !this.retainForConcurrency) {
                this.retryRemoveWithTombstone();
            }
        }
    }

    /*
     * Exception decompiling
     */
    private void handleExistingRegionEntry() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 23[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void cancelExpiryTaskIfRegionEntryExisted() {
        if (this.opCompleted && this.regionEntry != null) {
            this.internalRegion.cancelExpiryTask(this.regionEntry);
        }
    }

    private void triggerDistributionAndListenerNotification() {
        if (this.event.isConcurrencyConflict() && this.event.getVersionTag() != null && this.event.getVersionTag().isGatewayTag()) {
            this.doPart3 = false;
        }
        if (this.doPart3) {
            this.internalRegion.basicDestroyPart3(this.regionEntry, this.event, this.inTokenMode, this.duringRI, true, this.expectedOldValue);
        }
    }

    private void updateVersionTagOnEntryWithTombstone() {
        if (this.regionEntry.isTombstone() && this.event.getVersionTag() != null) {
            this.focusedRegionMap.processVersionTag(this.regionEntry, this.event);
            try {
                this.regionEntry.makeTombstone(this.internalRegion, this.event.getVersionTag());
            }
            catch (RegionClearedException regionClearedException) {
                // empty catch block
            }
        }
    }

    private void confirmEvictionDestroy() {
        if (this.isEviction) {
            assert (this.expectedOldValue == null);
            if (!this.focusedRegionMap.confirmEvictionDestroy(this.regionEntry)) {
                this.opCompleted = false;
                this.abortDestroyAndReturnFalse = true;
            }
        }
    }

    private void abortLocalExpirationIfEntryIsInUseByTransaction() {
        if (!this.event.isOriginRemote() && this.event.getOperation().isExpiration() && this.regionEntry.isInUseByTransaction()) {
            this.opCompleted = false;
            this.abortDestroyAndReturnFalse = true;
        }
    }

    private void retryIfIsRemovedPhase2() {
        if (this.regionEntry.isRemovedPhase2()) {
            this.focusedRegionMap.getEntryMap().remove(this.event.getKey(), this.regionEntry);
            this.internalRegion.getCachePerfStats().incRetries();
            this.retry = true;
            this.doContinue = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void retryRemoveWithTombstone() {
        if (!this.isEviction || this.internalRegion.getConcurrencyChecksEnabled()) {
            RegionEntry regionEntry = this.newRegionEntry = this.haveTombstone ? this.tombstone : this.focusedRegionMap.getEntryFactory().createEntry(this.internalRegion, this.event.getKey(), Token.REMOVED_PHASE1);
            synchronized (regionEntry) {
                if (this.haveTombstone && !this.tombstone.isTombstone()) {
                    this.retry = true;
                    this.doContinue = true;
                    return;
                }
                this.regionEntry = this.focusedRegionMap.putEntryIfAbsent(this.event.getKey(), this.newRegionEntry);
                if (this.regionEntry != null && this.regionEntry != this.tombstone) {
                    this.retry = true;
                    this.doContinue = true;
                    return;
                }
                if (!this.isEviction) {
                    try {
                        this.handleEntryNotFound();
                    }
                    finally {
                        this.removeEntryOrLeaveTombstone();
                    }
                }
            }
        }
    }

    private void invokeTestHookForConcurrentOperation() {
        if (null != testHookRunnableForConcurrentOperation) {
            testHookRunnableForConcurrentOperation.run();
        }
    }

    private void destroyExistingEntry() {
        boolean removed = false;
        try {
            this.opCompleted = this.destroyEntry(this.regionEntry, this.event, this.inTokenMode, this.cacheWrite, this.expectedOldValue, false, this.removeRecoveredEntry);
            if (this.opCompleted) {
                this.internalRegion.basicDestroyBeforeRemoval(this.regionEntry, this.event);
                if (!this.inTokenMode && this.regionEntry.getVersionStamp() == null) {
                    this.regionEntry.removePhase2();
                    this.focusedRegionMap.removeEntry(this.event.getKey(), this.regionEntry, true, this.event, this.internalRegion);
                    removed = true;
                }
                if (this.inTokenMode && !this.duringRI) {
                    this.event.inhibitCacheListenerNotification(true);
                }
                this.doPart3 = true;
                this.internalRegion.basicDestroyPart2(this.regionEntry, this.event, this.inTokenMode, false, this.duringRI, true);
                this.focusedRegionMap.lruEntryDestroy(this.regionEntry);
            } else if (!this.inTokenMode) {
                EntryLogger.logDestroy(this.event);
                this.internalRegion.recordEvent(this.event);
                if (this.regionEntry.getVersionStamp() == null) {
                    this.regionEntry.removePhase2();
                    this.focusedRegionMap.removeEntry(this.event.getKey(), this.regionEntry, true, this.event, this.internalRegion);
                    this.focusedRegionMap.lruEntryDestroy(this.regionEntry);
                } else if (this.regionEntry.isTombstone() && this.event.isOriginRemote()) {
                    this.internalRegion.rescheduleTombstone(this.regionEntry, this.regionEntry.getVersionStamp().asVersionTag());
                }
                this.focusedRegionMap.lruEntryDestroy(this.regionEntry);
                this.opCompleted = true;
            }
        }
        catch (RegionClearedException rce) {
            this.opCompleted = true;
            this.internalRegion.recordEvent(this.event);
            if (this.inTokenMode && !this.duringRI) {
                this.event.inhibitCacheListenerNotification(true);
            }
            this.internalRegion.basicDestroyPart2(this.regionEntry, this.event, this.inTokenMode, true, this.duringRI, true);
            this.doPart3 = true;
        }
        finally {
            this.internalRegion.checkReadiness();
            if (this.regionEntry.isRemoved() && !this.regionEntry.isTombstone() && !removed) {
                this.focusedRegionMap.removeEntry(this.event.getKey(), this.regionEntry, true, this.event, this.internalRegion);
            }
        }
    }

    private void removeEntryOrLeaveTombstone() {
        block15: {
            try {
                if (!this.event.isOriginRemote() && this.event.getVersionTag() != null && this.internalRegion.getConcurrencyChecksEnabled()) {
                    this.focusedRegionMap.processVersionTag(this.newRegionEntry, this.event);
                    if (this.doPart3) {
                        this.internalRegion.generateAndSetVersionTag(this.event, this.newRegionEntry);
                    }
                    try {
                        this.internalRegion.recordEvent(this.event);
                        this.newRegionEntry.makeTombstone(this.internalRegion, this.event.getVersionTag());
                    }
                    catch (RegionClearedException regionClearedException) {
                        // empty catch block
                    }
                    this.opCompleted = true;
                    break block15;
                }
                if (!this.haveTombstone) {
                    try {
                        assert (this.newRegionEntry != this.tombstone);
                        this.newRegionEntry.setValue(this.internalRegion, Token.REMOVED_PHASE2);
                        this.focusedRegionMap.removeEntry(this.event.getKey(), this.newRegionEntry, false);
                    }
                    catch (RegionClearedException regionClearedException) {}
                    break block15;
                }
                if (this.event.getVersionTag() != null) {
                    this.focusedRegionMap.processVersionTag(this.tombstone, this.event);
                    if (this.doPart3) {
                        this.internalRegion.generateAndSetVersionTag(this.event, this.newRegionEntry);
                    }
                    try {
                        this.tombstone.setValue(this.internalRegion, Token.TOMBSTONE);
                    }
                    catch (RegionClearedException regionClearedException) {
                        // empty catch block
                    }
                    this.internalRegion.recordEvent(this.event);
                    this.internalRegion.rescheduleTombstone(this.tombstone, this.event.getVersionTag());
                    this.internalRegion.basicDestroyPart2(this.tombstone, this.event, this.inTokenMode, true, this.duringRI, true);
                    this.opCompleted = true;
                    break block15;
                }
                Assert.assertTrue(this.event.getVersionTag() == null);
                Assert.assertTrue(this.newRegionEntry == this.tombstone);
                this.event.setVersionTag(this.getVersionTagFromStamp(this.tombstone.getVersionStamp()));
            }
            catch (ConcurrentCacheModificationException e) {
                VersionTag tag = this.event.getVersionTag();
                if (tag != null && tag.isTimeStampUpdated()) {
                    this.internalRegion.notifyTimestampsToGateways(this.event);
                }
                throw e;
            }
        }
    }

    private void handleEntryNotFound() {
        boolean throwException = false;
        EntryNotFoundException entryNotFoundException = null;
        if (!this.cacheWrite) {
            throwException = true;
        } else {
            try {
                if (!this.removeRecoveredEntry) {
                    throwException = !this.internalRegion.bridgeWriteBeforeDestroy(this.event, this.expectedOldValue);
                }
            }
            catch (EntryNotFoundException e) {
                throwException = true;
                entryNotFoundException = e;
            }
        }
        if (throwException && !this.event.isOriginRemote() && !this.event.getOperation().isLocal() && (this.event.isFromBridgeAndVersioned() || this.event.isFromWANAndVersioned())) {
            if (logger.isDebugEnabled()) {
                logger.debug("ARM.destroy is allowing wan/client destroy of {} to continue", this.event.getKey());
            }
            throwException = false;
            this.event.setIsRedestroyedEntry(true);
            if (this.regionEntry == null) {
                this.regionEntry = this.newRegionEntry;
            }
            this.doPart3 = true;
        }
        if (throwException) {
            if (entryNotFoundException == null) {
                this.internalRegion.checkEntryNotFound(this.event.getKey());
            } else {
                throw entryNotFoundException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleMissingRegionEntry() {
        this.newRegionEntry = this.focusedRegionMap.getEntryFactory().createEntry(this.internalRegion, this.event.getKey(), Token.REMOVED_PHASE1);
        oqlIndexManager = this.internalRegion.getIndexManager();
        if (oqlIndexManager != null) {
            oqlIndexManager.waitForIndexInit();
        }
        var2_2 = this.newRegionEntry;
        synchronized (var2_2) {
            this.oldRegionEntry = this.focusedRegionMap.putEntryIfAbsent(this.event.getKey(), this.newRegionEntry);
            this.removeRegionEntryUntilCompleted();
            if (this.abortDestroyAndReturnFalse) {
                // MONITOREXIT @DISABLED, blocks:[0, 17, 9] lbl11 : MonitorExitStatement: MONITOREXIT : var2_2
                if (oqlIndexManager == null) return;
                oqlIndexManager.countDownIndexUpdaters();
                return;
            }
            if (this.opCompleted != false) return;
        }
        {
            block21: {
                this.regionEntry = this.newRegionEntry;
                this.event.setRegionEntry(this.newRegionEntry);
                try {
                    if (!this.isEviction) ** break block20
                    this.opCompleted = false;
                    this.abortDestroyAndReturnFalse = true;
                    if (this.opCompleted || this.haveTombstone) break block21;
                }
                catch (RegionClearedException rce) {
                    this.handleRegionClearedExceptionDuringDestroyEntryInternal(this.newRegionEntry);
                    break block22;
                }
                catch (ConcurrentCacheModificationException ccme) {
                    tag = this.event.getVersionTag();
                    if (tag == null) throw ccme;
                    if (tag.isTimeStampUpdated() == false) throw ccme;
                    this.internalRegion.notifyTimestampsToGateways(this.event);
                    throw ccme;
                }
                this.focusedRegionMap.removeEntry(this.event.getKey(), this.newRegionEntry, false);
            }
            if (!this.opCompleted && this.isEviction) {
                this.focusedRegionMap.removeEntry(this.event.getKey(), this.newRegionEntry, false);
            }
        }
        if (oqlIndexManager == null) return;
        oqlIndexManager.countDownIndexUpdaters();
        return;
        {
            block22: {
                ** try [egrp 5[TRYBLOCK] [13 : 227->452)] { 
lbl-1000:
                // 1 sources

                {
                    this.destroyEntryInternal(this.newRegionEntry, this.oldRegionEntry);
                }
            }
            return;
lbl52:
            // 1 sources

            finally {
                if (oqlIndexManager != null) {
                    oqlIndexManager.countDownIndexUpdaters();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeRegionEntryUntilCompleted() {
        while (!this.opCompleted && this.oldRegionEntry != null) {
            RegionEntry regionEntry = this.oldRegionEntry;
            synchronized (regionEntry) {
                if (this.oldRegionEntry.isRemovedPhase2()) {
                    this.internalRegion.getCachePerfStats().incRetries();
                    this.focusedRegionMap.getEntryMap().remove(this.event.getKey(), this.oldRegionEntry);
                    this.oldRegionEntry = this.focusedRegionMap.putEntryIfAbsent(this.event.getKey(), this.newRegionEntry);
                } else {
                    this.event.setRegionEntry(this.oldRegionEntry);
                    if (this.isEviction && !this.focusedRegionMap.confirmEvictionDestroy(this.oldRegionEntry)) {
                        this.opCompleted = false;
                        this.abortDestroyAndReturnFalse = true;
                        return;
                    }
                    try {
                        boolean destroyed = this.destroyEntry(this.oldRegionEntry, this.event, this.inTokenMode, this.cacheWrite, this.expectedOldValue, false, this.removeRecoveredEntry);
                        if (destroyed) {
                            if (this.retainForConcurrency) {
                                this.internalRegion.basicDestroyBeforeRemoval(this.oldRegionEntry, this.event);
                            }
                            this.internalRegion.basicDestroyPart2(this.oldRegionEntry, this.event, this.inTokenMode, false, this.duringRI, true);
                            this.focusedRegionMap.lruEntryDestroy(this.oldRegionEntry);
                            this.doPart3 = true;
                        }
                    }
                    catch (RegionClearedException rce) {
                        this.internalRegion.basicDestroyPart2(this.oldRegionEntry, this.event, this.inTokenMode, true, this.duringRI, true);
                        this.doPart3 = true;
                    }
                    catch (ConcurrentCacheModificationException ccme) {
                        VersionTag tag = this.event.getVersionTag();
                        if (tag != null && tag.isTimeStampUpdated()) {
                            this.internalRegion.notifyTimestampsToGateways(this.event);
                        }
                        throw ccme;
                    }
                    this.regionEntry = this.oldRegionEntry;
                    this.opCompleted = true;
                }
            }
        }
    }

    private void handleRegionClearedExceptionDuringDestroyEntryInternal(RegionEntry newRegionEntry) {
        this.opCompleted = true;
        EntryLogger.logDestroy(this.event);
        this.internalRegion.basicDestroyPart2(newRegionEntry, this.event, this.inTokenMode, true, this.duringRI, true);
        this.doPart3 = true;
    }

    private void destroyEntryInternal(RegionEntry newRegionEntry, RegionEntry oldRegionEntry) throws RegionClearedException {
        this.opCompleted = this.destroyEntry(newRegionEntry, this.event, this.inTokenMode, this.cacheWrite, this.expectedOldValue, true, this.removeRecoveredEntry);
        if (this.opCompleted) {
            this.event.setIsRedestroyedEntry(true);
            if (this.retainForConcurrency) {
                this.internalRegion.basicDestroyBeforeRemoval(oldRegionEntry, this.event);
            }
            this.internalRegion.basicDestroyPart2(newRegionEntry, this.event, this.inTokenMode, false, this.duringRI, true);
            this.doPart3 = true;
        }
    }

    private boolean destroyEntry(RegionEntry re, EntryEventImpl event, boolean inTokenMode, boolean cacheWrite, Object expectedOldValue, boolean forceDestroy, boolean removeRecoveredEntry) throws CacheWriterException, TimeoutException, EntryNotFoundException, RegionClearedException {
        this.focusedRegionMap.processVersionTag(re, event);
        int oldSize = this.internalRegion.calculateRegionEntryValueSize(re);
        boolean wasRemoved = re.isDestroyedOrRemoved();
        boolean retVal = re.destroy(event.getRegion(), event, inTokenMode, cacheWrite, expectedOldValue, forceDestroy, removeRecoveredEntry);
        if (retVal) {
            EntryLogger.logDestroy(event);
            if (!wasRemoved) {
                this.internalRegion.updateSizeOnRemove(event.getKey(), oldSize);
            }
        }
        return retVal;
    }

    private VersionTag getVersionTagFromStamp(VersionStamp stamp) {
        VersionTag tag = VersionTag.create(stamp.getMemberID());
        tag.setEntryVersion(stamp.getEntryVersion());
        tag.setRegionVersion(stamp.getRegionVersion());
        tag.setVersionTimeStamp(stamp.getVersionTimeStamp());
        tag.setDistributedSystemId(stamp.getDistributedSystemId());
        return tag;
    }
}

