/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import java.util.Collection;
import java.util.Set;
import org.apache.geode.cache.EntryNotFoundException;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.UnsupportedOperationInTransactionException;
import org.apache.geode.internal.cache.DataLocationException;
import org.apache.geode.internal.cache.DistributedPutAllOperation;
import org.apache.geode.internal.cache.DistributedRegion;
import org.apache.geode.internal.cache.DistributedRemoveAllOperation;
import org.apache.geode.internal.cache.EntryEventImpl;
import org.apache.geode.internal.cache.InternalDataView;
import org.apache.geode.internal.cache.InternalRegion;
import org.apache.geode.internal.cache.KeyInfo;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.NonTXEntry;
import org.apache.geode.internal.cache.RegionEntry;
import org.apache.geode.internal.cache.entries.AbstractRegionEntry;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.cache.tier.sockets.VersionedObjectList;
import org.apache.geode.internal.cache.versions.ConcurrentCacheModificationException;

public class LocalRegionDataView
implements InternalDataView {
    @Override
    public Object getDeserializedValue(KeyInfo keyInfo, LocalRegion localRegion, boolean updateStats, boolean disableCopyOnRead, boolean preferCD, EntryEventImpl clientEvent, boolean returnTombstones, boolean retainResult, boolean createIfAbsent) {
        return localRegion.getDeserializedValue(null, keyInfo, updateStats, disableCopyOnRead, preferCD, clientEvent, returnTombstones, retainResult);
    }

    @Override
    public void destroyExistingEntry(EntryEventImpl event, boolean cacheWrite, Object expectedOldValue) {
        InternalRegion ir = event.getRegion();
        ir.mapDestroy(event, cacheWrite, false, expectedOldValue);
    }

    @Override
    public void invalidateExistingEntry(EntryEventImpl event, boolean invokeCallbacks, boolean forceNewEntry) {
        try {
            event.getRegion().getRegionMap().invalidate(event, invokeCallbacks, forceNewEntry, false);
        }
        catch (ConcurrentCacheModificationException concurrentCacheModificationException) {
            // empty catch block
        }
    }

    @Override
    public void updateEntryVersion(EntryEventImpl event) throws EntryNotFoundException {
        try {
            event.getRegion().getRegionMap().updateEntryVersion(event);
        }
        catch (ConcurrentCacheModificationException concurrentCacheModificationException) {
            // empty catch block
        }
    }

    @Override
    public int entryCount(LocalRegion localRegion) {
        return localRegion.getRegionSize();
    }

    @Override
    public Object getValueInVM(KeyInfo keyInfo, LocalRegion localRegion, boolean rememberRead) {
        return localRegion.nonTXbasicGetValueInVM(keyInfo);
    }

    @Override
    public boolean containsKey(KeyInfo keyInfo, LocalRegion localRegion) {
        return localRegion.nonTXContainsKey(keyInfo);
    }

    @Override
    public boolean containsValueForKey(KeyInfo keyInfo, LocalRegion localRegion) {
        return localRegion.nonTXContainsValueForKey(keyInfo);
    }

    @Override
    public Region.Entry getEntry(KeyInfo keyInfo, LocalRegion localRegion, boolean allowTombstones) {
        return localRegion.nonTXGetEntry(keyInfo, false, allowTombstones);
    }

    @Override
    public Region.Entry accessEntry(KeyInfo keyInfo, LocalRegion localRegion) {
        return localRegion.nonTXGetEntry(keyInfo, true, false);
    }

    @Override
    public boolean putEntry(EntryEventImpl event, boolean ifNew, boolean ifOld, Object expectedOldValue, boolean requireOldValue, long lastModified, boolean overwriteDestroyed) {
        return event.getRegion().virtualPut(event, ifNew, ifOld, expectedOldValue, requireOldValue, lastModified, overwriteDestroyed);
    }

    @Override
    public boolean putEntry(EntryEventImpl event, boolean ifNew, boolean ifOld, Object expectedOldValue, boolean requireOldValue, long lastModified, boolean overwriteDestroyed, boolean invokeCallbacks, boolean throwsConcurrentModification) {
        return event.getRegion().virtualPut(event, ifNew, ifOld, expectedOldValue, requireOldValue, lastModified, overwriteDestroyed, invokeCallbacks, throwsConcurrentModification);
    }

    @Override
    public boolean isDeferredStats() {
        return false;
    }

    @Override
    public Object findObject(KeyInfo keyInfo, LocalRegion r, boolean isCreate, boolean generateCallbacks, Object value, boolean disableCopyOnRead, boolean preferCD, ClientProxyMembershipID requestingClient, EntryEventImpl clientEvent, boolean returnTombstones) {
        return r.nonTxnFindObject(keyInfo, isCreate, generateCallbacks, value, disableCopyOnRead, preferCD, requestingClient, clientEvent, returnTombstones);
    }

    @Override
    public Region.Entry<?, ?> getEntryForIterator(KeyInfo keyInfo, LocalRegion currRgn, boolean rememberReads, boolean allowTombstones) {
        AbstractRegionEntry re = (AbstractRegionEntry)keyInfo.getKey();
        if (re != null && !re.isDestroyedOrRemoved() || allowTombstones && re.isTombstone()) {
            return new NonTXEntry(currRgn, re);
        }
        return null;
    }

    @Override
    public Object getKeyForIterator(KeyInfo keyInfo, LocalRegion currRgn, boolean rememberReads, boolean allowTombstones) {
        Object key = keyInfo.getKey();
        if (key == null) {
            return null;
        }
        if (key instanceof RegionEntry) {
            RegionEntry re = (RegionEntry)key;
            if (!re.isDestroyedOrRemoved() || allowTombstones && re.isTombstone()) {
                return re.getKey();
            }
        } else if (this.getEntry(keyInfo, currRgn, allowTombstones) != null) {
            return key;
        }
        return null;
    }

    @Override
    public Set getAdditionalKeysForIterator(LocalRegion currRgn) {
        return null;
    }

    @Override
    public Object getSerializedValue(LocalRegion localRegion, KeyInfo key, boolean doNotLockEntry, ClientProxyMembershipID requestingClient, EntryEventImpl clientEvent, boolean returnTombstones) throws DataLocationException {
        throw new IllegalStateException();
    }

    @Override
    public boolean putEntryOnRemote(EntryEventImpl event, boolean ifNew, boolean ifOld, Object expectedOldValue, boolean requireOldValue, long lastModified, boolean overwriteDestroyed) throws DataLocationException {
        throw new IllegalStateException();
    }

    @Override
    public void destroyOnRemote(EntryEventImpl event, boolean cacheWrite, Object expectedOldValue) throws DataLocationException {
        this.destroyExistingEntry(event, cacheWrite, expectedOldValue);
    }

    @Override
    public void invalidateOnRemote(EntryEventImpl event, boolean invokeCallbacks, boolean forceNewEntry) throws DataLocationException {
        this.invalidateExistingEntry(event, invokeCallbacks, forceNewEntry);
    }

    @Override
    public Set getBucketKeys(LocalRegion localRegion, int bucketId, boolean allowTombstones) {
        throw new IllegalStateException();
    }

    @Override
    public Region.Entry getEntryOnRemote(KeyInfo key, LocalRegion localRegion, boolean allowTombstones) throws DataLocationException {
        throw new IllegalStateException();
    }

    @Override
    public void checkSupportsRegionDestroy() throws UnsupportedOperationInTransactionException {
    }

    @Override
    public void checkSupportsRegionInvalidate() throws UnsupportedOperationInTransactionException {
    }

    @Override
    public void checkSupportsRegionClear() throws UnsupportedOperationInTransactionException {
    }

    @Override
    public Collection<?> getRegionKeysForIteration(LocalRegion currRegion) {
        return currRegion.getRegionMap().regionEntries();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void postPutAll(DistributedPutAllOperation putallOp, VersionedObjectList successfulPuts, InternalRegion reg) {
        if (!reg.getDataPolicy().withStorage() && reg.getConcurrencyChecksEnabled() && putallOp.getBaseEvent().isBridgeEvent()) {
            successfulPuts.clear();
            putallOp.fillVersionedObjectList(successfulPuts);
        }
        long token = -1L;
        try {
            token = reg.postPutAllSend(putallOp, successfulPuts);
            reg.postPutAllFireEvents(putallOp, successfulPuts);
        }
        finally {
            if (token != -1L && reg instanceof DistributedRegion) {
                putallOp.endOperation(token);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void postRemoveAll(DistributedRemoveAllOperation op, VersionedObjectList successfulOps, InternalRegion reg) {
        if (!reg.getDataPolicy().withStorage() && reg.getConcurrencyChecksEnabled() && op.getBaseEvent().isBridgeEvent()) {
            successfulOps.clear();
            op.fillVersionedObjectList(successfulOps);
        }
        long token = -1L;
        try {
            token = reg.postRemoveAllSend(op, successfulOps);
            reg.postRemoveAllFireEvents(op, successfulOps);
        }
        finally {
            if (token != -1L && reg instanceof DistributedRegion) {
                op.endOperation(token);
            }
        }
    }
}

