/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.admin.internal;

import java.io.InputStream;
import org.apache.geode.internal.ClassPathLoader;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXParseException;

abstract class ManagedEntityConfigXml
implements EntityResolver,
ErrorHandler {
    protected static final String DTD_LOCATION = "/org/apache/geode/admin/doc-files/ds5_0.dtd";
    protected static final String SYSTEM_ID = "http://www.gemstone.com/dtd/ds5_0.dtd";
    protected static final String PUBLIC_ID = "-//GemStone Systems, Inc.//GemFire Distributed System 5.0//EN";
    public static final String DISTRIBUTED_SYSTEM = "distributed-system";
    public static final String ID = "id";
    public static final String DISABLE_TCP = "disable-tcp";
    public static final String REMOTE_COMMAND = "remote-command";
    public static final String LOCATORS = "locators";
    public static final String SSL = "ssl";
    public static final String CACHE_SERVER = "cache-server";
    public static final String MULTICAST = "multicast";
    public static final String LOCATOR = "locator";
    public static final String PORT = "port";
    public static final String ADDRESS = "address";
    public static final String HOST = "host";
    public static final String WORKING_DIRECTORY = "working-directory";
    public static final String PRODUCT_DIRECTORY = "product-directory";
    public static final String PROTOCOLS = "protocols";
    public static final String CIPHERS = "ciphers";
    public static final String PROPERTY = "property";
    public static final String AUTHENTICATION_REQUIRED = "authentication-required";
    public static final String KEY = "key";
    public static final String VALUE = "value";
    public static final String CLASSPATH = "classpath";

    ManagedEntityConfigXml() {
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        if (publicId == null || systemId == null) {
            throw new SAXException(String.format("Public Id: %s System Id: %s", publicId, systemId));
        }
        String location = DTD_LOCATION;
        InputStream stream = ClassPathLoader.getLatest().getResourceAsStream(this.getClass(), location);
        if (stream == null) {
            throw new SAXNotRecognizedException(String.format("DTD not found: %s", location));
        }
        InputSource result = new InputSource(stream);
        return result;
    }

    @Override
    public void warning(SAXParseException ex) throws SAXException {
    }

    @Override
    public void error(SAXParseException ex) throws SAXException {
        IllegalArgumentException ex2 = new IllegalArgumentException("Error while parsing XML.");
        ex2.initCause(ex);
        throw ex2;
    }

    @Override
    public void fatalError(SAXParseException ex) throws SAXException {
        IllegalArgumentException ex2 = new IllegalArgumentException("Fatal error while parsing XML.");
        ex2.initCause(ex);
        throw ex2;
    }
}

