/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.operation;

import java.util.Date;
import java.util.Objects;
import org.apache.geode.lang.Identifiable;
import org.apache.geode.management.api.ClusterManagementOperation;
import org.apache.geode.management.runtime.OperationResult;

public class OperationState<A extends ClusterManagementOperation<V>, V extends OperationResult>
implements Identifiable<String> {
    private static final long serialVersionUID = 8212319653561969588L;
    private final String opId;
    private final A operation;
    private final Date operationStart;
    private Date operationEnd;
    private V result;
    private Throwable throwable;
    private String locator;

    public String getLocator() {
        return this.locator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLocator(String locator) {
        OperationState operationState = this;
        synchronized (operationState) {
            this.locator = locator;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationState that = (OperationState)o;
        return Objects.equals(this.getId(), that.getId()) && Objects.equals(this.getOperation(), that.getOperation()) && Objects.equals(this.getOperationStart(), that.getOperationStart()) && Objects.equals(this.getOperationEnd(), that.getOperationEnd()) && Objects.equals(this.getResult(), that.getResult()) && Objects.equals(this.getThrowable(), that.getThrowable()) && Objects.equals(this.getLocator(), that.getLocator());
    }

    public int hashCode() {
        return Objects.hash(this.opId);
    }

    public OperationState(String opId, A operation, Date operationStart) {
        this.opId = opId;
        this.operation = operation;
        this.operationStart = operationStart;
    }

    public String getId() {
        return this.opId;
    }

    public A getOperation() {
        return this.operation;
    }

    public Date getOperationStart() {
        return this.operationStart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOperationEnd(Date operationEnd, V result, Throwable exception) {
        OperationState operationState = this;
        synchronized (operationState) {
            this.result = result;
            this.throwable = exception;
            this.operationEnd = operationEnd;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OperationState<A, V> createCopy() {
        OperationState<A, V> result = new OperationState<A, V>(this.opId, this.operation, this.operationStart);
        OperationState operationState = this;
        synchronized (operationState) {
            result.operationEnd = this.operationEnd;
            result.result = this.result;
            result.throwable = this.throwable;
            result.locator = this.locator;
        }
        return result;
    }

    public Date getOperationEnd() {
        return this.operationEnd;
    }

    public V getResult() {
        return this.result;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }
}

