/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.beans;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.query.CqClosedException;
import org.apache.geode.cache.query.CqException;
import org.apache.geode.cache.query.Index;
import org.apache.geode.cache.query.QueryService;
import org.apache.geode.cache.query.internal.cq.CqService;
import org.apache.geode.cache.query.internal.cq.InternalCqQuery;
import org.apache.geode.cache.query.internal.cq.ServerCQ;
import org.apache.geode.cache.server.CacheServer;
import org.apache.geode.cache.server.ServerLoad;
import org.apache.geode.cache.server.ServerLoadProbe;
import org.apache.geode.cache.server.internal.ServerMetricsImpl;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.admin.ClientHealthMonitoringRegion;
import org.apache.geode.internal.admin.remote.ClientHealthStats;
import org.apache.geode.internal.cache.CacheServerImpl;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.ha.HARegionQueue;
import org.apache.geode.internal.cache.tier.Acceptor;
import org.apache.geode.internal.cache.tier.InternalClientMembership;
import org.apache.geode.internal.cache.tier.sockets.AcceptorImpl;
import org.apache.geode.internal.cache.tier.sockets.CacheClientNotifier;
import org.apache.geode.internal.cache.tier.sockets.CacheClientProxy;
import org.apache.geode.internal.cache.tier.sockets.ClientProxyMembershipID;
import org.apache.geode.internal.cache.tier.sockets.ServerConnection;
import org.apache.geode.internal.process.PidUnavailableException;
import org.apache.geode.internal.process.ProcessUtils;
import org.apache.geode.internal.serialization.KnownVersion;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.management.ClientHealthStatus;
import org.apache.geode.management.ClientQueueDetail;
import org.apache.geode.management.ServerLoadData;
import org.apache.geode.management.internal.ManagementConstants;
import org.apache.geode.management.internal.beans.MemberMBeanBridge;
import org.apache.geode.management.internal.beans.ServerBridge;
import org.apache.geode.management.internal.beans.stats.MBeanStatsMonitor;
import org.apache.geode.management.internal.beans.stats.StatType;
import org.apache.geode.management.internal.beans.stats.StatsAverageLatency;
import org.apache.geode.management.internal.beans.stats.StatsRate;
import org.apache.geode.management.membership.ClientMembershipListener;
import org.apache.logging.log4j.Logger;

public class CacheServerBridge
extends ServerBridge {
    private static final Logger logger = LogService.getLogger();
    private CacheServer cacheServer;
    private InternalCache cache;
    private QueryService qs;
    private StatsRate clientNotificationRate;
    private StatsAverageLatency clientNotificatioAvgLatency;
    protected StatsRate queryRequestRate;
    private MemberMBeanBridge memberMBeanBridge;
    private ClientMembershipListener membershipListener;
    public static final ThreadLocal<KnownVersion> clientVersion = new ThreadLocal();

    protected static int identifyPid() {
        try {
            return ProcessUtils.identifyPid();
        }
        catch (PidUnavailableException e) {
            if (logger.isDebugEnabled()) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            return 0;
        }
    }

    public CacheServerBridge(InternalCache cache, CacheServer cacheServer) {
        super(cacheServer);
        this.cacheServer = cacheServer;
        this.cache = cache;
        this.qs = cache.getQueryService();
        this.initializeCacheServerStats();
    }

    public CacheServerBridge(InternalCache cache, CacheServer cacheServer, AcceptorImpl acceptor, MBeanStatsMonitor monitor) {
        super(acceptor, monitor);
        this.cacheServer = cacheServer;
        this.cache = cache;
        this.qs = cache.getQueryService();
        this.initializeCacheServerStats();
    }

    public CacheServerBridge() {
        this.initializeCacheServerStats();
    }

    public void setMemberMBeanBridge(MemberMBeanBridge memberMBeanBridge) {
        this.memberMBeanBridge = memberMBeanBridge;
    }

    @Override
    public void stopMonitor() {
        super.stopMonitor();
        this.monitor.stopListener();
    }

    private void initializeCacheServerStats() {
        this.clientNotificationRate = new StatsRate("clientNotificationRequests", StatType.INT_TYPE, this.monitor);
        this.clientNotificatioAvgLatency = new StatsAverageLatency("clientNotificationRequests", StatType.INT_TYPE, "processClientNotificationTime", this.monitor);
        this.queryRequestRate = new StatsRate("queryRequests", StatType.INT_TYPE, this.monitor);
    }

    public int getSocketBufferSize() {
        return this.cacheServer.getSocketBufferSize();
    }

    public boolean getTcpNoDelay() {
        return this.cacheServer.getTcpNoDelay();
    }

    public int getPort() {
        return this.cacheServer.getPort();
    }

    public int getCapacity() {
        if (this.cacheServer.getClientSubscriptionConfig() != null) {
            return this.cacheServer.getClientSubscriptionConfig().getCapacity();
        }
        return 0;
    }

    public String getDiskStoreName() {
        if (this.cacheServer.getClientSubscriptionConfig() != null) {
            return this.cacheServer.getClientSubscriptionConfig().getDiskStoreName();
        }
        return null;
    }

    public int getMaxConnections() {
        return this.cacheServer.getMaxConnections();
    }

    public long getLoadPollInterval() {
        return this.cacheServer.getLoadPollInterval();
    }

    public ServerLoadData fetchLoadProbe() {
        ServerLoadProbe probe = this.cacheServer.getLoadProbe();
        ServerLoad load = probe.getLoad(new ServerMetricsImpl(this.cacheServer.getMaxConnections()));
        ServerLoadData data = new ServerLoadData(load.getConnectionLoad(), load.getSubscriptionConnectionLoad(), load.getLoadPerConnection(), load.getLoadPerSubscriptionConnection());
        return data;
    }

    public int getMaxThreads() {
        return this.cacheServer.getMaxThreads();
    }

    public int getMaximumMessageCount() {
        return this.cacheServer.getMaximumMessageCount();
    }

    public int getMaximumTimeBetweenPings() {
        return this.cacheServer.getMaximumTimeBetweenPings();
    }

    public int getMessageTimeToLive() {
        return this.cacheServer.getMessageTimeToLive();
    }

    public boolean isRunning() {
        return this.cacheServer.isRunning();
    }

    public String getEvictionPolicy() {
        if (this.cacheServer.getClientSubscriptionConfig() != null) {
            return this.cacheServer.getClientSubscriptionConfig().getEvictionPolicy();
        }
        return null;
    }

    public String getHostnameForClients() {
        return this.cacheServer.getHostnameForClients();
    }

    public String getBindAddress() {
        return this.cacheServer.getBindAddress();
    }

    public String[] getContinuousQueryList() {
        Collection<? extends InternalCqQuery> allCqs;
        CqService cqService = this.cache.getCqService();
        if (cqService != null && (allCqs = cqService.getAllCqs()) != null && allCqs.size() > 0) {
            String[] allCqStr = new String[allCqs.size()];
            int i = 0;
            for (InternalCqQuery internalCqQuery : allCqs) {
                allCqStr[i] = internalCqQuery.getName();
                ++i;
            }
            return allCqStr;
        }
        return ManagementConstants.NO_DATA_STRING;
    }

    public long getRegisteredCQCount() {
        CqService cqService = this.cache.getCqService();
        if (cqService != null) {
            Collection<? extends InternalCqQuery> allCqs = cqService.getAllCqs();
            return allCqs != null && allCqs.size() > 0 ? (long)allCqs.size() : 0L;
        }
        return 0L;
    }

    public String[] getIndexList() {
        Collection<Index> idxs = this.qs.getIndexes();
        if (!idxs.isEmpty()) {
            Iterator<Index> idx = idxs.iterator();
            String[] indexList = new String[idxs.size()];
            int i = 0;
            while (idx.hasNext()) {
                Index index = idx.next();
                indexList[i] = index.getName();
                ++i;
            }
            return indexList;
        }
        return ManagementConstants.NO_DATA_STRING;
    }

    public String[] listClientIds() throws Exception {
        String[] allConnectedClientStr = null;
        Map<String, ClientConnInfo> uniqueIds = this.getUniqueClientIds();
        if (uniqueIds.size() > 0) {
            allConnectedClientStr = new String[uniqueIds.size()];
            int j = 0;
            Iterator<String> iterator = uniqueIds.keySet().iterator();
            while (iterator.hasNext()) {
                String clientId;
                allConnectedClientStr[j] = clientId = iterator.next();
                ++j;
            }
            return allConnectedClientStr;
        }
        return new String[0];
    }

    private Map<String, ClientConnInfo> getUniqueClientIds() {
        HashMap<String, ClientConnInfo> uniqueIds = null;
        ServerConnection[] serverConnections = this.acceptor.getAllServerConnectionList();
        Collection<CacheClientProxy> clientProxies = this.acceptor.getCacheClientNotifier().getClientProxies();
        if (clientProxies.size() > 0) {
            uniqueIds = new HashMap<String, ClientConnInfo>();
            for (CacheClientProxy p : clientProxies) {
                ClientConnInfo clientConInfo = new ClientConnInfo(p.getProxyID(), p.getSocketHost(), p.getRemotePort(), p.isPrimary());
                uniqueIds.put(p.getProxyID().getDSMembership(), clientConInfo);
            }
        }
        if (serverConnections != null && serverConnections.length > 0) {
            if (uniqueIds == null) {
                uniqueIds = new HashMap();
            }
            for (ServerConnection conn : serverConnections) {
                ClientProxyMembershipID clientId = conn.getProxyID();
                if (clientId == null || uniqueIds.get(clientId.getDSMembership()) != null) continue;
                ClientConnInfo clientConInfo = new ClientConnInfo(conn.getProxyID(), conn.getSocketHost(), conn.getSocketPort(), false);
                uniqueIds.put(clientId.getDSMembership(), clientConInfo);
            }
        }
        if (uniqueIds == null) {
            return Collections.emptyMap();
        }
        return uniqueIds;
    }

    public KnownVersion getClientVersion(ClientConnInfo connInfo) {
        if (this.cache.getCacheServers().size() == 0) {
            return null;
        }
        CacheServerImpl server = (CacheServerImpl)this.cache.getCacheServers().iterator().next();
        if (server == null) {
            return null;
        }
        Acceptor acceptor = server.getAcceptor();
        if (acceptor == null) {
            return null;
        }
        ServerConnection[] serverConnections = acceptor.getAllServerConnectionList();
        boolean flag = false;
        if (connInfo.toString().contains("primary=true")) {
            flag = true;
        }
        for (ServerConnection conn : serverConnections) {
            ClientProxyMembershipID cliIdFrmProxy = conn.getProxyID();
            ClientConnInfo cci = new ClientConnInfo(conn.getProxyID(), conn.getSocketHost(), conn.getSocketPort(), flag);
            if (!connInfo.toString().equals(cci.toString())) continue;
            return cliIdFrmProxy.getClientVersion();
        }
        ClientProxyMembershipID proxyId = connInfo.getClientId();
        CacheClientProxy proxy = CacheClientNotifier.getInstance().getClientProxy(proxyId);
        if (proxy != null) {
            return proxy.getVersion();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientHealthStatus showClientStats(String clientId) throws Exception {
        try {
            ClientHealthStatus status;
            Map<String, ClientConnInfo> uniqueClientIds = this.getUniqueClientIds();
            ClientConnInfo clientConnInfo = uniqueClientIds.get(clientId);
            ClientHealthStatus clientHealthStatus = status = this.getClientHealthStatus(clientConnInfo);
            return clientHealthStatus;
        }
        finally {
            clientVersion.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientHealthStatus[] showAllClientStats() throws Exception {
        try {
            ArrayList<ClientHealthStatus> clientHealthStatusList = null;
            Map<String, ClientConnInfo> uniqueClientIds = this.getUniqueClientIds();
            if (!uniqueClientIds.isEmpty()) {
                clientHealthStatusList = new ArrayList<ClientHealthStatus>();
                for (Map.Entry<String, ClientConnInfo> p : uniqueClientIds.entrySet()) {
                    ClientHealthStatus status = this.getClientHealthStatus(p.getValue());
                    if (status == null) continue;
                    clientHealthStatusList.add(status);
                }
                ClientHealthStatus[] statusArr = new ClientHealthStatus[clientHealthStatusList.size()];
                ClientHealthStatus[] clientHealthStatusArray = clientHealthStatusList.toArray(statusArr);
                return clientHealthStatusArray;
            }
            ClientHealthStatus[] clientHealthStatusArray = new ClientHealthStatus[]{};
            return clientHealthStatusArray;
        }
        finally {
            clientVersion.set(null);
        }
    }

    private ClientHealthStatus getClientHealthStatus(ClientConnInfo connInfo) {
        ClientProxyMembershipID proxyId = connInfo.getClientId();
        CacheClientProxy proxy = CacheClientNotifier.getInstance().getClientProxy(proxyId);
        if (proxy != null && !proxy.isConnected() && !proxyId.isDurable()) {
            return null;
        }
        clientVersion.set(this.getClientVersion(connInfo));
        int clientCQCount = 0;
        CqService cqService = this.cache.getCqService();
        if (cqService != null) {
            List<ServerCQ> cqs = cqService.getAllClientCqs(proxyId);
            clientCQCount = cqs.size();
        }
        ClientHealthStatus status = new ClientHealthStatus();
        Region clientHealthMonitoringRegion = ClientHealthMonitoringRegion.getInstance(this.cache);
        String clientName = proxyId.getDSMembership();
        DistributedMember clientMemberId = proxyId.getDistributedMember();
        status.setClientId(connInfo.toString());
        status.setName(clientName);
        status.setHostName(connInfo.getHostName());
        status.setClientCQCount(clientCQCount);
        if (proxy != null) {
            status.setUpTime(proxy.getUpTime());
            status.setQueueSize(proxy.getQueueSizeStat());
            status.setConnected(proxy.isConnected());
            status.setSubscriptionEnabled(true);
        } else {
            status.setConnected(true);
            status.setSubscriptionEnabled(false);
        }
        ClientHealthStats stats = (ClientHealthStats)clientHealthMonitoringRegion.get(clientMemberId);
        if (stats == null) {
            stats = (ClientHealthStats)clientHealthMonitoringRegion.get(clientName);
        }
        if (stats != null) {
            status.setCpus(stats.getCpus());
            status.setNumOfCacheListenerCalls(stats.getNumOfCacheListenerCalls());
            status.setNumOfGets((int)stats.getNumOfGets());
            status.setNumOfMisses((int)stats.getNumOfMisses());
            status.setNumOfPuts((int)stats.getNumOfPuts());
            status.setNumOfThreads(stats.getNumOfThreads());
            status.setProcessCpuTime(stats.getProcessCpuTime());
            status.setPoolStats(stats.getPoolStats());
        }
        return status;
    }

    public void closeContinuousQuery(String queryName) throws Exception {
        CqService cqService = this.cache.getCqService();
        if (cqService != null) {
            Collection<? extends InternalCqQuery> allCqs = cqService.getAllCqs();
            for (InternalCqQuery internalCqQuery : allCqs) {
                if (!internalCqQuery.getName().equals(queryName)) continue;
                try {
                    internalCqQuery.close();
                    return;
                }
                catch (CqClosedException e) {
                    throw new Exception(e.getMessage());
                }
                catch (CqException e) {
                    throw new Exception(e.getMessage());
                }
            }
        }
    }

    public void executeContinuousQuery(String queryName) throws Exception {
        CqService cqService = this.cache.getCqService();
        if (cqService != null) {
            Collection<? extends InternalCqQuery> allCqs = cqService.getAllCqs();
            for (InternalCqQuery internalCqQuery : allCqs) {
                if (!internalCqQuery.getName().equals(queryName)) continue;
                try {
                    cqService.resumeCQ(1, (ServerCQ)internalCqQuery);
                    return;
                }
                catch (CqClosedException e) {
                    throw new Exception(e.getMessage());
                }
            }
        }
    }

    public void stopContinuousQuery(String queryName) throws Exception {
        CqService cqService = this.cache.getCqService();
        if (cqService != null) {
            Collection<? extends InternalCqQuery> allCqs = cqService.getAllCqs();
            for (InternalCqQuery internalCqQuery : allCqs) {
                if (!internalCqQuery.getName().equals(queryName)) continue;
                try {
                    internalCqQuery.stop();
                    return;
                }
                catch (CqClosedException e) {
                    throw new Exception(e.getMessage());
                }
                catch (CqException e) {
                    throw new Exception(e.getMessage());
                }
            }
        }
    }

    public void removeIndex(String indexName) throws Exception {
        try {
            Iterator<Index> idx;
            Collection<Index> idxs = this.qs.getIndexes();
            if (!idxs.isEmpty() && (idx = idxs.iterator()).hasNext()) {
                Index index = idx.next();
                if (index.getName().equals(indexName)) {
                    this.qs.removeIndex(index);
                }
                return;
            }
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
    }

    public int getIndexCount() {
        return this.qs.getIndexes().size();
    }

    public int getNumClientNotificationRequests() {
        return this.getStatistic("clientNotificationRequests").intValue();
    }

    public long getClientNotificationAvgLatency() {
        return this.clientNotificatioAvgLatency.getAverageLatency();
    }

    public float getClientNotificationRate() {
        return this.clientNotificationRate.getRate();
    }

    public float getQueryRequestRate() {
        return this.queryRequestRate.getRate();
    }

    public long getTotalIndexMaintenanceTime() {
        return this.memberMBeanBridge.getTotalIndexMaintenanceTime();
    }

    public long getActiveCQCount() {
        CqService cqService = this.cache.getCqService();
        if (cqService != null && cqService.isRunning()) {
            return cqService.getCqStatistics().numCqsActive();
        }
        return 0L;
    }

    public int getNumSubscriptions() {
        Map clientProxyMembershipIDMap = InternalClientMembership.getClientQueueSizes(this.cache);
        return clientProxyMembershipIDMap.keySet().size();
    }

    public void setClientMembershipListener(ClientMembershipListener membershipListener) {
        this.membershipListener = membershipListener;
    }

    public ClientMembershipListener getClientMembershipListener() {
        return this.membershipListener;
    }

    public ClientQueueDetail[] getClientQueueDetails() throws Exception {
        ArrayList<ClientQueueDetail> clientQueueDetailList = null;
        try {
            if (this.acceptor != null && this.acceptor.getCacheClientNotifier() != null) {
                Collection<CacheClientProxy> clientProxies = this.acceptor.getCacheClientNotifier().getClientProxies();
                if (clientProxies.size() <= 0) {
                    return new ClientQueueDetail[0];
                }
                clientQueueDetailList = new ArrayList<ClientQueueDetail>();
                for (CacheClientProxy p : clientProxies) {
                    ClientQueueDetail status = this.getClientQueueDetail(p);
                    if (status == null) continue;
                    clientQueueDetailList.add(status);
                }
                ClientQueueDetail[] queueDetailArr = new ClientQueueDetail[clientQueueDetailList.size()];
                return clientQueueDetailList.toArray(queueDetailArr);
            }
            return new ClientQueueDetail[0];
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
    }

    private ClientQueueDetail getClientQueueDetail(CacheClientProxy p) {
        ClientQueueDetail queueDetail = new ClientQueueDetail();
        ClientProxyMembershipID proxyID = p.getProxyID();
        if (!p.isConnected() && !proxyID.isDurable()) {
            return null;
        }
        queueDetail.setClientId(CacheServerBridge.getClientIdFromCacheClientProxy(p));
        HARegionQueue queue = p.getHARegionQueue();
        if (queue == null) {
            return queueDetail;
        }
        queueDetail.setQueueSize(p.getQueueSizeStat());
        queueDetail.setEventsConflated(queue.getStatistics().getEventsConflated());
        queueDetail.setEventsEnqued(queue.getStatistics().getEventsEnqued());
        queueDetail.setEventsExpired(queue.getStatistics().getEventsExpired());
        queueDetail.setEventsRemoved(queue.getStatistics().getEventsRemoved());
        queueDetail.setEventsRemovedByQrm(queue.getStatistics().getEventsRemovedByQrm());
        queueDetail.setEventsTaken(queue.getStatistics().getEventsTaken());
        queueDetail.setMarkerEventsConflated(queue.getStatistics().getMarkerEventsConflated());
        queueDetail.setNumVoidRemovals(queue.getStatistics().getNumVoidRemovals());
        return queueDetail;
    }

    public ClientQueueDetail getClientQueueDetail(String clientId) throws Exception {
        try {
            if (this.acceptor != null && this.acceptor.getCacheClientNotifier() != null) {
                Collection<CacheClientProxy> clientProxies = this.acceptor.getCacheClientNotifier().getClientProxies();
                for (CacheClientProxy p : clientProxies) {
                    String buffer = CacheServerBridge.getClientIdFromCacheClientProxy(p);
                    if (!buffer.equals(clientId)) continue;
                    ClientQueueDetail queueDetail = this.getClientQueueDetail(p);
                    return queueDetail;
                }
            }
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
        return null;
    }

    private static String getClientIdFromCacheClientProxy(CacheClientProxy p) {
        if (p == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("[").append(p.getProxyID()).append(":port=").append(p.getRemotePort()).append(":primary=").append(p.isPrimary()).append("]");
        return buffer.toString();
    }

    private static class ClientConnInfo {
        private ClientProxyMembershipID clientId;
        private String hostName;
        private int port;
        boolean isPrimary;

        public ClientConnInfo(ClientProxyMembershipID clientId, String hostName, int port, boolean isPrimary) {
            this.clientId = clientId;
            this.hostName = hostName;
            this.port = port;
            this.isPrimary = isPrimary;
        }

        public String getHostName() {
            return this.hostName;
        }

        public ClientProxyMembershipID getClientId() {
            return this.clientId;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("[").append(this.clientId).append("; port=").append(this.port).append("; primary=").append(this.isPrimary).append("]");
            return buffer.toString();
        }
    }
}

