/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.api;

import java.net.InetSocketAddress;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.cache.GemFireCache;
import org.apache.geode.cache.client.ClientCache;
import org.apache.geode.cache.execute.FunctionException;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.internal.DistributionConfig;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.distributed.internal.tcpserver.HostAndPort;
import org.apache.geode.distributed.internal.tcpserver.TcpClient;
import org.apache.geode.distributed.internal.tcpserver.TcpSocketCreator;
import org.apache.geode.distributed.internal.tcpserver.TcpSocketFactory;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.net.SSLConfig;
import org.apache.geode.internal.net.SSLConfigurationFactory;
import org.apache.geode.internal.net.SSLUtil;
import org.apache.geode.internal.net.SocketCreatorFactory;
import org.apache.geode.internal.security.SecurableCommunicationChannel;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.management.api.ConnectionConfig;
import org.apache.geode.management.internal.configuration.messages.ClusterManagementServiceInfo;
import org.apache.geode.management.internal.configuration.messages.ClusterManagementServiceInfoRequest;
import org.apache.geode.management.internal.functions.GetMemberInformationFunction;
import org.apache.geode.management.runtime.MemberInformation;
import org.apache.logging.log4j.Logger;

@Experimental
public class GeodeConnectionConfig
extends ConnectionConfig {
    private static final Logger logger = LogService.getLogger();
    @Immutable
    private static final GetMemberInformationFunction MEMBER_INFORMATION_FUNCTION = new GetMemberInformationFunction();

    public GeodeConnectionConfig(GemFireCache cache) {
        GemFireCacheImpl cacheImpl = (GemFireCacheImpl)cache;
        if (cacheImpl.isServer()) {
            this.setServerCache(cacheImpl);
        } else if (cacheImpl.isClient()) {
            this.setClientCache(cacheImpl);
        } else {
            throw new IllegalArgumentException("Need a cache instance in order to build the service.");
        }
    }

    private void setServerCache(GemFireCacheImpl cache) {
        Set<InternalDistributedMember> locatorsWithClusterConfig = cache.getDistributionManager().getAllHostedLocatorsWithSharedConfiguration().keySet();
        ClusterManagementServiceInfo cmsInfo = this.getClusterManagementServiceInfo(locatorsWithClusterConfig);
        this.configureBuilder(cache.getSystem().getConfig(), cmsInfo);
    }

    private void setClientCache(ClientCache clientCache) {
        List<InetSocketAddress> locators = clientCache.getDefaultPool().getLocators();
        if (locators.size() == 0) {
            throw new IllegalStateException("the client needs to have a client pool connected with a locator.");
        }
        DistributionConfig config = ((GemFireCacheImpl)clientCache).getSystem().getConfig();
        SocketCreatorFactory.setDistributionConfig(config);
        TcpClient client = new TcpClient((TcpSocketCreator)SocketCreatorFactory.getSocketCreatorForComponent(SecurableCommunicationChannel.LOCATOR), InternalDataSerializer.getDSFIDSerializer().getObjectSerializer(), InternalDataSerializer.getDSFIDSerializer().getObjectDeserializer(), TcpSocketFactory.DEFAULT);
        ClusterManagementServiceInfo cmsInfo = null;
        for (InetSocketAddress locator : locators) {
            try {
                cmsInfo = (ClusterManagementServiceInfo)client.requestToServer(new HostAndPort(locator.getHostString(), locator.getPort()), (Object)new ClusterManagementServiceInfoRequest(), 1000, true);
                if (!cmsInfo.isRunning()) continue;
                break;
            }
            catch (Exception e) {
                logger.warn("unable to discover the ClusterManagementService on locator " + locator.toString());
            }
        }
        if (cmsInfo == null || !cmsInfo.isRunning()) {
            throw new IllegalStateException("Unable to discover a locator that has ClusterManagementService running.");
        }
        this.configureBuilder(config, cmsInfo);
    }

    private void configureBuilder(DistributionConfig config, ClusterManagementServiceInfo cmsInfo) {
        this.setHost(cmsInfo.getHostName());
        this.setPort(cmsInfo.getHttpPort());
        if (cmsInfo.isSecured() && this.getUsername() == null) {
            Properties securityProps = config.getSecurityProps();
            String username = securityProps.getProperty("security-username");
            String password = securityProps.getProperty("security-password");
            if (StringUtils.isBlank((CharSequence)username)) {
                String message = "You will need to set the buildWithHostAddress username and password or specify security-username and security-password in the properties when starting this geode server/client.";
                throw new IllegalStateException(message);
            }
            this.setUsername(username);
            this.setPassword(password);
        }
        if (cmsInfo.isSSL()) {
            SSLConfig sslConfig = SSLConfigurationFactory.getSSLConfigForComponent(config, SecurableCommunicationChannel.WEB);
            if (!sslConfig.useDefaultSSLContext() && sslConfig.getTruststore() == null) {
                throw new IllegalStateException("This server/client needs to have ssl-truststore or ssl-use-default-context specified in order to use cluster management service.");
            }
            this.setSslContext(SSLUtil.createAndConfigureSSLContext(sslConfig, false));
        }
    }

    private ClusterManagementServiceInfo getClusterManagementServiceInfo(Set<InternalDistributedMember> locators) {
        ClusterManagementServiceInfo info = new ClusterManagementServiceInfo();
        MemberInformation memberInfo = null;
        for (InternalDistributedMember locator : locators) {
            try {
                ResultCollector resultCollector = FunctionService.onMember(locator).execute(MEMBER_INFORMATION_FUNCTION);
                List memberInformations = (List)resultCollector.getResult();
                if (memberInformations.isEmpty()) continue;
                memberInfo = (MemberInformation)memberInformations.get(0);
                break;
            }
            catch (FunctionException e) {
                logger.warn("Unable to execute GetMemberInformationFunction on " + locator.getId());
            }
        }
        if (memberInfo == null) {
            throw new IllegalStateException("Unable to determine ClusterManagementService endpoint");
        }
        info.setHostName(this.getHostName(memberInfo));
        info.setHttpPort(memberInfo.getHttpServicePort());
        info.setSSL(memberInfo.isWebSSL());
        info.setSecured(memberInfo.isSecured());
        return info;
    }

    private String getHostName(MemberInformation memberInformation) {
        String host = StringUtils.isNotBlank((CharSequence)memberInformation.getHttpServiceBindAddress()) ? memberInformation.getHttpServiceBindAddress() : (StringUtils.isNotBlank((CharSequence)memberInformation.getServerBindAddress()) ? memberInformation.getServerBindAddress() : memberInformation.getHost());
        return host;
    }
}

