/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.util;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.internal.cache.persistence.PersistentMemberID;
import org.apache.geode.internal.util.Transformer;

public class TransformUtils {
    @Immutable
    public static final Transformer<Map.Entry<PersistentMemberID, Set<Integer>>, String> persistentMemberEntryToLogEntryTransformer = new Transformer<Map.Entry<PersistentMemberID, Set<Integer>>, String>(){

        @Override
        public String transform(Map.Entry<PersistentMemberID, Set<Integer>> entry) {
            PersistentMemberID memberId = entry.getKey();
            Set<Integer> bucketIds = entry.getValue();
            StringBuilder builder = new StringBuilder();
            builder.append(persistentMemberIdToLogEntryTransformer.transform(memberId));
            if (null != bucketIds) {
                builder.append("  Buckets: ");
                builder.append(bucketIds);
            }
            builder.append("\n");
            return builder.toString();
        }
    };
    @Immutable
    public static final Transformer<PersistentMemberID, String> persistentMemberIdToLogEntryTransformer = new Transformer<PersistentMemberID, String>(){

        @Override
        public String transform(PersistentMemberID memberId) {
            StringBuilder builder = new StringBuilder();
            if (null != memberId) {
                if (null != memberId.getDiskStoreId()) {
                    builder.append("\n  DiskStore ID: ");
                    builder.append(memberId.getDiskStoreId().toUUID().toString());
                }
                if (null != memberId.getName()) {
                    builder.append("\n  Name: ");
                    builder.append(memberId.getName());
                }
                if (null != memberId.getHost() && null != memberId.getDirectory()) {
                    builder.append("\n  Location: ");
                }
                if (null != memberId.getHost()) {
                    builder.append("/");
                    builder.append(memberId.getHost().getHostAddress());
                    builder.append(":");
                }
                if (null != memberId.getDirectory()) {
                    builder.append(memberId.getDirectory());
                }
                builder.append("\n");
            }
            return builder.toString();
        }
    };

    public static Transformer<File, String> getFileNameTransformer() {
        return File::getName;
    }

    public static <T1, T2> void transform(Collection<T1> from, Collection<T2> to, Transformer<T1, T2> transformer) {
        for (T1 instance : from) {
            to.add(transformer.transform(instance));
        }
    }

    public static <T1, T2> Map<T2, T1> transformAndMap(Collection<T1> from, Transformer<T1, T2> transformer) {
        HashMap<T2, T1> map = new HashMap<T2, T1>();
        for (T1 instance : from) {
            map.put(transformer.transform(instance), instance);
        }
        return map;
    }

    @FunctionalInterface
    public static interface CollectionTransformer<T1, T2> {
        public void transform(Collection<T1> var1, Collection<T2> var2, Transformer<T1, T2> var3);
    }
}

