/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.ra.spi;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.security.auth.Subject;
import javax.transaction.xa.XAResource;
import org.apache.geode.LogWriter;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.internal.CopyOnWriteHashSet;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.TXManagerImpl;
import org.apache.geode.internal.ra.GFConnectionImpl;
import org.apache.geode.internal.ra.spi.JCALocalTransaction;
import org.apache.geode.internal.ra.spi.JCAManagedConnectionFactory;
import org.apache.geode.internal.ra.spi.JCAManagedConnectionMetaData;

public class JCAManagedConnection
implements ManagedConnection {
    private final List<ConnectionEventListener> listeners = new CopyOnWriteArrayList<ConnectionEventListener>();
    private volatile TXManagerImpl transactionManager;
    private volatile InternalCache cache;
    private volatile boolean initialized = false;
    private volatile PrintWriter logWriter;
    private final JCAManagedConnectionFactory connectionFactory;
    private final Set<GFConnectionImpl> connections = new CopyOnWriteHashSet<GFConnectionImpl>();
    private volatile JCALocalTransaction localTransaction = new JCALocalTransaction();

    JCAManagedConnection(JCAManagedConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public void addConnectionEventListener(ConnectionEventListener listener) {
        this.listeners.add(listener);
    }

    public void associateConnection(Object connection) throws ResourceException {
        if (!(connection instanceof GFConnectionImpl)) {
            throw new ResourceException("Connection is not of type GFConnection");
        }
        ((GFConnectionImpl)connection).resetManagedConnection(this);
        this.connections.add((GFConnectionImpl)connection);
    }

    public void cleanup() throws ResourceException {
        this.invalidateAndRemoveConnections();
        if (this.localTransaction == null || this.localTransaction.transactionInProgress()) {
            this.localTransaction = this.initialized && !this.isCacheClosed() ? new JCALocalTransaction(this.cache, this.transactionManager) : new JCALocalTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidateAndRemoveConnections() {
        Set<GFConnectionImpl> set = this.connections;
        synchronized (set) {
            ArrayList<GFConnectionImpl> connectionsToRemove = new ArrayList<GFConnectionImpl>();
            for (GFConnectionImpl connection : this.connections) {
                connection.invalidate();
                connectionsToRemove.add(connection);
            }
            this.connections.removeAll(connectionsToRemove);
        }
    }

    private boolean isCacheClosed() {
        if (this.cache != null) {
            return this.cache.isClosed();
        }
        return true;
    }

    public void destroy() throws ResourceException {
        this.invalidateAndRemoveConnections();
        this.transactionManager = null;
        this.cache = null;
        this.localTransaction = null;
        this.listeners.clear();
    }

    public Object getConnection(Subject arg0, ConnectionRequestInfo arg1) throws ResourceException {
        LogWriter logger;
        if (!this.initialized || this.isCacheClosed()) {
            this.init();
        }
        if ((logger = this.cache.getLogger()).fineEnabled()) {
            logger.fine("JCAManagedConnection:getConnection. Returning new Connection");
        }
        GFConnectionImpl connection = new GFConnectionImpl(this);
        this.connections.add(connection);
        return connection;
    }

    private void init() {
        this.cache = (InternalCache)CacheFactory.getAnyInstance();
        if (this.cache == null) {
            throw new RuntimeException("Cache could not be found in JCAManagedConnection");
        }
        LogWriter logger = this.cache.getLogger();
        if (logger.fineEnabled()) {
            logger.fine("JCAManagedConnection:init. Inside init");
        }
        this.transactionManager = this.cache.getTxManager();
        this.initialized = true;
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        return this.localTransaction;
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return this.logWriter;
    }

    public ManagedConnectionMetaData getMetaData() throws ResourceException {
        LogWriter logger;
        if (this.initialized && !this.isCacheClosed() && (logger = this.cache.getLogger()).fineEnabled()) {
            logger.fine("JCAManagedConnection:getMetaData");
        }
        return new JCAManagedConnectionMetaData(this.connectionFactory.getProductName(), this.connectionFactory.getVersion(), this.connectionFactory.getUserName());
    }

    public XAResource getXAResource() throws ResourceException {
        throw new NotSupportedException("XA Transaction not supported");
    }

    public void removeConnectionEventListener(ConnectionEventListener arg0) {
        this.listeners.remove(arg0);
    }

    public void setLogWriter(PrintWriter logger) throws ResourceException {
        this.logWriter = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onError(Exception e) {
        this.localTransaction = null;
        Set<GFConnectionImpl> set = this.connections;
        synchronized (set) {
            LinkedList<GFConnectionImpl> connectionsToRemove = new LinkedList<GFConnectionImpl>(this.connections);
            for (GFConnectionImpl connection : this.connections) {
                connection.invalidate();
                connectionsToRemove.add(connection);
                List<ConnectionEventListener> list = this.listeners;
                synchronized (list) {
                    ConnectionEvent event = new ConnectionEvent((ManagedConnection)this, 5, e);
                    event.setConnectionHandle((Object)connection);
                    for (ConnectionEventListener listener : this.listeners) {
                        listener.connectionErrorOccurred(event);
                    }
                }
            }
            this.connections.removeAll(connectionsToRemove);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onClose(GFConnectionImpl connection) {
        connection.invalidate();
        this.connections.remove(connection);
        List<ConnectionEventListener> list = this.listeners;
        synchronized (list) {
            ConnectionEvent event = new ConnectionEvent((ManagedConnection)this, 1);
            event.setConnectionHandle((Object)connection);
            for (ConnectionEventListener listener : this.listeners) {
                listener.connectionClosed(event);
            }
        }
        if (this.connections.isEmpty()) {
            this.localTransaction = this.initialized && !this.isCacheClosed() ? new JCALocalTransaction(this.cache, this.transactionManager) : new JCALocalTransaction();
        }
    }
}

