/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.tx;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.geode.CancelException;
import org.apache.geode.DataSerializer;
import org.apache.geode.SystemFailure;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.Operation;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.cache.TransactionException;
import org.apache.geode.distributed.DistributedSystemDisconnectedException;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.DirectReplyProcessor;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.DistributionMessage;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.MessageWithReply;
import org.apache.geode.distributed.internal.ReplyException;
import org.apache.geode.distributed.internal.ReplyMessage;
import org.apache.geode.distributed.internal.ReplyProcessor21;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.InternalRegion;
import org.apache.geode.internal.cache.LocalRegion;
import org.apache.geode.internal.cache.RemoteOperationException;
import org.apache.geode.internal.cache.TXManagerImpl;
import org.apache.geode.internal.cache.TXStateProxy;
import org.apache.geode.internal.cache.TransactionMessage;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.geode.internal.serialization.DeserializationContext;
import org.apache.geode.internal.serialization.SerializationContext;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public abstract class RemoteOperationMessage
extends DistributionMessage
implements MessageWithReply,
TransactionMessage {
    private static final Logger logger = LogService.getLogger();
    protected int processorId;
    protected int processorType;
    protected String regionPath;
    private int txUniqId = -1;
    private InternalDistributedMember txMemberId = null;
    protected transient short flags;
    protected boolean isTransactionDistributed = false;
    private static final String PN_TOKEN = ".cache.";

    public RemoteOperationMessage() {
    }

    public RemoteOperationMessage(InternalDistributedMember recipient, String regionPath, ReplyProcessor21 processor) {
        this(regionPath, processor);
        Assert.assertTrue(recipient != null, "RemoteMesssage recipient can not be null");
        this.setRecipient(recipient);
    }

    private RemoteOperationMessage(String regionPath, ReplyProcessor21 processor) {
        this.regionPath = regionPath;
        int n = this.processorId = processor == null ? 0 : processor.getProcessorId();
        if (processor != null && this.isSevereAlertCompatible()) {
            processor.enableSevereAlertProcessing();
        }
        this.txUniqId = TXManagerImpl.getCurrentTXUniqueId();
        TXStateProxy txState = TXManagerImpl.getCurrentTXState();
        if (txState != null && txState.isMemberIdForwardingRequired()) {
            this.txMemberId = txState.getOriginatingMember();
        }
        this.setIfTransactionDistributed(processor);
    }

    @Override
    public boolean isSevereAlertCompatible() {
        return true;
    }

    @Override
    public int getProcessorType() {
        return 74;
    }

    public String getRegionPath() {
        return this.regionPath;
    }

    @Override
    public int getProcessorId() {
        return this.processorId;
    }

    public boolean checkCacheClosing(InternalCache cache) {
        return cache == null || cache.isClosed();
    }

    public boolean checkDSClosing(ClusterDistributionManager dm) {
        InternalDistributedSystem ds = dm.getSystem();
        return ds == null || ds.isDisconnecting();
    }

    @Override
    public void process(ClusterDistributionManager dm) {
        InternalCache cache = this.getCache(dm);
        if (cache == null) {
            String message = this.getCacheClosedMessage(dm);
            ReplyException replyException = new ReplyException(new CacheClosedException(message));
            this.sendReply(this.getSender(), this.processorId, dm, replyException, null, 0L);
            return;
        }
        if (dm.getSystem().threadOwnsResources()) {
            this.doRemoteOperation(dm, cache);
            return;
        }
        if (this.isTransactional()) {
            dm.getExecutors().getWaitingThreadPool().execute(() -> this.doRemoteOperation(dm, cache));
        } else {
            this.doRemoteOperation(dm, cache);
        }
    }

    boolean isTransactional() {
        return this.getTXUniqId() != -1 && this.canParticipateInTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doRemoteOperation(ClusterDistributionManager dm, InternalCache cache) {
        block26: {
            Throwable thr = null;
            boolean sendReply = true;
            LocalRegion r = null;
            long startTime = 0L;
            try {
                if (this.checkCacheClosing(cache) || this.checkDSClosing(dm)) {
                    thr = cache.getCacheClosedException(this.getCacheClosedMessage(dm));
                    return;
                }
                r = this.getRegionByPath(cache);
                if (r == null && this.failIfRegionMissing()) {
                    thr = new RegionDestroyedException(String.format("%s : could not find region %s", dm.getDistributionManagerId(), this.regionPath), this.regionPath);
                    return;
                }
                TXManagerImpl txMgr = this.getTXManager(cache);
                TXStateProxy tx = txMgr.masqueradeAs(this);
                if (tx == null) {
                    sendReply = this.operateOnRegion(dm, r, startTime);
                    break block26;
                }
                try {
                    if (txMgr.isClosed()) {
                        sendReply = false;
                        break block26;
                    }
                    if (tx.isInProgress()) {
                        sendReply = this.operateOnRegion(dm, r, startTime);
                        tx.updateProxyServer(this.getSender());
                        break block26;
                    }
                    throw new TransactionException("transactional operation elided because transaction {" + tx.getTxId() + "} is closed");
                }
                finally {
                    txMgr.unmasquerade(tx);
                }
            }
            catch (RegionDestroyedException | TransactionException | RemoteOperationException ex) {
                thr = ex;
            }
            catch (DistributedSystemDisconnectedException se) {
                thr = null;
                sendReply = false;
                if (logger.isDebugEnabled()) {
                    logger.debug("shutdown caught, abandoning message: {}", (Object)se.getMessage(), (Object)se);
                }
            }
            catch (VirtualMachineError err) {
                thr = new RemoteOperationException("VirtualMachineError", err);
                SystemFailure.initiateFailure(err);
                throw err;
            }
            catch (Throwable t) {
                if (sendReply) {
                    thr = new RemoteOperationException("system failure", SystemFailure.getFailure());
                }
                this.checkForSystemFailure();
                if (sendReply) {
                    thr = !this.checkDSClosing(dm) ? t : new RemoteOperationException("cache is closing", new CacheClosedException());
                }
                if (logger.isTraceEnabled(LogMarker.DM_VERBOSE) && t instanceof RuntimeException) {
                    logger.trace(LogMarker.DM_VERBOSE, "Exception caught while processing message", t);
                }
            }
            finally {
                if (sendReply) {
                    ReplyException rex = null;
                    if (thr != null) {
                        rex = new ReplyException(thr);
                    }
                    this.sendReply(this.getSender(), this.processorId, dm, rex, r, startTime);
                }
            }
        }
    }

    @NotNull
    private String getCacheClosedMessage(ClusterDistributionManager dm) {
        return "Remote cache is closed: " + dm.getId();
    }

    protected void checkForSystemFailure() {
        SystemFailure.checkFailure();
    }

    TXManagerImpl getTXManager(InternalCache cache) {
        return cache.getTxManager();
    }

    LocalRegion getRegionByPath(InternalCache internalCache) {
        return (LocalRegion)internalCache.getRegionByPathForProcessing(this.getRegionPath());
    }

    InternalCache getCache(ClusterDistributionManager dm) {
        return dm.getExistingCache();
    }

    protected void sendReply(InternalDistributedMember member, int procId, DistributionManager dm, ReplyException ex, InternalRegion r, long startTime) {
        ReplyMessage.send(member, procId, ex, this.getReplySender(dm), r != null && r.isInternalRegion());
    }

    protected boolean failIfRegionMissing() {
        return true;
    }

    protected abstract boolean operateOnRegion(ClusterDistributionManager var1, LocalRegion var2, long var3) throws RemoteOperationException;

    @Override
    public void fromData(DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        super.fromData(in, context);
        this.flags = in.readShort();
        this.setFlags(this.flags, in, context);
        this.regionPath = DataSerializer.readString(in);
        this.isTransactionDistributed = in.readBoolean();
    }

    @Override
    public InternalDistributedMember getTXOriginatorClient() {
        return this.txMemberId;
    }

    @Override
    public void toData(DataOutput out, SerializationContext context) throws IOException {
        super.toData(out, context);
        short flags = this.computeCompressedShort();
        out.writeShort(flags);
        if (this.processorId != 0) {
            out.writeInt(this.processorId);
        }
        if (this.processorType != 0) {
            out.writeByte(this.processorType);
        }
        if (this.getTXUniqId() != -1) {
            out.writeInt(this.getTXUniqId());
        }
        if (this.getTXMemberId() != null) {
            context.getSerializer().writeObject((Object)this.getTXMemberId(), out);
        }
        DataSerializer.writeString(this.regionPath, out);
        out.writeBoolean(this.isTransactionDistributed);
    }

    protected short computeCompressedShort() {
        short flags = 0;
        if (this.processorId != 0) {
            flags = (short)(flags | 1);
        }
        if (this.processorType != 0) {
            flags = (short)(flags | 0x20);
        }
        if (this.getTXUniqId() != -1) {
            flags = (short)(flags | 4);
        }
        if (this.getTXMemberId() != null) {
            flags = (short)(flags | 2);
        }
        return flags;
    }

    protected void setFlags(short flags, DataInput in, DeserializationContext context) throws IOException, ClassNotFoundException {
        if ((flags & 1) != 0) {
            this.processorId = in.readInt();
            ReplyProcessor21.setMessageRPId(this.processorId);
        }
        if ((flags & 0x20) != 0) {
            this.processorType = in.readByte();
        }
        if ((flags & 4) != 0) {
            this.txUniqId = in.readInt();
        }
        if ((flags & 2) != 0) {
            this.txMemberId = (InternalDistributedMember)context.getDeserializer().readObject(in);
        }
    }

    protected InternalDistributedMember getTXMemberId() {
        return this.txMemberId;
    }

    @Override
    public String toString() {
        StringBuffer buff = new StringBuffer();
        String className = this.getClass().getName();
        buff.append(className.substring(className.indexOf(PN_TOKEN) + PN_TOKEN.length()));
        buff.append("(regionPath=");
        buff.append(this.regionPath);
        this.appendFields(buff);
        buff.append(" ,distTx=");
        buff.append(this.isTransactionDistributed);
        buff.append(")");
        return buff.toString();
    }

    protected void appendFields(StringBuffer buff) {
        buff.append("; sender=").append(this.getSender()).append("; recipients=[");
        List<InternalDistributedMember> recipients = this.getRecipients();
        for (int i = 0; i < recipients.size() - 1; ++i) {
            buff.append(recipients.get(i)).append(',');
        }
        if (recipients.size() > 0) {
            buff.append(recipients.get(recipients.size() - 1));
        }
        buff.append("]; processorId=").append(this.processorId);
    }

    public InternalDistributedMember getRecipient() {
        return this.getRecipients().get(0);
    }

    public void setOperation(Operation op) {
    }

    public void setHasOldValue(boolean value) {
    }

    @Override
    public int getTXUniqId() {
        return this.txUniqId;
    }

    @Override
    public InternalDistributedMember getMemberToMasqueradeAs() {
        if (this.txMemberId == null) {
            return this.getSender();
        }
        return this.txMemberId;
    }

    @Override
    public boolean canStartRemoteTransaction() {
        return true;
    }

    @Override
    public boolean canParticipateInTransaction() {
        return true;
    }

    @Override
    public boolean isTransactionDistributed() {
        return this.isTransactionDistributed;
    }

    private void setIfTransactionDistributed(ReplyProcessor21 processor) {
        InternalCache cache;
        DistributionManager distributionManager;
        if (processor != null && (distributionManager = processor.getDistributionManager()) != null && (cache = distributionManager.getCache()) != null && cache.getTxManager() != null) {
            this.isTransactionDistributed = cache.getTxManager().isDistributed();
        }
    }

    public static class RemoteOperationResponse
    extends DirectReplyProcessor {
        private volatile RemoteOperationException memberDepartedException;
        private volatile boolean responseReceived;
        private boolean responseRequired;

        public RemoteOperationResponse(InternalDistributedSystem dm, Collection<?> initMembers, boolean register) {
            super(dm, initMembers);
            if (register) {
                this.register();
            }
        }

        public RemoteOperationResponse(InternalDistributedSystem dm, InternalDistributedMember member) {
            this(dm, member, true);
        }

        public RemoteOperationResponse(InternalDistributedSystem dm, InternalDistributedMember member, boolean register) {
            super(dm, member);
            if (register) {
                this.register();
            }
        }

        public void requireResponse() {
            this.responseRequired = true;
        }

        @Override
        public void memberDeparted(DistributionManager distributionManager, InternalDistributedMember id, boolean crashed) {
            if (id != null) {
                if (this.removeMember(id, true)) {
                    this.memberDepartedException = new RemoteOperationException("memberDeparted event for <" + id + "> crashed = " + crashed);
                }
                this.checkIfDone();
            } else {
                Exception e = new Exception("memberDeparted got null memberId");
                logger.info("memberDeparted got null memberId crashed=" + crashed, (Throwable)e);
            }
        }

        public RemoteOperationException getMemberDepartedException() {
            return this.memberDepartedException;
        }

        public void waitForRemoteResponse() throws RemoteOperationException {
            try {
                this.waitForRepliesUninterruptibly();
                RemoteOperationException ex = this.getMemberDepartedException();
                if (ex != null) {
                    throw ex;
                }
                if (this.responseRequired && !this.responseReceived) {
                    throw new RemoteOperationException("response required but not received");
                }
            }
            catch (ReplyException e) {
                Throwable t = e.getCause();
                if (t instanceof RemoteOperationException) {
                    throw (RemoteOperationException)t;
                }
                if (t instanceof CancelException) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("RemoteOperationResponse got CacheClosedException from {}, throwing RemoteOperationException", (Object)e.getSender(), (Object)t);
                    }
                    throw new RemoteOperationException("remote cache was closed", t);
                }
                e.handleCause();
            }
        }

        @Override
        public void process(DistributionMessage msg) {
            this.responseReceived = true;
            super.process(msg);
        }
    }
}

