/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.control;

import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.cache.control.RestoreRedundancyOperation;
import org.apache.geode.cache.partition.PartitionRebalanceInfo;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.control.FilterByPath;
import org.apache.geode.internal.cache.control.InternalResourceManager;
import org.apache.geode.internal.cache.control.RegionFilter;
import org.apache.geode.internal.cache.control.SerializableRegionRedundancyStatusImpl;
import org.apache.geode.internal.cache.control.SerializableRestoreRedundancyResultsImpl;
import org.apache.geode.internal.cache.partitioned.PartitionedRegionRebalanceOp;
import org.apache.geode.internal.cache.partitioned.rebalance.CompositeDirector;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.management.runtime.RegionRedundancyStatus;
import org.apache.geode.management.runtime.RestoreRedundancyResults;

class RestoreRedundancyOperationImpl
implements RestoreRedundancyOperation {
    private final InternalCache cache;
    private final InternalResourceManager manager;
    private Set<String> includedRegions;
    private Set<String> excludedRegions;
    private boolean shouldReassign = true;
    private final ScheduledExecutorService executor;

    public RestoreRedundancyOperationImpl(InternalCache cache) {
        this.cache = cache;
        this.manager = cache.getInternalResourceManager();
        this.executor = this.manager.getExecutor();
    }

    @Override
    public RestoreRedundancyOperation includeRegions(Set<String> regions) {
        this.includedRegions = regions;
        return this;
    }

    @Override
    public RestoreRedundancyOperation excludeRegions(Set<String> regions) {
        this.excludedRegions = regions;
        return this;
    }

    @Override
    public RestoreRedundancyOperation shouldReassignPrimaries(boolean shouldReassign) {
        this.shouldReassign = shouldReassign;
        return this;
    }

    @Override
    public CompletableFuture<RestoreRedundancyResults> start() {
        RegionFilter filter = this.getRegionFilter();
        long start = this.manager.getStats().startRestoreRedundancy();
        List<CompletableFuture<RestoreRedundancyResults>> regionFutures = this.cache.getPartitionedRegions().stream().filter(filter::include).map(this::getRedundancyOpFuture).collect(Collectors.toList());
        CompletableFuture<Void> combinedFuture = CompletableFuture.allOf(regionFutures.toArray(new CompletableFuture[0]));
        CompletableFuture<RestoreRedundancyResults> resultsFuture = this.getResultsFuture(regionFutures, combinedFuture);
        resultsFuture.thenRun(() -> {
            this.manager.removeInProgressRestoreRedundancy(resultsFuture);
            this.manager.getStats().endRestoreRedundancy(start);
        });
        this.manager.addInProgressRestoreRedundancy(resultsFuture);
        return resultsFuture;
    }

    @Override
    public RestoreRedundancyResults redundancyStatus() {
        RegionFilter filter = this.getRegionFilter();
        SerializableRestoreRedundancyResultsImpl results = this.getEmptyRestoreRedundancyResults();
        this.cache.getPartitionedRegions().stream().filter(filter::include).forEach(region -> results.addRegionResult(this.getRegionResult((PartitionedRegion)region)));
        return results;
    }

    RestoreRedundancyResults doRestoreRedundancy(PartitionedRegion region) {
        try {
            PartitionedRegionRebalanceOp op = this.getPartitionedRegionRebalanceOp(region);
            this.cache.getCancelCriterion().checkCancelInProgress(null);
            try {
                Set<PartitionRebalanceInfo> detailSet = op.execute();
                SerializableRestoreRedundancyResultsImpl results = this.getEmptyRestoreRedundancyResults();
                if (detailSet.isEmpty()) {
                    results.addRegionResult(this.getRegionResult(region));
                } else {
                    for (PartitionRebalanceInfo details : detailSet) {
                        PartitionedRegion detailRegion = (PartitionedRegion)this.cache.getRegion(details.getRegionPath());
                        results.addRegionResult(this.getRegionResult(detailRegion));
                        results.addPrimaryReassignmentDetails(details);
                    }
                }
                return results;
            }
            catch (RuntimeException ex) {
                LogService.getLogger().debug("Unexpected exception in restoring redundancy: {}", (Object)ex.getMessage(), (Object)ex);
                throw ex;
            }
        }
        catch (RegionDestroyedException ex) {
            return this.getEmptyRestoreRedundancyResults();
        }
    }

    RestoreRedundancyResults getRestoreRedundancyResults(List<CompletableFuture<RestoreRedundancyResults>> regionFutures) {
        SerializableRestoreRedundancyResultsImpl finalResult = this.getEmptyRestoreRedundancyResults();
        regionFutures.stream().map(CompletableFuture::join).forEach(arg_0 -> ((SerializableRestoreRedundancyResultsImpl)finalResult).addRegionResults(arg_0));
        return finalResult;
    }

    RegionFilter getRegionFilter() {
        return new FilterByPath(this.includedRegions, this.excludedRegions);
    }

    CompletableFuture<RestoreRedundancyResults> getRedundancyOpFuture(PartitionedRegion region) {
        return CompletableFuture.supplyAsync(() -> this.doRestoreRedundancy(region), this.executor);
    }

    PartitionedRegionRebalanceOp getPartitionedRegionRebalanceOp(PartitionedRegion region) {
        CompositeDirector director = new CompositeDirector(true, true, false, this.shouldReassign);
        director.setIsRestoreRedundancy(true);
        return new PartitionedRegionRebalanceOp(region, false, director, true, false, new AtomicBoolean(), this.manager.getStats());
    }

    SerializableRestoreRedundancyResultsImpl getEmptyRestoreRedundancyResults() {
        return new SerializableRestoreRedundancyResultsImpl();
    }

    RegionRedundancyStatus getRegionResult(PartitionedRegion region) {
        return new SerializableRegionRedundancyStatusImpl(region);
    }

    CompletableFuture<RestoreRedundancyResults> getResultsFuture(List<CompletableFuture<RestoreRedundancyResults>> regionFutures, CompletableFuture<Void> combinedFuture) {
        return combinedFuture.thenApplyAsync(voidd -> this.getRestoreRedundancyResults(regionFutures), (Executor)this.executor);
    }
}

