/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache;

import org.apache.geode.annotations.Immutable;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.cache.query.internal.Support;
import org.apache.geode.internal.cache.ClientServerObserver;
import org.apache.geode.internal.cache.ClientServerObserverAdapter;

public class ClientServerObserverHolder {
    @Immutable
    private static final ClientServerObserver NO_OBSERVER;
    @MakeNotStatic
    private static ClientServerObserver _instance;

    public static ClientServerObserver setInstance(ClientServerObserver observer) {
        Support.assertArg(observer != null, "setInstance expects a non-null argument!");
        ClientServerObserver oldObserver = _instance;
        _instance = observer;
        return oldObserver;
    }

    public static ClientServerObserver getInstance() {
        return _instance;
    }

    public static ClientServerObserver clearInstance() {
        ClientServerObserver oldObserver = _instance;
        _instance = NO_OBSERVER;
        return oldObserver;
    }

    static {
        _instance = NO_OBSERVER = new ClientServerObserverAdapter();
    }
}

