/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal;

import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.geode.distributed.DistributedSystemDisconnectedException;
import org.apache.geode.distributed.internal.ClusterDistributionManager;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.distributed.internal.MembershipListener;
import org.apache.geode.distributed.internal.locks.ElderState;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.util.concurrent.StoppableReentrantLock;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class ClusterElderManager {
    private static final Logger logger = LogService.getLogger();
    private final ClusterDistributionManager clusterDistributionManager;
    private final StoppableReentrantLock elderLock;
    private ElderState elderState;
    private volatile boolean elderStateInitialized;
    private final Supplier<ElderState> elderStateSupplier;

    public ClusterElderManager(ClusterDistributionManager clusterDistributionManager) {
        this(clusterDistributionManager, () -> new ElderState(clusterDistributionManager));
    }

    public ClusterElderManager(ClusterDistributionManager clusterDistributionManager, Supplier<ElderState> elderStateSupplier) {
        this.clusterDistributionManager = clusterDistributionManager;
        this.elderLock = new StoppableReentrantLock(clusterDistributionManager.getCancelCriterion());
        this.elderStateSupplier = elderStateSupplier;
    }

    InternalDistributedMember getElderCandidate() {
        return this.getElderCandidates().stream().findFirst().orElse(null);
    }

    List<InternalDistributedMember> getElderCandidates() {
        List<InternalDistributedMember> theMembers = this.clusterDistributionManager.getViewMembers();
        return theMembers.stream().filter(member -> member.getVmKind() != 12).filter(member -> !this.clusterDistributionManager.getDistribution().isSurpriseMember((InternalDistributedMember)member)).collect(Collectors.toList());
    }

    public InternalDistributedMember getElderId() throws DistributedSystemDisconnectedException {
        if (this.clusterDistributionManager.isCloseInProgress()) {
            throw new DistributedSystemDisconnectedException("no valid elder when system is shutting down", this.clusterDistributionManager.getRootCause());
        }
        this.clusterDistributionManager.getSystem().getCancelCriterion().checkCancelInProgress(null);
        return this.getElderCandidate();
    }

    public boolean isElder() {
        return this.clusterDistributionManager.getId().equals(this.getElderCandidate());
    }

    public ElderState getElderState(boolean waitToBecomeElder) throws InterruptedException {
        if (waitToBecomeElder) {
            this.waitForElder(this.clusterDistributionManager.getId());
        }
        if (!this.isElder() && !waitToBecomeElder) {
            return null;
        }
        if (this.elderStateInitialized) {
            return this.elderState;
        }
        return this.initializeElderState();
    }

    private ElderState initializeElderState() {
        this.elderLock.lock();
        try {
            if (this.elderState == null) {
                this.elderState = this.elderStateSupplier.get();
            }
            this.elderStateInitialized = true;
        }
        finally {
            this.elderLock.unlock();
        }
        return this.elderState;
    }

    public boolean waitForElder(InternalDistributedMember desiredElder) throws InterruptedException {
        MembershipChangeListener changeListener = new MembershipChangeListener();
        this.clusterDistributionManager.addMembershipListener(changeListener);
        try {
            while (true) {
                if (this.clusterDistributionManager.isCloseInProgress()) {
                    boolean bl = false;
                    return bl;
                }
                InternalDistributedMember currentElder = this.getElderCandidate();
                if (desiredElder.equals(currentElder)) {
                    boolean bl = true;
                    return bl;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Expecting Elder to be {} but it is {}.", (Object)desiredElder, (Object)currentElder);
                }
                if (!this.clusterDistributionManager.isCurrentMember(desiredElder)) {
                    boolean bl = false;
                    return bl;
                }
                if (!this.clusterDistributionManager.getId().equals(desiredElder) && this.clusterDistributionManager.getId().equals(currentElder)) {
                    boolean bl = false;
                    return bl;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Waiting for membership to change");
                }
                changeListener.waitForMembershipChange();
            }
        }
        finally {
            this.clusterDistributionManager.removeMembershipListener(changeListener);
        }
    }

    private static class MembershipChangeListener
    implements MembershipListener {
        private boolean changeOccurred = false;

        private MembershipChangeListener() {
        }

        @Override
        public void memberJoined(DistributionManager distributionManager, InternalDistributedMember theId) {
            this.signalChange();
        }

        @Override
        public void memberDeparted(DistributionManager distributionManager, InternalDistributedMember theId, boolean crashed) {
            this.signalChange();
        }

        @Override
        public void memberSuspect(DistributionManager distributionManager, InternalDistributedMember id, InternalDistributedMember whoSuspected, String reason) {
            this.signalChange();
        }

        @Override
        public void quorumLost(DistributionManager distributionManager, Set<InternalDistributedMember> failures, List<InternalDistributedMember> remaining) {
            this.signalChange();
        }

        private synchronized void signalChange() {
            this.changeOccurred = true;
            this.notifyAll();
        }

        public synchronized void waitForMembershipChange() throws InterruptedException {
            if (!this.changeOccurred) {
                this.wait(100L);
            }
            this.changeOccurred = false;
        }
    }
}

