/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.geode.SystemFailure;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.partition.PartitionRegionHelper;
import org.apache.geode.cache.server.CacheServer;
import org.apache.geode.distributed.AbstractLauncher;
import org.apache.geode.distributed.DistributedSystem;
import org.apache.geode.distributed.ServerLauncherCacheProvider;
import org.apache.geode.distributed.ServerLauncherParameters;
import org.apache.geode.distributed.internal.DefaultServerLauncherCacheProvider;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.internal.GemFireVersion;
import org.apache.geode.internal.cache.CacheConfig;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.control.InternalResourceManager;
import org.apache.geode.internal.cache.tier.sockets.CacheServerHelper;
import org.apache.geode.internal.inet.LocalHostUtil;
import org.apache.geode.internal.lang.ObjectUtils;
import org.apache.geode.internal.lang.StringUtils;
import org.apache.geode.internal.lang.SystemUtils;
import org.apache.geode.internal.process.ConnectionFailedException;
import org.apache.geode.internal.process.ControlNotificationHandler;
import org.apache.geode.internal.process.ControllableProcess;
import org.apache.geode.internal.process.FileAlreadyExistsException;
import org.apache.geode.internal.process.FileControllableProcess;
import org.apache.geode.internal.process.MBeanInvocationFailedException;
import org.apache.geode.internal.process.PidUnavailableException;
import org.apache.geode.internal.process.ProcessController;
import org.apache.geode.internal.process.ProcessControllerFactory;
import org.apache.geode.internal.process.ProcessControllerParameters;
import org.apache.geode.internal.process.ProcessLauncherContext;
import org.apache.geode.internal.process.ProcessType;
import org.apache.geode.internal.process.UnableToControlProcessException;
import org.apache.geode.internal.util.IOUtils;
import org.apache.geode.lang.AttachAPINotFoundException;
import org.apache.geode.logging.internal.executors.LoggingThread;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.management.internal.util.HostUtils;
import org.apache.geode.management.internal.util.JsonUtil;
import org.apache.geode.pdx.PdxSerializer;
import org.apache.geode.security.AuthenticationRequiredException;
import org.apache.geode.security.GemFireSecurityException;
import org.apache.logging.log4j.Logger;

public class ServerLauncher
extends AbstractLauncher<String> {
    private static final Logger log = LogService.getLogger();
    @Immutable
    private static final Map<String, String> helpMap;
    @Immutable
    private static final Map<Command, String> usageMap;
    private static final String DEFAULT_SERVER_LOG_EXT = ".log";
    private static final String DEFAULT_SERVER_LOG_NAME = "gemfire";
    private static final String SERVER_SERVICE_NAME = "Server";
    @MakeNotStatic
    private static final AtomicReference<ServerLauncher> INSTANCE;
    @Immutable
    private static final ServerLauncherCacheProvider DEFAULT_CACHE_PROVIDER;
    private static final Logger logger;
    private volatile boolean debug;
    private final ControlNotificationHandler controlHandler;
    private final AtomicBoolean starting = new AtomicBoolean(false);
    private final boolean assignBuckets;
    private final boolean deletePidFileOnStop;
    private final boolean disableDefaultServer;
    private final boolean force;
    private final boolean help;
    private final boolean rebalance;
    private final boolean redirectOutput;
    private volatile Cache cache;
    private final CacheConfig cacheConfig;
    private final Command command;
    private final InetAddress serverBindAddress;
    private final Integer pid;
    private final Integer serverPort;
    private final Properties distributedSystemProperties;
    private final String memberName;
    private final String springXmlLocation;
    private final String workingDirectory;
    private volatile String statusMessage;
    private final Float criticalHeapPercentage;
    private final Float evictionHeapPercentage;
    private final Float criticalOffHeapPercentage;
    private final Float evictionOffHeapPercentage;
    private final String hostNameForClients;
    private final Integer maxConnections;
    private final Integer maxMessageCount;
    private final Integer messageTimeToLive;
    private final Integer socketBufferSize;
    private final Integer maxThreads;
    private volatile ControllableProcess process;
    private final ServerControllerParameters controllerParameters;
    private final Runnable startupCompletionAction;
    private final Consumer<Throwable> startupExceptionAction;
    private final ServerLauncherCacheProvider serverLauncherCacheProvider;
    private final Supplier<ControllableProcess> controllableProcessFactory;
    private static final String TWO_NEW_LINES;

    public static void main(String ... args) {
        try {
            new Builder(args).build().run();
        }
        catch (AttachAPINotFoundException handled) {
            System.err.println(handled.getMessage());
        }
    }

    private static Integer getDefaultServerPort() {
        return Integer.getInteger("gemfire.test.CacheServer.OVERRIDE_DEFAULT_PORT", 40404);
    }

    public static ServerLauncher getInstance() {
        return INSTANCE.get();
    }

    public static ServerState getServerState() {
        return ServerLauncher.getInstance() != null ? ServerLauncher.getInstance().status() : null;
    }

    private ServerLauncher(Builder builder) {
        this.cache = builder.getCache();
        this.cacheConfig = builder.getCacheConfig();
        this.command = builder.getCommand();
        this.assignBuckets = Boolean.TRUE.equals(builder.getAssignBuckets());
        this.setDebug(Boolean.TRUE.equals(builder.getDebug()));
        this.deletePidFileOnStop = Boolean.TRUE.equals(builder.getDeletePidFileOnStop());
        this.disableDefaultServer = Boolean.TRUE.equals(builder.getDisableDefaultServer());
        this.distributedSystemProperties = builder.getDistributedSystemProperties();
        this.force = Boolean.TRUE.equals(builder.getForce());
        this.help = Boolean.TRUE.equals(builder.getHelp());
        this.hostNameForClients = builder.getHostNameForClients();
        this.memberName = builder.getMemberName();
        this.pid = builder.getPid();
        this.rebalance = Boolean.TRUE.equals(builder.getRebalance());
        this.redirectOutput = Boolean.TRUE.equals(builder.getRedirectOutput());
        this.serverBindAddress = builder.getServerBindAddress();
        this.serverPort = builder.getServerPort();
        this.springXmlLocation = builder.getSpringXmlLocation();
        this.workingDirectory = builder.getWorkingDirectory();
        this.criticalHeapPercentage = builder.getCriticalHeapPercentage();
        this.evictionHeapPercentage = builder.getEvictionHeapPercentage();
        this.criticalOffHeapPercentage = builder.getCriticalOffHeapPercentage();
        this.evictionOffHeapPercentage = builder.getEvictionOffHeapPercentage();
        this.maxConnections = builder.getMaxConnections();
        this.maxMessageCount = builder.getMaxMessageCount();
        this.maxThreads = builder.getMaxThreads();
        this.messageTimeToLive = builder.getMessageTimeToLive();
        this.socketBufferSize = builder.getSocketBufferSize();
        this.controllerParameters = new ServerControllerParameters();
        this.startupCompletionAction = builder.getStartupCompletionAction();
        this.startupExceptionAction = builder.getStartupExceptionAction();
        this.controlHandler = new ControlNotificationHandler(){

            @Override
            public void handleStop() {
                if (ServerLauncher.this.isStoppable()) {
                    ServerLauncher.this.stopInProcess();
                }
            }

            @Override
            public AbstractLauncher.ServiceState<?> handleStatus() {
                return ServerLauncher.this.statusInProcess();
            }
        };
        this.serverLauncherCacheProvider = builder.getServerLauncherCacheProvider();
        this.controllableProcessFactory = builder.getControllableProcessFactory();
        Integer serverPort = builder.isServerPortSetByUser() && this.serverPort != null ? this.serverPort : null;
        String serverBindAddress = builder.isServerBindAddressSetByUser() && this.serverBindAddress != null ? this.serverBindAddress.getHostAddress() : null;
        ServerLauncherParameters.INSTANCE.withPort(serverPort).withMaxThreads(this.maxThreads).withBindAddress(serverBindAddress).withMaxConnections(this.maxConnections).withMaxMessageCount(this.maxMessageCount).withSocketBufferSize(this.socketBufferSize).withMessageTimeToLive(this.messageTimeToLive).withHostnameForClients(this.hostNameForClients).withDisableDefaultServer(this.disableDefaultServer);
    }

    public Cache getCache() {
        Cache newCache;
        boolean isReconnecting;
        if (this.cache != null && (isReconnecting = this.cache.isReconnecting()) && (newCache = this.cache.getReconnectedCache()) != null) {
            this.cache = newCache;
        }
        return this.cache;
    }

    public CacheConfig getCacheConfig() {
        CacheConfig copy = new CacheConfig();
        copy.setDeclarativeConfig(this.cacheConfig);
        return copy;
    }

    public String getId() {
        StringBuilder buffer = new StringBuilder(ServerState.getServerBindAddressAsString(this));
        String serverPort = ServerState.getServerPortAsString(this);
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)serverPort)) {
            buffer.append("[").append(serverPort).append("]");
        }
        return buffer.toString();
    }

    public Command getCommand() {
        return this.command;
    }

    public boolean isAssignBuckets() {
        return this.assignBuckets;
    }

    public boolean isDisableDefaultServer() {
        return this.disableDefaultServer;
    }

    public boolean isForcing() {
        return this.force;
    }

    public boolean isHelping() {
        return this.help;
    }

    public boolean isRebalancing() {
        return this.rebalance;
    }

    public boolean isRedirectingOutput() {
        return this.redirectOutput;
    }

    @Override
    public String getLogFileName() {
        return ((String)org.apache.commons.lang3.StringUtils.defaultIfBlank((CharSequence)this.getMemberName(), (CharSequence)DEFAULT_SERVER_LOG_NAME)).concat(DEFAULT_SERVER_LOG_EXT);
    }

    @Override
    public String getMemberName() {
        return (String)org.apache.commons.lang3.StringUtils.defaultIfBlank((CharSequence)this.memberName, (CharSequence)super.getMemberName());
    }

    @Override
    public Integer getPid() {
        return this.pid;
    }

    public Properties getProperties() {
        return (Properties)this.distributedSystemProperties.clone();
    }

    public InetAddress getServerBindAddress() {
        return this.serverBindAddress;
    }

    public String getServerBindAddressAsString() {
        try {
            if (this.getServerBindAddress() != null) {
                return this.getServerBindAddress().getCanonicalHostName();
            }
            return LocalHostUtil.getCanonicalLocalHostName();
        }
        catch (UnknownHostException handled) {
            return "localhost/127.0.0.1";
        }
    }

    public Integer getServerPort() {
        return this.serverPort;
    }

    public String getServerPortAsString() {
        Integer v1 = this.getServerPort();
        return (v1 != null ? v1 : ServerLauncher.getDefaultServerPort()).toString();
    }

    @Override
    public String getServiceName() {
        return SERVER_SERVICE_NAME;
    }

    public String getSpringXmlLocation() {
        return this.springXmlLocation;
    }

    public boolean isSpringXmlLocationSpecified() {
        return org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)this.springXmlLocation);
    }

    @Override
    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    public Float getCriticalHeapPercentage() {
        return this.criticalHeapPercentage;
    }

    public Float getEvictionHeapPercentage() {
        return this.evictionHeapPercentage;
    }

    public Float getCriticalOffHeapPercentage() {
        return this.criticalOffHeapPercentage;
    }

    public Float getEvictionOffHeapPercentage() {
        return this.evictionOffHeapPercentage;
    }

    public String getHostNameForClients() {
        return this.hostNameForClients;
    }

    public Integer getMaxConnections() {
        return this.maxConnections;
    }

    public Integer getMaxMessageCount() {
        return this.maxMessageCount;
    }

    public Integer getMessageTimeToLive() {
        return this.messageTimeToLive;
    }

    public Integer getMaxThreads() {
        return this.maxThreads;
    }

    public Integer getSocketBufferSize() {
        return this.socketBufferSize;
    }

    public void help(Command command) {
        if (Command.isUnspecified(command)) {
            this.usage();
        } else {
            this.info(StringUtils.wrap(helpMap.get(command.getName()), 80, ""), new Object[0]);
            this.info(TWO_NEW_LINES + "usage: " + TWO_NEW_LINES, new Object[0]);
            this.info(StringUtils.wrap("> java ... " + this.getClass().getName() + ' ' + usageMap.get((Object)command), 80, "\t\t"), new Object[0]);
            this.info(TWO_NEW_LINES + "options: " + TWO_NEW_LINES, new Object[0]);
            for (String option : command.getOptions()) {
                this.info(StringUtils.wrap("--" + option + ": " + helpMap.get(option) + System.lineSeparator(), 80, "\t"), new Object[0]);
            }
            this.info(TWO_NEW_LINES, new Object[0]);
        }
    }

    public void usage() {
        this.info(StringUtils.wrap(helpMap.get("launcher"), 80, "\t"), new Object[0]);
        this.info(TWO_NEW_LINES + "START" + TWO_NEW_LINES, new Object[0]);
        this.help(Command.START);
        this.info("STATUS" + TWO_NEW_LINES, new Object[0]);
        this.help(Command.STATUS);
        this.info("STOP" + TWO_NEW_LINES, new Object[0]);
        this.help(Command.STOP);
    }

    @Override
    public void run() {
        if (!this.isHelping()) {
            switch (this.getCommand()) {
                case START: {
                    this.info(this.start(), new Object[0]);
                    this.waitOnServer();
                    break;
                }
                case STATUS: {
                    this.info(this.status(), new Object[0]);
                    break;
                }
                case STOP: {
                    this.info(this.stop(), new Object[0]);
                    break;
                }
                case VERSION: {
                    this.info(this.version(), new Object[0]);
                    break;
                }
                default: {
                    this.usage();
                    break;
                }
            }
        } else {
            this.help(this.getCommand());
        }
    }

    protected File getServerPidFile() {
        return new File(this.getWorkingDirectory(), ProcessType.SERVER.getPidFileName());
    }

    private boolean isStartable() {
        return !this.isRunning() && this.starting.compareAndSet(false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerState start() {
        long startTime = System.currentTimeMillis();
        if (this.isStartable()) {
            INSTANCE.compareAndSet(null, this);
            try {
                Object gemfireProperties;
                this.process = this.getControllableProcess();
                if (!this.isDisableDefaultServer()) {
                    ServerLauncher.assertPortAvailable(this.getServerBindAddress(), this.getServerPort());
                }
                SystemFailure.setExitOK(true);
                ProcessLauncherContext.set(this.isRedirectingOutput(), this.getOverriddenDefaults(), statusMessage -> {
                    this.debug("Callback setStatus(String) called with message (%1$s)...", statusMessage);
                    this.statusMessage = statusMessage;
                });
                try {
                    gemfireProperties = this.getDistributedSystemProperties(this.getProperties());
                    this.cache = this.createCache((Properties)gemfireProperties);
                    if (this.criticalHeapPercentage != null) {
                        this.cache.getResourceManager().setCriticalHeapPercentage(this.getCriticalHeapPercentage().floatValue());
                    }
                    if (this.evictionHeapPercentage != null) {
                        this.cache.getResourceManager().setEvictionHeapPercentage(this.getEvictionHeapPercentage().floatValue());
                    }
                    if (this.criticalOffHeapPercentage != null) {
                        this.cache.getResourceManager().setCriticalOffHeapPercentage(this.getCriticalOffHeapPercentage().floatValue());
                    }
                    if (this.evictionOffHeapPercentage != null) {
                        this.cache.getResourceManager().setEvictionOffHeapPercentage(this.getEvictionOffHeapPercentage().floatValue());
                    }
                    this.cache.setIsServer(true);
                    this.startCacheServer(this.cache);
                    this.assignBuckets(this.cache);
                    this.rebalance(this.cache);
                }
                finally {
                    ProcessLauncherContext.remove();
                }
                this.awaitStartupTasks(this.cache, startTime);
                this.debug("Running Server on (%1$s) in (%2$s) as (%3$s)...", this.getId(), this.getWorkingDirectory(), this.getMember());
                this.running.set(true);
                gemfireProperties = new ServerState(this, AbstractLauncher.Status.ONLINE);
                return gemfireProperties;
            }
            catch (AuthenticationRequiredException e) {
                this.failOnStart(e);
                throw new AuthenticationRequiredException("user/password required. Please start your server with --user and --password. " + e.getMessage());
            }
            catch (GemFireSecurityException e) {
                this.failOnStart(e);
                throw new GemFireSecurityException(e.getMessage());
            }
            catch (IOException e) {
                this.failOnStart(e);
                throw new RuntimeException(String.format("An IO error occurred while starting a %s in %s on %s: %s", this.getServiceName(), this.getWorkingDirectory(), this.getId(), e.getMessage()), e);
            }
            catch (FileAlreadyExistsException e) {
                this.failOnStart(e);
                throw new RuntimeException(String.format("A PID file already exists and a %s may be running in %s on %s.", this.getServiceName(), this.getWorkingDirectory(), this.getId()), e);
            }
            catch (PidUnavailableException e) {
                this.failOnStart(e);
                throw new RuntimeException(String.format("The process ID could not be determined while starting %s %s in %s: %s", this.getServiceName(), this.getId(), this.getWorkingDirectory(), e.getMessage()), e);
            }
            catch (Error | RuntimeException e) {
                this.failOnStart(e);
                throw e;
            }
            catch (Exception e) {
                this.failOnStart(e);
                throw new RuntimeException(e);
            }
            finally {
                this.starting.set(false);
            }
        }
        throw new IllegalStateException(String.format("A %s is already running in %s on %s.", this.getServiceName(), this.getWorkingDirectory(), this.getId()));
    }

    Cache createCache(Properties gemfireProperties) {
        Iterable<ServerLauncherCacheProvider> loader = this.getServerLauncherCacheProviders();
        for (ServerLauncherCacheProvider provider : loader) {
            Cache cache = provider.createCache(gemfireProperties, this);
            if (cache == null) continue;
            return cache;
        }
        return DEFAULT_CACHE_PROVIDER.createCache(gemfireProperties, this);
    }

    private Iterable<ServerLauncherCacheProvider> getServerLauncherCacheProviders() {
        return this.serverLauncherCacheProvider != null ? Collections.singleton(this.serverLauncherCacheProvider) : ServiceLoader.load(ServerLauncherCacheProvider.class);
    }

    private void failOnStart(Throwable cause) {
        if (this.cache != null) {
            this.cache.close();
            this.cache = null;
        }
        if (this.process != null) {
            this.process.stop(this.deletePidFileOnStop);
            this.process = null;
        }
        INSTANCE.compareAndSet(this, null);
        this.running.set(false);
    }

    protected boolean isServing(Cache cache) {
        return !cache.getCacheServers().isEmpty();
    }

    boolean isWaiting(Cache cache) {
        return this.isRunning() && (cache.getDistributedSystem().isConnected() || cache.isReconnecting());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitOnServer() {
        assert (this.getCache() != null) : "The Cache Server must first be started with a call to start!";
        if (!this.isServing(this.getCache())) {
            RuntimeException cause = null;
            try {
                while (this.isWaiting(this.getCache())) {
                    try {
                        ServerLauncher serverLauncher = this;
                        synchronized (serverLauncher) {
                            this.wait(500L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                    }
                }
            }
            catch (RuntimeException e) {
                cause = e;
                throw e;
            }
            finally {
                this.failOnStart(cause);
            }
        }
    }

    protected boolean isDefaultServerEnabled(Cache cache) {
        return cache.getCacheServers().isEmpty() && !this.isDisableDefaultServer();
    }

    private void startCacheServer(Cache cache) throws IOException {
        if (this.isDefaultServerEnabled(cache)) {
            String serverBindAddress = this.getServerBindAddress() == null ? null : this.getServerBindAddress().getHostAddress();
            Integer serverPort = this.getServerPort();
            CacheServer cacheServer = cache.addCacheServer();
            cacheServer.setBindAddress(serverBindAddress);
            cacheServer.setPort(serverPort);
            if (this.getMaxThreads() != null) {
                cacheServer.setMaxThreads(this.getMaxThreads());
            }
            if (this.getMaxConnections() != null) {
                cacheServer.setMaxConnections(this.getMaxConnections());
            }
            if (this.getMaxMessageCount() != null) {
                cacheServer.setMaximumMessageCount(this.getMaxMessageCount());
            }
            if (this.getMessageTimeToLive() != null) {
                cacheServer.setMessageTimeToLive(this.getMessageTimeToLive());
            }
            if (this.getSocketBufferSize() != null) {
                cacheServer.setSocketBufferSize(this.getSocketBufferSize());
            }
            if (this.getHostNameForClients() != null) {
                cacheServer.setHostnameForClients(this.getHostNameForClients());
            }
            CacheServerHelper.setIsDefaultServer(cacheServer);
            cacheServer.start();
        }
    }

    private void awaitStartupTasks(Cache cache, long startTime) {
        Runnable afterStartup = this.startupCompletionAction == null ? () -> this.logStartCompleted(startTime) : this.startupCompletionAction;
        Consumer<Throwable> exceptionAction = this.startupExceptionAction == null ? throwable -> this.logStartCompletedWithError(startTime, (Throwable)throwable) : this.startupExceptionAction;
        CompletableFuture<Void> startupTasks = ((InternalResourceManager)cache.getResourceManager()).allOfStartupTasks();
        ((CompletableFuture)((CompletableFuture)startupTasks.thenRun(afterStartup)).exceptionally(throwable -> {
            exceptionAction.accept((Throwable)throwable);
            return null;
        })).join();
    }

    private void logStartCompleted(long startTime) {
        long startupDuration = System.currentTimeMillis() - startTime;
        log.info("Server {} startup completed in {} ms", (Object)this.memberName, (Object)startupDuration);
    }

    private void logStartCompletedWithError(long startTime, Throwable throwable) {
        long startupDuration = System.currentTimeMillis() - startTime;
        log.error("Server {} startup completed in {} ms with error: {}", (Object)this.memberName, (Object)startupDuration, (Object)throwable, (Object)throwable);
    }

    private void rebalance(Cache cache) {
        if (this.isRebalancing()) {
            cache.getResourceManager().createRebalanceFactory().start();
        }
    }

    private boolean isAssignBucketsAllowed(Cache cache) {
        return this.isAssignBuckets() && cache instanceof GemFireCacheImpl;
    }

    private void assignBuckets(Cache cache) {
        if (this.isAssignBucketsAllowed(cache)) {
            for (PartitionedRegion region : ((InternalCache)cache).getPartitionedRegions()) {
                PartitionRegionHelper.assignBucketsToPartitions(region);
            }
        }
    }

    protected boolean isStartingOrRunning() {
        return this.starting.get() || this.isRunning();
    }

    public ServerState status() {
        ServerLauncher launcher = ServerLauncher.getInstance();
        if (this.isStartingOrRunning()) {
            this.debug("Getting status from the ServerLauncher instance that actually launched the GemFire Cache Server.%n", new Object[0]);
            return new ServerState(this, this.isRunning() ? AbstractLauncher.Status.ONLINE : AbstractLauncher.Status.STARTING);
        }
        if (this.isPidInProcess() && launcher != null) {
            return launcher.statusInProcess();
        }
        if (this.getPid() != null) {
            this.debug("Getting Server status using process ID (%1$s)%n", this.getPid());
            return this.statusWithPid();
        }
        if (this.getWorkingDirectory() != null) {
            this.debug("Getting Server status using working directory (%1$s)%n", this.getWorkingDirectory());
            return this.statusWithWorkingDirectory();
        }
        this.debug("This ServerLauncher was not the instance used to launch the GemFire Cache Server, and neither PID nor working directory were specified; the Server's state is unknown.%n", new Object[0]);
        return new ServerState(this, AbstractLauncher.Status.NOT_RESPONDING);
    }

    private ServerState statusInProcess() {
        if (this.isStartingOrRunning()) {
            this.debug("Getting status from the ServerLauncher instance that actually launched the GemFire Cache Server.%n", new Object[0]);
            return new ServerState(this, this.isRunning() ? AbstractLauncher.Status.ONLINE : AbstractLauncher.Status.STARTING);
        }
        return new ServerState(this, AbstractLauncher.Status.NOT_RESPONDING);
    }

    private ServerState statusWithPid() {
        try {
            ProcessController controller = new ProcessControllerFactory().createProcessController(this.controllerParameters, this.getPid());
            controller.checkPidSupport();
            String statusJson = controller.status();
            return ServerState.fromJson(statusJson);
        }
        catch (ConnectionFailedException handled) {
            return this.createNoResponseState(handled, "Failed to connect to server with process id " + this.getPid());
        }
        catch (IOException | InterruptedException | TimeoutException | MBeanInvocationFailedException | UnableToControlProcessException handled) {
            return this.createNoResponseState(handled, "Failed to communicate with server with process id " + this.getPid());
        }
    }

    private ServerState statusWithWorkingDirectory() {
        int parsedPid = 0;
        try {
            ServerLauncher runningLauncher;
            ProcessController controller = new ProcessControllerFactory().createProcessController(this.controllerParameters, new File(this.getWorkingDirectory()), ProcessType.SERVER.getPidFileName());
            parsedPid = controller.getProcessId();
            if (parsedPid == this.identifyPid() && (runningLauncher = ServerLauncher.getInstance()) != null) {
                return runningLauncher.statusInProcess();
            }
            String statusJson = controller.status();
            return ServerState.fromJson(statusJson);
        }
        catch (ConnectionFailedException handled) {
            return this.createNoResponseState(handled, "Failed to connect to server with process id " + parsedPid);
        }
        catch (FileNotFoundException handled) {
            return this.createNoResponseState(handled, "Failed to find process file " + ProcessType.SERVER.getPidFileName() + " in " + this.getWorkingDirectory());
        }
        catch (IOException | TimeoutException | MBeanInvocationFailedException | UnableToControlProcessException handled) {
            return this.createNoResponseState(handled, "Failed to communicate with server with process id " + parsedPid);
        }
        catch (InterruptedException handled) {
            Thread.currentThread().interrupt();
            return this.createNoResponseState(handled, "Interrupted while trying to communicate with server with process id " + parsedPid);
        }
        catch (PidUnavailableException handled) {
            return this.createNoResponseState(handled, "Failed to find usable process id within file " + ProcessType.SERVER.getPidFileName() + " in " + this.getWorkingDirectory());
        }
    }

    private boolean isStoppable() {
        return this.isRunning() && this.getCache() != null;
    }

    public ServerState stop() {
        ServerLauncher launcher = ServerLauncher.getInstance();
        if (this.isStoppable()) {
            return this.stopInProcess();
        }
        if (this.isPidInProcess() && launcher != null) {
            return launcher.stopInProcess();
        }
        if (this.getPid() != null) {
            return this.stopWithPid();
        }
        if (this.getWorkingDirectory() != null) {
            return this.stopWithWorkingDirectory();
        }
        return new ServerState(this, AbstractLauncher.Status.NOT_RESPONDING);
    }

    private ServerState stopInProcess() {
        if (this.isStoppable()) {
            if (this.cache.isReconnecting()) {
                this.cache.getDistributedSystem().stopReconnecting();
            }
            LoggingThread t = new LoggingThread("ServerLauncherStopper", false, this::doStopInProcess);
            t.start();
            try {
                t.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            INSTANCE.compareAndSet(this, null);
            this.running.set(false);
            return new ServerState(this, AbstractLauncher.Status.STOPPED);
        }
        return new ServerState(this, AbstractLauncher.Status.NOT_RESPONDING);
    }

    private void doStopInProcess() {
        this.cache.close();
        this.cache = null;
        if (this.process != null) {
            this.process.stop(this.deletePidFileOnStop);
            this.process = null;
        }
    }

    private ServerState stopWithPid() {
        try {
            ProcessController controller = new ProcessControllerFactory().createProcessController(this.controllerParameters, this.getPid());
            controller.checkPidSupport();
            controller.stop();
            return new ServerState(this, AbstractLauncher.Status.STOPPED);
        }
        catch (ConnectionFailedException handled) {
            return this.createNoResponseState(handled, "Failed to connect to server with process id " + this.getPid());
        }
        catch (IOException | MBeanInvocationFailedException | UnableToControlProcessException handled) {
            return this.createNoResponseState(handled, "Failed to communicate with server with process id " + this.getPid());
        }
    }

    private ServerState stopWithWorkingDirectory() {
        int parsedPid = 0;
        try {
            ServerLauncher runningLauncher;
            ProcessController controller = new ProcessControllerFactory().createProcessController(this.controllerParameters, new File(this.getWorkingDirectory()), ProcessType.SERVER.getPidFileName());
            parsedPid = controller.getProcessId();
            if (parsedPid == this.identifyPid() && (runningLauncher = ServerLauncher.getInstance()) != null) {
                return runningLauncher.stopInProcess();
            }
            controller.stop();
            return new ServerState(this, AbstractLauncher.Status.STOPPED);
        }
        catch (ConnectionFailedException handled) {
            return this.createNoResponseState(handled, "Failed to connect to server with process id " + parsedPid);
        }
        catch (FileNotFoundException handled) {
            return this.createNoResponseState(handled, "Failed to find process file " + ProcessType.SERVER.getPidFileName() + " in " + this.getWorkingDirectory());
        }
        catch (IOException | MBeanInvocationFailedException | UnableToControlProcessException handled) {
            return this.createNoResponseState(handled, "Failed to communicate with server with process id " + parsedPid);
        }
        catch (InterruptedException handled) {
            Thread.currentThread().interrupt();
            return this.createNoResponseState(handled, "Interrupted while trying to communicate with server with process id " + parsedPid);
        }
        catch (PidUnavailableException handled) {
            return this.createNoResponseState(handled, "Failed to find usable process id within file " + ProcessType.SERVER.getPidFileName() + " in " + this.getWorkingDirectory());
        }
        catch (TimeoutException handled) {
            return this.createNoResponseState(handled, "Timed out trying to find usable process id within file " + ProcessType.SERVER.getPidFileName() + " in " + this.getWorkingDirectory());
        }
    }

    private ServerState createNoResponseState(Exception cause, String errorMessage) {
        this.debug(ExceptionUtils.getStackTrace((Throwable)cause) + errorMessage, new Object[0]);
        return new ServerState(this, AbstractLauncher.Status.NOT_RESPONDING, errorMessage);
    }

    private Properties getOverriddenDefaults() throws IOException {
        Properties overriddenDefaults = new Properties();
        overriddenDefaults.setProperty("gemfire.default.".concat("log-file"), this.getLogFile().getCanonicalPath());
        for (String key : System.getProperties().stringPropertyNames()) {
            if (!key.startsWith("gemfire.default.")) continue;
            overriddenDefaults.setProperty(key, System.getProperty(key));
        }
        return overriddenDefaults;
    }

    private ControllableProcess getControllableProcess() throws IOException, FileAlreadyExistsException, PidUnavailableException {
        return this.controllableProcessFactory != null ? this.controllableProcessFactory.get() : new FileControllableProcess(this.controlHandler, new File(this.getWorkingDirectory()), ProcessType.SERVER, this.isForcing());
    }

    static {
        HashMap<String, String> help = new HashMap<String, String>();
        help.put("launcher", "A GemFire launcher used to start, stop and determine a Server's status.");
        help.put(Command.START.getName(), String.format("Starts a Server running in the current working directory listening on the default port (%s) bound to all IP addresses available to the localhost.  The Server must be given a member name in the GemFire cluster.  The default server-bind-address and server-port may be overridden using the corresponding command-line options.", String.valueOf(ServerLauncher.getDefaultServerPort())));
        help.put(Command.STATUS.getName(), "Displays the status of a Server given any combination of the member name/ID, PID, or the directory in which the Server is running.");
        help.put(Command.STOP.getName(), "Stops a running Server given given a member name/ID, PID, or the directory in which the Server is running.");
        help.put(Command.VERSION.getName(), "Displays GemFire product version information.");
        help.put("assign-buckets", "Causes buckets to be assigned to the partitioned regions in the GemFire cache on Server start.");
        help.put("debug", "Displays verbose information during the invocation of the launcher.");
        help.put("delete-pid-file-on-stop", "Specifies that this Server's PID file should be deleted on stop.  The default is to not delete this Server's PID file until JVM exit if --delete-pid-file-on-stop is not specified.");
        help.put("dir", "Specifies the working directory where the Server is running.  Defaults to the current working directory.");
        help.put("disable-default-server", "Disables the addition of a default GemFire cache server.");
        help.put("force", "Enables any existing Server PID file to be overwritten on start.  The default is to throw an error if a PID file already exists and --force is not specified.");
        help.put("help", "Causes GemFire to print out information instead of performing the command. This option is supported by all commands.");
        help.put("member", "Identifies the Server by member name or ID in the GemFire cluster.");
        help.put("pid", "Indicates the OS process ID of the running Server.");
        help.put("rebalance", "An option to cause the GemFire cache's partitioned regions to be rebalanced on start.");
        help.put("redirect-output", "An option to cause the Server to redirect standard out and standard error to the GemFire log file.");
        help.put("server-bind-address", "Specifies the IP address on which to bind, or on which the Server is bound, listening for client requests.  Defaults to all IP addresses available to the localhost.");
        help.put("hostname-for-clients", "An option to specify the hostname or IP address to send to clients so they can connect to this Server. The default is to use the IP address to which the Server is bound.");
        help.put("server-port", String.format("Specifies the port on which the Server is listening for client requests. Defaults to %s.", String.valueOf(ServerLauncher.getDefaultServerPort())));
        helpMap = Collections.unmodifiableMap(help);
        TreeMap<Command, String> usage = new TreeMap<Command, String>();
        usage.put(Command.START, "start <member-name> [--assign-buckets] [--disable-default-server] [--rebalance] [--server-bind-address=<IP-address>] [--server-port=<port>] [--force] [--debug] [--help]");
        usage.put(Command.STATUS, "status [--member=<member-ID/Name>] [--pid=<process-ID>] [--dir=<Server-working-directory>] [--debug] [--help]");
        usage.put(Command.STOP, "stop [--member=<member-ID/Name>] [--pid=<process-ID>] [--dir=<Server-working-directory>] [--debug] [--help]");
        usage.put(Command.VERSION, "version");
        usageMap = Collections.unmodifiableMap(usage);
        INSTANCE = new AtomicReference();
        DEFAULT_CACHE_PROVIDER = new DefaultServerLauncherCacheProvider();
        logger = LogService.getLogger();
        TWO_NEW_LINES = System.lineSeparator() + System.lineSeparator();
    }

    public static class ServerState
    extends AbstractLauncher.ServiceState<String> {
        public static ServerState fromJson(String json) {
            try {
                JsonNode jsonObject = new ObjectMapper().readTree(json);
                AbstractLauncher.Status status = AbstractLauncher.Status.valueOfDescription(jsonObject.get("status").asText());
                List<String> jvmArguments = JsonUtil.toStringList(jsonObject.get("jvmArguments"));
                return new ServerState(status, jsonObject.get("statusMessage").asText(), jsonObject.get("timestamp").asLong(), jsonObject.get("location").asText(), jsonObject.get("pid").asInt(), jsonObject.get("uptime").asLong(), jsonObject.get("workingDirectory").asText(), jvmArguments, jsonObject.get("classpath").asText(), jsonObject.get("gemFireVersion").asText(), jsonObject.get("javaVersion").asText(), jsonObject.get("logFileName").asText(), jsonObject.get("bindAddress").asText(), jsonObject.get("port").asText(), jsonObject.get("memberName").asText());
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unable to create ServerStatus from JSON: " + json, e);
            }
        }

        public static ServerState fromDirectory(String workingDirectory, String memberName) {
            ServerState serverState = new Builder().setWorkingDirectory(workingDirectory).setDisableDefaultServer(true).build().status();
            if (ObjectUtils.equals(serverState.getMemberName(), memberName)) {
                return serverState;
            }
            return new ServerState(new Builder().build(), AbstractLauncher.Status.NOT_RESPONDING);
        }

        public ServerState(ServerLauncher launcher, AbstractLauncher.Status status) {
            this(status, launcher.statusMessage, System.currentTimeMillis(), launcher.getId(), ServerState.identifyPid(), ManagementFactory.getRuntimeMXBean().getUptime(), launcher.getWorkingDirectory(), ManagementFactory.getRuntimeMXBean().getInputArguments(), System.getProperty("java.class.path"), GemFireVersion.getGemFireVersion(), System.getProperty("java.version"), ServerState.getServerLogFileCanonicalPath(launcher), ServerState.getServerBindAddressAsString(launcher), ServerState.getServerPortAsString(launcher), launcher.getMemberName());
        }

        public ServerState(ServerLauncher launcher, AbstractLauncher.Status status, String errorMessage) {
            this(status, errorMessage, System.currentTimeMillis(), ServerState.getServerLocation(launcher), null, 0L, launcher.getWorkingDirectory(), ManagementFactory.getRuntimeMXBean().getInputArguments(), null, GemFireVersion.getGemFireVersion(), System.getProperty("java.version"), null, ServerState.getServerBindAddressAsString(launcher), launcher.getServerPortAsString(), null);
        }

        private static String getServerLocation(ServerLauncher launcher) {
            if (launcher.getServerPort() == null) {
                return launcher.getId();
            }
            if (launcher.getServerBindAddress() == null) {
                return HostUtils.getLocatorId(HostUtils.getLocalHost(), launcher.getServerPort());
            }
            return HostUtils.getServerId(launcher.getServerBindAddress().getCanonicalHostName(), launcher.getServerPort());
        }

        protected ServerState(AbstractLauncher.Status status, String statusMessage, long timestamp, String serverLocation, Integer pid, Long uptime, String workingDirectory, List<String> jvmArguments, String classpath, String gemfireVersion, String javaVersion, String logFile, String host, String port, String memberName) {
            super(status, statusMessage, timestamp, serverLocation, pid, uptime, workingDirectory, jvmArguments, classpath, gemfireVersion, javaVersion, logFile, host, port, memberName);
        }

        private static String getServerLogFileCanonicalPath(ServerLauncher launcher) {
            String logFileCanonicalPath;
            File logFile;
            InternalDistributedSystem system = InternalDistributedSystem.getAnyInstance();
            if (system != null && (logFile = system.getConfig().getLogFile()) != null && logFile.isFile() && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(logFileCanonicalPath = IOUtils.tryGetCanonicalPathElseGetAbsolutePath(logFile)))) {
                return logFileCanonicalPath;
            }
            return launcher.getLogFileCanonicalPath();
        }

        private static String getServerBindAddressAsString(ServerLauncher launcher) {
            CacheServer cs;
            String serverBindAddressAsString;
            List<CacheServer> csList;
            GemFireCacheImpl internalCache = GemFireCacheImpl.getInstance();
            if (internalCache != null && (csList = internalCache.getCacheServers()) != null && !csList.isEmpty() && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(serverBindAddressAsString = (cs = csList.get(0)).getBindAddress()))) {
                return serverBindAddressAsString;
            }
            return launcher.getServerBindAddressAsString();
        }

        private static String getServerPortAsString(ServerLauncher launcher) {
            CacheServer cs;
            String portAsString;
            List<CacheServer> csList;
            GemFireCacheImpl internalCache = GemFireCacheImpl.getInstance();
            if (internalCache != null && (csList = internalCache.getCacheServers()) != null && !csList.isEmpty() && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(portAsString = String.valueOf((cs = csList.get(0)).getPort())))) {
                return portAsString;
            }
            return launcher.isDisableDefaultServer() ? "" : launcher.getServerPortAsString();
        }

        @Override
        protected String getServiceName() {
            return ServerLauncher.SERVER_SERVICE_NAME;
        }
    }

    public static final class Command
    extends Enum<Command> {
        public static final /* enum */ Command START = new Command("start", "assign-buckets", "disable-default-server", "rebalance", "server-bind-address", "server-port", "force", "debug", "help");
        public static final /* enum */ Command STATUS = new Command("status", "member", "pid", "dir", "debug", "help");
        public static final /* enum */ Command STOP = new Command("stop", "member", "pid", "dir", "debug", "help");
        public static final /* enum */ Command UNSPECIFIED = new Command("unspecified", new String[0]);
        public static final /* enum */ Command VERSION = new Command("version", new String[0]);
        private final List<String> options;
        private final String name;
        private static final /* synthetic */ Command[] $VALUES;

        public static Command[] values() {
            return (Command[])$VALUES.clone();
        }

        public static Command valueOf(String name) {
            return Enum.valueOf(Command.class, name);
        }

        private Command(String name, String ... options) {
            assert (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)name)) : "The name of the command must be specified!";
            this.name = name;
            this.options = options != null ? Collections.unmodifiableList(Arrays.asList(options)) : Collections.emptyList();
        }

        public static boolean isCommand(String name) {
            return Command.valueOfName(name) != null;
        }

        public static boolean isUnspecified(Command command) {
            return command == null || command.isUnspecified();
        }

        public static Command valueOfName(String name) {
            for (Command command : Command.values()) {
                if (!command.getName().equalsIgnoreCase(name)) continue;
                return command;
            }
            return null;
        }

        public String getName() {
            return this.name;
        }

        public List<String> getOptions() {
            return this.options;
        }

        public boolean hasOption(String option) {
            return this.getOptions().contains(org.apache.commons.lang3.StringUtils.lowerCase((String)option));
        }

        public boolean isUnspecified() {
            return this == UNSPECIFIED;
        }

        public String toString() {
            return this.getName();
        }

        static {
            $VALUES = new Command[]{START, STATUS, STOP, UNSPECIFIED, VERSION};
        }
    }

    public static class Builder {
        @Immutable
        protected static final Command DEFAULT_COMMAND = Command.UNSPECIFIED;
        private boolean serverBindAddressSetByUser;
        private boolean serverPortSetByUser;
        private Boolean assignBuckets;
        private Boolean debug;
        private Boolean deletePidFileOnStop;
        private Boolean disableDefaultServer;
        private Boolean force;
        private Boolean help;
        private Boolean rebalance;
        private Boolean redirectOutput;
        private Cache cache;
        private final CacheConfig cacheConfig = new CacheConfig();
        private Command command;
        private InetAddress serverBindAddress;
        private Integer pid;
        private Integer serverPort;
        private final Properties distributedSystemProperties = new Properties();
        private String memberName;
        private String springXmlLocation;
        private String workingDirectory;
        private Float criticalHeapPercentage;
        private Float evictionHeapPercentage;
        private Float criticalOffHeapPercentage;
        private Float evictionOffHeapPercentage;
        private String hostNameForClients;
        private Integer loadPollInterval;
        private Integer maxConnections;
        private Integer maxMessageCount;
        private Integer messageTimeToLive;
        private Integer socketBufferSize;
        private Integer maxThreads;
        private Runnable startupCompletionAction;
        private Consumer<Throwable> startupExceptionAction;
        private ServerLauncherCacheProvider serverLauncherCacheProvider;
        private Supplier<ControllableProcess> controllableProcessFactory;

        public Builder() {
        }

        public Builder(String ... args) {
            this.parseArguments(args != null ? args : new String[]{});
        }

        private OptionParser getParser() {
            OptionParser parser = new OptionParser(true);
            parser.accepts("assign-buckets");
            parser.accepts("debug");
            parser.accepts("dir").withRequiredArg().ofType(String.class);
            parser.accepts("disable-default-server");
            parser.accepts("force");
            parser.accepts("help");
            parser.accepts("member").withRequiredArg().ofType(String.class);
            parser.accepts("pid").withRequiredArg().ofType(Integer.class);
            parser.accepts("rebalance");
            parser.accepts("redirect-output");
            parser.accepts("server-bind-address").withRequiredArg().ofType(String.class);
            parser.accepts("server-port").withRequiredArg().ofType(Integer.class);
            parser.accepts("spring-xml-location").withRequiredArg().ofType(String.class);
            parser.accepts("version");
            parser.accepts("critical-heap-percentage").withRequiredArg().ofType(Float.class);
            parser.accepts("eviction-heap-percentage").withRequiredArg().ofType(Float.class);
            parser.accepts("critical-off-heap-percentage").withRequiredArg().ofType(Float.class);
            parser.accepts("eviction-off-heap-percentage").withRequiredArg().ofType(Float.class);
            parser.accepts("max-connections").withRequiredArg().ofType(Integer.class);
            parser.accepts("max-message-count").withRequiredArg().ofType(Integer.class);
            parser.accepts("max-threads").withRequiredArg().ofType(Integer.class);
            parser.accepts("message-time-to-live").withRequiredArg().ofType(Integer.class);
            parser.accepts("socket-buffer-size").withRequiredArg().ofType(Integer.class);
            parser.accepts("hostname-for-clients").withRequiredArg().ofType(String.class);
            return parser;
        }

        void parseArguments(String ... args) {
            try {
                OptionSet options = this.getParser().parse(args);
                this.parseCommand(args);
                this.parseMemberName(args);
                this.setAssignBuckets(options.has("assign-buckets"));
                this.setDebug(options.has("debug"));
                this.setDeletePidFileOnStop(options.has("delete-pid-file-on-stop"));
                this.setDisableDefaultServer(options.has("disable-default-server"));
                this.setForce(options.has("force"));
                this.setHelp(options.has("help"));
                this.setRebalance(options.has("rebalance"));
                this.setRedirectOutput(options.has("redirect-output"));
                if (options.hasArgument("critical-heap-percentage")) {
                    this.setCriticalHeapPercentage(Float.valueOf(Float.parseFloat(ObjectUtils.toString(options.valueOf("critical-heap-percentage")))));
                }
                if (options.hasArgument("eviction-heap-percentage")) {
                    this.setEvictionHeapPercentage(Float.valueOf(Float.parseFloat(ObjectUtils.toString(options.valueOf("eviction-heap-percentage")))));
                }
                if (options.hasArgument("critical-off-heap-percentage")) {
                    this.setCriticalOffHeapPercentage(Float.valueOf(Float.parseFloat(ObjectUtils.toString(options.valueOf("critical-off-heap-percentage")))));
                }
                if (options.hasArgument("eviction-off-heap-percentage")) {
                    this.setEvictionOffHeapPercentage(Float.valueOf(Float.parseFloat(ObjectUtils.toString(options.valueOf("eviction-off-heap-percentage")))));
                }
                if (options.hasArgument("max-connections")) {
                    this.setMaxConnections(Integer.parseInt(ObjectUtils.toString(options.valueOf("max-connections"))));
                }
                if (options.hasArgument("max-message-count")) {
                    this.setMaxMessageCount(Integer.parseInt(ObjectUtils.toString(options.valueOf("max-message-count"))));
                }
                if (options.hasArgument("message-time-to-live")) {
                    this.setMessageTimeToLive(Integer.parseInt(ObjectUtils.toString(options.valueOf("message-time-to-live"))));
                }
                if (options.hasArgument("socket-buffer-size")) {
                    this.setSocketBufferSize(Integer.parseInt(ObjectUtils.toString(options.valueOf("socket-buffer-size"))));
                }
                if (options.hasArgument("max-threads")) {
                    this.setMaxThreads(Integer.parseInt(ObjectUtils.toString(options.valueOf("max-threads"))));
                }
                if (!this.isHelping()) {
                    if (options.has("dir")) {
                        this.setWorkingDirectory(ObjectUtils.toString(options.valueOf("dir")));
                    }
                    if (options.has("pid")) {
                        this.setPid((Integer)options.valueOf("pid"));
                    }
                    if (options.has("server-bind-address")) {
                        this.setServerBindAddress(ObjectUtils.toString(options.valueOf("server-bind-address")));
                    }
                    if (options.has("server-port")) {
                        this.setServerPort((Integer)options.valueOf("server-port"));
                    }
                    if (options.has("spring-xml-location")) {
                        this.setSpringXmlLocation(ObjectUtils.toString(options.valueOf("spring-xml-location")));
                    }
                    if (options.has("version")) {
                        this.setCommand(Command.VERSION);
                    }
                }
                if (options.hasArgument("critical-heap-percentage")) {
                    this.setCriticalHeapPercentage(Float.valueOf(Float.parseFloat(ObjectUtils.toString(options.valueOf("critical-heap-percentage")))));
                }
                if (options.hasArgument("eviction-heap-percentage")) {
                    this.setEvictionHeapPercentage(Float.valueOf(Float.parseFloat(ObjectUtils.toString(options.valueOf("eviction-heap-percentage")))));
                }
                if (options.hasArgument("max-connections")) {
                    this.setMaxConnections(Integer.parseInt(ObjectUtils.toString(options.valueOf("max-connections"))));
                }
                if (options.hasArgument("max-message-count")) {
                    this.setMaxMessageCount(Integer.parseInt(ObjectUtils.toString(options.valueOf("max-message-count"))));
                }
                if (options.hasArgument("max-threads")) {
                    this.setMaxThreads(Integer.parseInt(ObjectUtils.toString(options.valueOf("max-threads"))));
                }
                if (options.hasArgument("message-time-to-live")) {
                    this.setMessageTimeToLive(Integer.parseInt(ObjectUtils.toString(options.valueOf("message-time-to-live"))));
                }
                if (options.hasArgument("socket-buffer-size")) {
                    this.setSocketBufferSize(Integer.parseInt(ObjectUtils.toString(options.valueOf("socket-buffer-size"))));
                }
                if (options.hasArgument("hostname-for-clients")) {
                    this.setHostNameForClients(ObjectUtils.toString(options.valueOf("hostname-for-clients")));
                }
            }
            catch (OptionException e) {
                throw new IllegalArgumentException(String.format("An error occurred while parsing command-line arguments for the %s: %s", ServerLauncher.SERVER_SERVICE_NAME, e.getMessage()), e);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }

        protected void parseCommand(String ... args) {
            if (args != null) {
                for (String arg : args) {
                    Command command = Command.valueOfName(arg);
                    if (command == null) continue;
                    this.setCommand(command);
                    break;
                }
            }
        }

        protected void parseMemberName(String ... args) {
            if (args != null) {
                for (String arg : args) {
                    if (arg.startsWith("-") || Command.isCommand(arg)) continue;
                    this.setMemberName(arg);
                    break;
                }
            }
        }

        CacheConfig getCacheConfig() {
            return this.cacheConfig;
        }

        public Command getCommand() {
            return this.command != null ? this.command : DEFAULT_COMMAND;
        }

        public Builder setCommand(Command command) {
            this.command = command;
            return this;
        }

        public Boolean getAssignBuckets() {
            return this.assignBuckets;
        }

        public Builder setAssignBuckets(Boolean assignBuckets) {
            this.assignBuckets = assignBuckets;
            return this;
        }

        @VisibleForTesting
        Cache getCache() {
            return this.cache;
        }

        @VisibleForTesting
        Builder setCache(Cache cache) {
            this.cache = cache;
            return this;
        }

        public Boolean getDebug() {
            return this.debug;
        }

        public Builder setDebug(Boolean debug) {
            this.debug = debug;
            return this;
        }

        public Boolean getDeletePidFileOnStop() {
            return this.deletePidFileOnStop;
        }

        public Builder setDeletePidFileOnStop(Boolean deletePidFileOnStop) {
            this.deletePidFileOnStop = deletePidFileOnStop;
            return this;
        }

        public Boolean getDisableDefaultServer() {
            return this.disableDefaultServer;
        }

        public Builder setDisableDefaultServer(Boolean disableDefaultServer) {
            this.disableDefaultServer = disableDefaultServer;
            return this;
        }

        public Properties getDistributedSystemProperties() {
            return this.distributedSystemProperties;
        }

        public Boolean getForce() {
            return this.force != null ? this.force : AbstractLauncher.DEFAULT_FORCE;
        }

        public Builder setForce(Boolean force) {
            this.force = force;
            return this;
        }

        public Boolean getHelp() {
            return this.help;
        }

        protected boolean isHelping() {
            return Boolean.TRUE.equals(this.getHelp());
        }

        public Builder setHelp(Boolean help) {
            this.help = help;
            return this;
        }

        public Boolean getRebalance() {
            return this.rebalance;
        }

        public Builder setRebalance(Boolean rebalance) {
            this.rebalance = rebalance;
            return this;
        }

        public String getMemberName() {
            return this.memberName;
        }

        public Builder setMemberName(String memberName) {
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)memberName)) {
                throw new IllegalArgumentException("The Server member name must be specified.");
            }
            this.memberName = memberName;
            return this;
        }

        public Integer getPid() {
            return this.pid;
        }

        public Builder setPid(Integer pid) {
            if (pid != null && pid < 0) {
                throw new IllegalArgumentException("A process ID (PID) must be a non-negative integer value.");
            }
            this.pid = pid;
            return this;
        }

        public Boolean getRedirectOutput() {
            return this.redirectOutput;
        }

        private boolean isRedirectingOutput() {
            return Boolean.TRUE.equals(this.getRedirectOutput());
        }

        public Builder setRedirectOutput(Boolean redirectOutput) {
            this.redirectOutput = redirectOutput;
            return this;
        }

        public InetAddress getServerBindAddress() {
            return this.serverBindAddress;
        }

        boolean isServerBindAddressSetByUser() {
            return this.serverBindAddressSetByUser;
        }

        public Builder setServerBindAddress(String serverBindAddress) {
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)serverBindAddress)) {
                this.serverBindAddress = null;
                return this;
            }
            try {
                InetAddress bindAddress = InetAddress.getByName(serverBindAddress);
                if (LocalHostUtil.isLocalHost((Object)bindAddress)) {
                    this.serverBindAddress = bindAddress;
                    this.serverBindAddressSetByUser = true;
                    return this;
                }
                throw new IllegalArgumentException(serverBindAddress + " is not an address for this machine.");
            }
            catch (UnknownHostException e) {
                throw new IllegalArgumentException(String.format("The hostname/IP address to which the %s will be bound is unknown.", ServerLauncher.SERVER_SERVICE_NAME), e);
            }
        }

        public Integer getServerPort() {
            return this.serverPort != null ? this.serverPort : ServerLauncher.getDefaultServerPort();
        }

        boolean isServerPortSetByUser() {
            return this.serverPortSetByUser;
        }

        public Builder setServerPort(Integer serverPort) {
            if (serverPort == null) {
                this.serverPort = null;
                this.serverPortSetByUser = false;
                return this;
            }
            if (serverPort < 0 || serverPort > 65535) {
                throw new IllegalArgumentException("The port on which the Server will listen must be between 1 and 65535 inclusive.");
            }
            if (serverPort == 0) {
                this.serverPort = 0;
                this.serverPortSetByUser = false;
            } else {
                this.serverPort = serverPort;
                this.serverPortSetByUser = true;
            }
            return this;
        }

        public String getSpringXmlLocation() {
            return this.springXmlLocation;
        }

        public Builder setSpringXmlLocation(String springXmlLocation) {
            this.springXmlLocation = springXmlLocation;
            return this;
        }

        public String getWorkingDirectory() {
            return IOUtils.tryGetCanonicalPathElseGetAbsolutePath(new File((String)org.apache.commons.lang3.StringUtils.defaultIfBlank((CharSequence)this.workingDirectory, (CharSequence)AbstractLauncher.DEFAULT_WORKING_DIRECTORY)));
        }

        public Builder setWorkingDirectory(String workingDirectory) {
            if (!new File((String)org.apache.commons.lang3.StringUtils.defaultIfBlank((CharSequence)workingDirectory, (CharSequence)AbstractLauncher.DEFAULT_WORKING_DIRECTORY)).isDirectory()) {
                throw new IllegalArgumentException(String.format("The working directory for the %s could not be found.", ServerLauncher.SERVER_SERVICE_NAME), new FileNotFoundException(workingDirectory));
            }
            this.workingDirectory = workingDirectory;
            return this;
        }

        public Float getCriticalHeapPercentage() {
            return this.criticalHeapPercentage;
        }

        public Builder setCriticalHeapPercentage(Float criticalHeapPercentage) {
            if (criticalHeapPercentage != null && (criticalHeapPercentage.floatValue() < 0.0f || criticalHeapPercentage.floatValue() > 100.0f)) {
                throw new IllegalArgumentException(String.format("Critical heap percentage (%1$s) must be between 0 and 100!", criticalHeapPercentage));
            }
            this.criticalHeapPercentage = criticalHeapPercentage;
            return this;
        }

        public Float getCriticalOffHeapPercentage() {
            return this.criticalOffHeapPercentage;
        }

        public Builder setCriticalOffHeapPercentage(Float criticalOffHeapPercentage) {
            if (criticalOffHeapPercentage != null && (criticalOffHeapPercentage.floatValue() < 0.0f || criticalOffHeapPercentage.floatValue() > 100.0f)) {
                throw new IllegalArgumentException(String.format("Critical off-heap percentage (%1$s) must be between 0 and 100!", criticalOffHeapPercentage));
            }
            this.criticalOffHeapPercentage = criticalOffHeapPercentage;
            return this;
        }

        public Float getEvictionHeapPercentage() {
            return this.evictionHeapPercentage;
        }

        public Builder setEvictionHeapPercentage(Float evictionHeapPercentage) {
            if (evictionHeapPercentage != null && (evictionHeapPercentage.floatValue() < 0.0f || evictionHeapPercentage.floatValue() > 100.0f)) {
                throw new IllegalArgumentException(String.format("Eviction heap percentage (%1$s) must be between 0 and 100!", evictionHeapPercentage));
            }
            this.evictionHeapPercentage = evictionHeapPercentage;
            return this;
        }

        public Float getEvictionOffHeapPercentage() {
            return this.evictionOffHeapPercentage;
        }

        public Builder setEvictionOffHeapPercentage(Float evictionOffHeapPercentage) {
            if (evictionOffHeapPercentage != null && (evictionOffHeapPercentage.floatValue() < 0.0f || evictionOffHeapPercentage.floatValue() > 100.0f)) {
                throw new IllegalArgumentException(String.format("Eviction off-heap percentage (%1$s) must be between 0 and 100", evictionOffHeapPercentage));
            }
            this.evictionOffHeapPercentage = evictionOffHeapPercentage;
            return this;
        }

        public String getHostNameForClients() {
            return this.hostNameForClients;
        }

        public Builder setHostNameForClients(String hostNameForClients) {
            if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)hostNameForClients)) {
                throw new IllegalArgumentException("The hostname used by clients to connect to the Server must have an argument if the --hostname-for-clients command-line option is specified!");
            }
            this.hostNameForClients = hostNameForClients;
            return this;
        }

        public Integer getMaxConnections() {
            return this.maxConnections;
        }

        public Builder setMaxConnections(Integer maxConnections) {
            if (maxConnections != null && maxConnections < 1) {
                throw new IllegalArgumentException(String.format("Max Connections (%1$s) must be greater than 0!", maxConnections));
            }
            this.maxConnections = maxConnections;
            return this;
        }

        public Integer getMaxMessageCount() {
            return this.maxMessageCount;
        }

        public Builder setMaxMessageCount(Integer maxMessageCount) {
            if (maxMessageCount != null && maxMessageCount < 1) {
                throw new IllegalArgumentException(String.format("Max Message Count (%1$s) must be greater than 0!", maxMessageCount));
            }
            this.maxMessageCount = maxMessageCount;
            return this;
        }

        public Integer getMaxThreads() {
            return this.maxThreads;
        }

        public Builder setMaxThreads(Integer maxThreads) {
            if (maxThreads != null && maxThreads < 1) {
                throw new IllegalArgumentException(String.format("Max Threads (%1$s) must be greater than 0!", maxThreads));
            }
            this.maxThreads = maxThreads;
            return this;
        }

        public Integer getMessageTimeToLive() {
            return this.messageTimeToLive;
        }

        public Builder setMessageTimeToLive(Integer messageTimeToLive) {
            if (messageTimeToLive != null && messageTimeToLive < 1) {
                throw new IllegalArgumentException(String.format("Message Time To Live (%1$s) must be greater than 0!", messageTimeToLive));
            }
            this.messageTimeToLive = messageTimeToLive;
            return this;
        }

        public Integer getSocketBufferSize() {
            return this.socketBufferSize;
        }

        public Builder setSocketBufferSize(Integer socketBufferSize) {
            if (socketBufferSize != null && socketBufferSize < 1) {
                throw new IllegalArgumentException(String.format("The Server's Socket Buffer Size (%1$s) must be greater than 0!", socketBufferSize));
            }
            this.socketBufferSize = socketBufferSize;
            return this;
        }

        public Builder set(String propertyName, String propertyValue) {
            this.distributedSystemProperties.setProperty(propertyName, propertyValue);
            return this;
        }

        public Builder set(Properties properties) {
            this.distributedSystemProperties.putAll((Map<?, ?>)properties);
            return this;
        }

        public Builder setPdxPersistent(boolean persistent) {
            this.cacheConfig.setPdxPersistent(persistent);
            return this;
        }

        public Builder setPdxDiskStore(String pdxDiskStore) {
            this.cacheConfig.setPdxDiskStore(pdxDiskStore);
            return this;
        }

        public Builder setPdxIgnoreUnreadFields(boolean ignore) {
            this.cacheConfig.setPdxIgnoreUnreadFields(ignore);
            return this;
        }

        public Builder setPdxReadSerialized(boolean readSerialized) {
            this.cacheConfig.setPdxReadSerialized(readSerialized);
            return this;
        }

        public Builder setPdxSerializer(PdxSerializer pdxSerializer) {
            this.cacheConfig.setPdxSerializer(pdxSerializer);
            return this;
        }

        protected void validate() {
            if (!this.isHelping()) {
                this.validateOnStart();
                this.validateOnStatus();
                this.validateOnStop();
            }
        }

        void validateOnStart() {
            if (Command.START == this.getCommand()) {
                if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)this.getMemberName()) && !AbstractLauncher.isSet(System.getProperties(), "gemfire.name") && !AbstractLauncher.isSet(this.getDistributedSystemProperties(), "name") && !AbstractLauncher.isSet(AbstractLauncher.loadGemFireProperties(DistributedSystem.getPropertyFileURL()), "name")) {
                    throw new IllegalStateException(String.format("The member name of the %s must be provided as an argument to the launcher, or a path to gemfire.properties must be specified, which assumes the %s member name will be set using the name property.", ServerLauncher.SERVER_SERVICE_NAME, ServerLauncher.SERVER_SERVICE_NAME));
                }
                if (!SystemUtils.CURRENT_DIRECTORY.equalsIgnoreCase(this.getWorkingDirectory())) {
                    throw new IllegalStateException(String.format("Specifying the --dir option is not valid when starting a %s with the %sLauncher.", ServerLauncher.SERVER_SERVICE_NAME, ServerLauncher.SERVER_SERVICE_NAME));
                }
            }
        }

        void validateOnStatus() {
            if (Command.STATUS == this.getCommand()) {
                // empty if block
            }
        }

        void validateOnStop() {
            if (Command.STOP == this.getCommand()) {
                // empty if block
            }
        }

        public ServerLauncher build() {
            this.validate();
            return new ServerLauncher(this);
        }

        Builder setStartupCompletionAction(Runnable startupCompletionAction) {
            this.startupCompletionAction = startupCompletionAction;
            return this;
        }

        Runnable getStartupCompletionAction() {
            return this.startupCompletionAction;
        }

        Builder setStartupExceptionAction(Consumer<Throwable> startupExceptionAction) {
            this.startupExceptionAction = startupExceptionAction;
            return this;
        }

        Consumer<Throwable> getStartupExceptionAction() {
            return this.startupExceptionAction;
        }

        Builder setServerLauncherCacheProvider(ServerLauncherCacheProvider serverLauncherCacheProvider) {
            this.serverLauncherCacheProvider = serverLauncherCacheProvider;
            return this;
        }

        ServerLauncherCacheProvider getServerLauncherCacheProvider() {
            return this.serverLauncherCacheProvider;
        }

        Builder setControllableProcessFactory(Supplier<ControllableProcess> controllableProcessFactory) {
            this.controllableProcessFactory = controllableProcessFactory;
            return this;
        }

        Supplier<ControllableProcess> getControllableProcessFactory() {
            return this.controllableProcessFactory;
        }
    }

    private class ServerControllerParameters
    implements ProcessControllerParameters {
        private ServerControllerParameters() {
        }

        @Override
        public File getPidFile() {
            return ServerLauncher.this.getServerPidFile();
        }

        @Override
        public File getDirectory() {
            return new File(ServerLauncher.this.getWorkingDirectory());
        }

        @Override
        public int getProcessId() {
            return ServerLauncher.this.getPid();
        }

        @Override
        public ProcessType getProcessType() {
            return ProcessType.SERVER;
        }

        @Override
        public ObjectName getNamePattern() {
            try {
                return ObjectName.getInstance("GemFire:type=Member,*");
            }
            catch (NullPointerException | MalformedObjectNameException handled) {
                return null;
            }
        }

        @Override
        public String getPidAttribute() {
            return "ProcessId";
        }

        @Override
        public String getStopMethod() {
            return "shutDownMember";
        }

        @Override
        public String getStatusMethod() {
            return "status";
        }

        @Override
        public String[] getAttributes() {
            return new String[]{ServerLauncher.SERVER_SERVICE_NAME};
        }

        @Override
        public Object[] getValues() {
            return new Object[]{Boolean.TRUE};
        }
    }
}

