/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.cache.query.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.geode.cache.query.FunctionDomainException;
import org.apache.geode.cache.query.NameResolutionException;
import org.apache.geode.cache.query.QueryInvocationTargetException;
import org.apache.geode.cache.query.TypeMismatchException;
import org.apache.geode.cache.query.internal.AbstractGroupOrRangeJunction;
import org.apache.geode.cache.query.internal.CompiledValue;
import org.apache.geode.cache.query.internal.ExecutionContext;
import org.apache.geode.cache.query.internal.Filter;
import org.apache.geode.cache.query.internal.OrganizedOperands;
import org.apache.geode.cache.query.internal.PlanInfo;
import org.apache.geode.cache.query.internal.QueryExecutionContext;
import org.apache.geode.cache.query.internal.RuntimeIterator;
import org.apache.geode.cache.query.internal.Support;

public class GroupJunction
extends AbstractGroupOrRangeJunction {
    private List unevaluatedFilterOperands = null;

    GroupJunction(int operator, RuntimeIterator[] indpndntItr, boolean isCompleteExpansion, CompiledValue[] operands) {
        super(operator, indpndntItr, isCompleteExpansion, operands);
    }

    @Override
    void addUnevaluatedFilterOperands(List unevaluatedFilterOps) {
        this.unevaluatedFilterOperands = unevaluatedFilterOps;
    }

    List getUnevaluatedFilterOperands() {
        return this.unevaluatedFilterOperands;
    }

    private GroupJunction(AbstractGroupOrRangeJunction oldGJ, boolean completeExpansion, RuntimeIterator[] indpnds, CompiledValue iterOp) {
        super(oldGJ, completeExpansion, indpnds, iterOp);
    }

    @Override
    AbstractGroupOrRangeJunction recreateFromOld(boolean completeExpansion, RuntimeIterator[] indpnds, CompiledValue iterOp) {
        return new GroupJunction(this, completeExpansion, indpnds, iterOp);
    }

    @Override
    AbstractGroupOrRangeJunction createNewOfSameType(int operator, RuntimeIterator[] indpndntItr, boolean isCompleteExpansion, CompiledValue[] operands) {
        return new GroupJunction(operator, indpndntItr, isCompleteExpansion, operands);
    }

    @Override
    OrganizedOperands organizeOperands(ExecutionContext context) throws FunctionDomainException, TypeMismatchException, NameResolutionException, QueryInvocationTargetException {
        ArrayList<Object> evalOperands = new ArrayList<Object>(this._operands.length);
        int indexCount = 0;
        boolean foundPreferredCondition = false;
        if (this.getOperator() == 91) {
            if (context instanceof QueryExecutionContext && ((QueryExecutionContext)context).hasHints() && ((QueryExecutionContext)context).hasMultiHints()) {
                for (CompiledValue operand : this._operands) {
                    if (operand.getPlanInfo((ExecutionContext)context).evalAsFilter) {
                        ++indexCount;
                        evalOperands.add(0, operand);
                        continue;
                    }
                    evalOperands.add(operand);
                }
            } else {
                Filter currentBestFilter = null;
                int currentBestFilterSize = -1;
                indexCount = 1;
                for (CompiledValue operand : this._operands) {
                    PlanInfo pi = operand.getPlanInfo(context);
                    if (pi.evalAsFilter && pi.indexes.size() == 1) {
                        if (pi.isPreferred) {
                            if (currentBestFilter != null) {
                                evalOperands.add(currentBestFilter);
                            }
                            currentBestFilter = (Filter)((Object)operand);
                            currentBestFilterSize = ((Filter)((Object)operand)).getSizeEstimate(context);
                            foundPreferredCondition = true;
                            continue;
                        }
                        if (currentBestFilter == null) {
                            currentBestFilter = (Filter)((Object)operand);
                            currentBestFilterSize = ((Filter)((Object)operand)).getSizeEstimate(context);
                            continue;
                        }
                        if (foundPreferredCondition || currentBestFilter.isBetterFilter((Filter)((Object)operand), context, currentBestFilterSize)) {
                            evalOperands.add(operand);
                            continue;
                        }
                        evalOperands.add(currentBestFilter);
                        currentBestFilter = (Filter)((Object)operand);
                        currentBestFilterSize = ((Filter)((Object)operand)).getSizeEstimate(context);
                        continue;
                    }
                    if (!operand.isDependentOnCurrentScope(context)) {
                        Support.assertionFailed("An independentoperand should not ever be present as operand inside a GroupJunction as it should always be present only in CompiledJunction");
                        continue;
                    }
                    if (pi.indexes.size() > 1) {
                        evalOperands.add(0, operand);
                        continue;
                    }
                    evalOperands.add(operand);
                }
                if (currentBestFilter != null) {
                    evalOperands.add(0, currentBestFilter);
                }
            }
        } else {
            indexCount = this._operands.length;
            evalOperands.addAll(Arrays.asList(this._operands).subList(0, indexCount));
        }
        if (this.getIterOperands() != null) {
            evalOperands.add(this.getIterOperands());
        }
        return this.createOrganizedOperandsObject(indexCount, evalOperands);
    }

    @Override
    public int getSizeEstimate(ExecutionContext context) {
        return 1;
    }
}

