/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.protocol.protobuf.v1.state;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import org.apache.geode.internal.cache.tier.CommunicationMode;
import org.apache.geode.internal.protocol.protobuf.v1.BasicTypes;
import org.apache.geode.internal.protocol.protobuf.v1.MessageExecutionContext;
import org.apache.geode.internal.protocol.protobuf.v1.ProtobufOperationContext;
import org.apache.geode.internal.protocol.protobuf.v1.operations.ProtocolVersionHandler;
import org.apache.geode.internal.protocol.protobuf.v1.state.AcceptMessages;
import org.apache.geode.internal.protocol.protobuf.v1.state.ConnectionState;
import org.apache.geode.internal.protocol.protobuf.v1.state.InvalidSecurity;
import org.apache.geode.internal.protocol.protobuf.v1.state.RequireAuthentication;
import org.apache.geode.internal.protocol.protobuf.v1.state.exception.ConnectionStateException;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class RequireVersion
implements ConnectionState {
    private static final Logger logger = LogService.getLogger();
    private final SecurityService securityService;

    public RequireVersion(SecurityService securityService) {
        this.securityService = securityService;
    }

    @Override
    public void validateOperation(ProtobufOperationContext operationContext) throws ConnectionStateException {
        throw new ConnectionStateException(BasicTypes.ErrorCode.INVALID_REQUEST, "Connection processing should never be asked to validate an operation");
    }

    private ConnectionState nextConnectionState(MessageExecutionContext executionContext) {
        if (this.securityService.isIntegratedSecurity()) {
            return new RequireAuthentication();
        }
        if (this.securityService.isPeerSecurityRequired() || this.securityService.isClientSecurityRequired()) {
            logger.error("The protobuf protocol requires using a security-manager. It does not allow using a security-client-authenticator");
            return new InvalidSecurity();
        }
        return new AcceptMessages();
    }

    @Override
    public boolean handleMessageIndependently(InputStream inputStream, OutputStream outputStream, MessageExecutionContext executionContext) throws IOException {
        PushbackInputStream messageStream = new PushbackInputStream(inputStream);
        messageStream.unread(CommunicationMode.ProtobufClientServerProtocol.getModeNumber());
        if (ProtocolVersionHandler.handleVersionMessage(messageStream, outputStream, executionContext.getStatistics())) {
            executionContext.setState(this.nextConnectionState(executionContext));
        }
        return true;
    }
}

