/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.protocol.protobuf.v1.operations;

import org.apache.geode.annotations.Experimental;
import org.apache.geode.internal.exception.InvalidExecutionContextException;
import org.apache.geode.internal.protocol.operations.ProtobufOperationHandler;
import org.apache.geode.internal.protocol.protobuf.security.SecureCache;
import org.apache.geode.internal.protocol.protobuf.v1.BasicTypes;
import org.apache.geode.internal.protocol.protobuf.v1.Failure;
import org.apache.geode.internal.protocol.protobuf.v1.MessageExecutionContext;
import org.apache.geode.internal.protocol.protobuf.v1.ProtobufSerializationService;
import org.apache.geode.internal.protocol.protobuf.v1.RegionAPI;
import org.apache.geode.internal.protocol.protobuf.v1.Result;
import org.apache.geode.internal.protocol.protobuf.v1.Success;
import org.apache.geode.internal.protocol.protobuf.v1.serialization.exception.DecodingException;
import org.apache.geode.internal.protocol.protobuf.v1.serialization.exception.EncodingException;

@Experimental
public class GetRequestOperationHandler
implements ProtobufOperationHandler<RegionAPI.GetRequest, RegionAPI.GetResponse> {
    @Override
    public Result<RegionAPI.GetResponse> process(ProtobufSerializationService serializationService, RegionAPI.GetRequest request, MessageExecutionContext messageExecutionContext) throws InvalidExecutionContextException, EncodingException, DecodingException {
        String regionName = request.getRegionName();
        Object decodedKey = serializationService.decode(request.getKey());
        if (decodedKey == null) {
            return Failure.of(BasicTypes.ErrorCode.INVALID_REQUEST, "Performing a get on a NULL key.");
        }
        SecureCache secureCache = messageExecutionContext.getSecureCache();
        Object resultValue = secureCache.get(regionName, decodedKey);
        BasicTypes.EncodedValue encodedValue = serializationService.encode(resultValue);
        return Success.of(RegionAPI.GetResponse.newBuilder().setResult(encodedValue).build());
    }
}

