/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.protocol.protobuf.security;

import org.apache.geode.internal.protocol.protobuf.security.Security;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.security.ResourcePermission;
import org.apache.shiro.subject.Subject;

public class ShiroSecurity
implements Security {
    private final Subject subject;
    private final SecurityService securityService;

    public ShiroSecurity(SecurityService securityService, Subject subject) {
        this.securityService = securityService;
        this.subject = subject;
    }

    @Override
    public void authorize(ResourcePermission permission) {
        this.securityService.authorize(permission, this.subject);
    }

    @Override
    public Object postProcess(String regionPath, Object key, Object value) {
        return this.securityService.postProcess(this.subject.getPrincipal(), regionPath, key, value, false);
    }

    @Override
    public boolean needsPostProcessing() {
        return this.securityService.getPostProcessor() != null;
    }
}

